/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.Rectangle;
import com.mapinfo.midev.util.PrivateAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PrivateAPI
public final class Equals {
    private static final Logger LOG = LoggerFactory.getLogger(Equals.class);

    private Equals() {
    }

    public static boolean equivalent(IGeometry expected, IGeometry actual) {
        return Equals.equivalent(expected, actual, expected.getSpatialInfo().getTolerance());
    }

    public static boolean equivalent(IGeometry expected, IGeometry actual, double tolerance) {
        return Equals.equals(expected, actual, tolerance, true);
    }

    public static boolean equals(Envelope expected, Envelope actual) {
        return Equals.equals(expected, actual, expected.getSpatialInfo().getTolerance());
    }

    public static boolean equals(Envelope expected, Envelope actual, double tolerance) {
        return Equals.equals(new Rectangle(expected.getSpatialInfo(), expected.getLowerLeft(), expected.getUpperRight()), new Rectangle(actual.getSpatialInfo(), actual.getLowerLeft(), actual.getUpperRight()), tolerance, false);
    }

    public static boolean equals(IGeometry expected, IGeometry actual) {
        return Equals.equals(expected, actual, expected.getSpatialInfo().getTolerance());
    }

    public static boolean equals(IGeometry expected, IGeometry actual, double tolerance) {
        return Equals.equals(expected, actual, tolerance, false);
    }

    private static boolean equals(IGeometry expected, IGeometry actual, double tolerance, boolean normalize) {
        if (!expected.getCoordSys().equivalent(actual.getCoordSys())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("CoordSys was different - " + expected.getCoordSys().getDisplayName(Locale.getDefault()) + " | " + actual.getCoordSys().getDisplayName(Locale.getDefault()));
            }
            return false;
        }
        if (normalize) {
            expected = Equals.normalize(expected);
            actual = Equals.normalize(actual);
        }
        if (!expected.getType().equals((Object)actual.getType())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Type was different - " + (Object)((Object)expected.getType()) + " | " + (Object)((Object)actual.getType()));
            }
            return false;
        }
        switch (expected.getType()) {
            case POINT: {
                return Equals.equalsPoint((IPoint)expected, (IPoint)actual, tolerance);
            }
            case LINE_STRING: {
                return Equals.equalsLineString((ILineString)expected, (ILineString)actual, tolerance);
            }
            case CURVE: {
                return Equals.equalsCurve((ICurve)expected, (ICurve)actual, tolerance);
            }
            case RING: {
                return Equals.equalsRing((IRing)expected, (IRing)actual, tolerance);
            }
            case POLYGON: {
                return Equals.equalsPolygon((IPolygon)expected, (IPolygon)actual, tolerance);
            }
            case MULTI_POINT: {
                return Equals.equalsMultiPoint((IMultiPoint)expected, (IMultiPoint)actual, tolerance);
            }
            case MULTI_POLYGON: {
                return Equals.equalsMultiPolygon((IMultiPolygon)expected, (IMultiPolygon)actual, tolerance);
            }
            case MULTI_CURVE: {
                return Equals.equalsMultiCurve((IMultiCurve)expected, (IMultiCurve)actual, tolerance);
            }
            case MULTI_FEATURE_GEOMETRY: {
                return Equals.equalsMultiFeatureGeometry((IMultiFeatureGeometry)expected, (IMultiFeatureGeometry)actual, tolerance);
            }
            case RECTANGLE: {
                return Equals.equalsRectangle((IRectangle)expected, (IRectangle)actual, tolerance);
            }
            case ROUNDED_RECTANGLE: {
                return Equals.equalsRoundedRectangle((ILegacyRoundedRectangle)expected, (ILegacyRoundedRectangle)actual, tolerance);
            }
            case ELLIPSE: {
                return Equals.equalsEllipse((ILegacyEllipse)expected, (ILegacyEllipse)actual, tolerance);
            }
            case LEGACY_TEXT: {
                return Equals.equalsText((ILegacyText)expected, (ILegacyText)actual, tolerance);
            }
            case LEGACY_ARC: {
                return Equals.equalsArc((ILegacyArc)expected, (ILegacyArc)actual, tolerance);
            }
        }
        throw new RuntimeException("Unsupported type - " + (Object)((Object)expected.getType()));
    }

    private static boolean equalsPoint(IPoint expected, IPoint actual, double tolerance) {
        return Equals.equalsDirectPosition(expected.getDirectPosition(), actual.getDirectPosition(), tolerance);
    }

    private static boolean equalsLineString(ILineString expected, ILineString actual, double tolerance) {
        return Equals.equalsDirectPositionList(expected.getControlPoints(), actual.getControlPoints(), tolerance);
    }

    private static boolean equalsRing(IRing expected, IRing actual, double tolerance) {
        return Equals.equalsDirectPositionList(expected.asLineString().getControlPoints(), actual.asLineString().getControlPoints(), tolerance);
    }

    private static boolean equalsCurve(ICurve expected, ICurve actual, double tolerance) {
        return Equals.equalsLineString(expected.asLineString(), actual.asLineString(), tolerance);
    }

    private static boolean equalsPolygon(IPolygon expected, IPolygon actual, double tolerance) {
        if (!Equals.equalsRing(expected.getExteriorRing(), actual.getExteriorRing(), tolerance)) {
            return false;
        }
        if (expected.getInteriorRingCount() != actual.getInteriorRingCount()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("InteriorRingCount was different - " + expected.getInteriorRingCount() + " | " + actual.getInteriorRingCount());
            }
            return false;
        }
        Iterator<IRing> iter1 = expected.getInteriorRingIterator();
        Iterator<IRing> iter2 = actual.getInteriorRingIterator();
        while (iter1.hasNext()) {
            if (Equals.equalsRing(iter1.next(), iter2.next(), tolerance)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsMultiPoint(IMultiPoint expected, IMultiPoint actual, double tolerance) {
        return Equals.equalsDirectPositionList(expected.getPositions(), actual.getPositions(), tolerance);
    }

    private static boolean equalsMultiPolygon(IMultiPolygon expected, IMultiPolygon actual, double tolerance) {
        if (expected.getPolygonCount() != actual.getPolygonCount()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PolygonCount was different - " + expected.getPolygonCount() + " | " + actual.getPolygonCount());
            }
            return false;
        }
        Iterator iter1 = expected.iterator();
        Iterator iter2 = actual.iterator();
        while (iter1.hasNext()) {
            if (Equals.equalsPolygon((IPolygon)iter1.next(), (IPolygon)iter2.next(), tolerance)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsMultiCurve(IMultiCurve expected, IMultiCurve actual, double tolerance) {
        if (expected.getCurveCount() != actual.getCurveCount()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("CurveCount was different - " + expected.getCurveCount() + " | " + actual.getCurveCount());
            }
            return false;
        }
        Iterator iter1 = expected.iterator();
        Iterator iter2 = actual.iterator();
        while (iter1.hasNext()) {
            if (Equals.equalsCurve((ICurve)iter1.next(), (ICurve)iter2.next(), tolerance)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsMultiFeatureGeometry(IMultiFeatureGeometry expected, IMultiFeatureGeometry actual, double tolerance) {
        if (expected.getFeatureGeometryCount() != actual.getFeatureGeometryCount()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("FeatureGeometryCount was different - " + expected.getFeatureGeometryCount() + " | " + actual.getFeatureGeometryCount());
            }
            return false;
        }
        Iterator iter1 = expected.iterator();
        Iterator iter2 = actual.iterator();
        while (iter1.hasNext()) {
            if (Equals.equals((IGeometry)iter1.next(), (IGeometry)iter2.next(), tolerance)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsRectangle(IRectangle expected, IRectangle actual, double tolerance) {
        return Equals.equalsDirectPosition(expected.getLowerLeft(), actual.getLowerLeft(), tolerance) && Equals.equalsDirectPosition(expected.getUpperRight(), actual.getUpperRight(), tolerance);
    }

    private static boolean equalsRoundedRectangle(ILegacyRoundedRectangle expected, ILegacyRoundedRectangle actual, double tolerance) {
        return Equals.equalsDirectPosition(expected.getLowerLeft(), actual.getLowerLeft(), tolerance) && Equals.equalsDirectPosition(expected.getUpperRight(), actual.getUpperRight(), tolerance) && expected.getCornerRadiusX().equals((Object)actual.getCornerRadiusX()) && expected.getCornerRadiusY().equals((Object)actual.getCornerRadiusY());
    }

    private static boolean equalsEllipse(ILegacyEllipse expected, ILegacyEllipse actual, double tolerance) {
        return Equals.equalsDirectPosition(expected.getLowerLeft(), actual.getLowerLeft(), tolerance) && Equals.equalsDirectPosition(expected.getUpperRight(), actual.getUpperRight(), tolerance) && Equals.equalsDirectPosition(expected.getCenter(), actual.getCenter(), tolerance) && expected.getXRadius().equals((Object)actual.getXRadius()) && expected.getYRadius().equals((Object)actual.getYRadius());
    }

    private static boolean equalsText(ILegacyText expected, ILegacyText actual, double tolerance) {
        return Equals.equals(expected.getRectangle(), actual.getRectangle(), tolerance) && expected.getText().equals(actual.getText()) && Equals.equals(expected.getAngle(), actual.getAngle()) && Equals.equals((Object)expected.getTextCalloutType(), (Object)actual.getTextCalloutType()) && Equals.equalsLegacyTextDirectPosition(expected.getCalloutTarget(), actual.getCalloutTarget(), tolerance);
    }

    private static boolean equalsLegacyTextDirectPosition(DirectPosition expected, DirectPosition actual, double tolerance) {
        if (expected != null && actual != null) {
            return Equals.equalsDirectPosition(expected, actual, tolerance);
        }
        return (expected != null || actual == null) && (expected == null || actual != null);
    }

    private static boolean equals(Object expected, Object actual) {
        if (expected != null && actual != null) {
            return expected.equals(actual);
        }
        return (expected != null || actual == null) && (expected == null || actual != null);
    }

    private static boolean equalsArc(ILegacyArc expected, ILegacyArc actual, double tolerance) {
        return Equals.equals(expected.asLineString(), actual.asLineString(), tolerance);
    }

    private static boolean equalsDirectPositionList(IDirectPositionList expected, IDirectPositionList actual, double tolerance) {
        if (expected.size() != actual.size()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DPCount was different - " + expected.size() + " | " + actual.size());
            }
            return false;
        }
        DirectPosition dp1 = new DirectPosition();
        DirectPosition dp2 = new DirectPosition();
        for (int i = 0; i < expected.size(); ++i) {
            if (Equals.equalsDirectPosition(expected.getDirectPosition(i, dp1), actual.getDirectPosition(i, dp2), tolerance)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsDirectPosition(DirectPosition dp1, DirectPosition dp2, double tolerance) {
        if (!Equals.equalsDouble(dp1.getX(), dp2.getX(), tolerance) || !Equals.equalsDouble(dp1.getY(), dp2.getY(), tolerance)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("XY was different - " + dp1.toString() + " | " + dp2.toString());
            }
            return false;
        }
        return true;
    }

    private static boolean equalsDouble(double d1, double d2, double tolerance) {
        return Math.abs(d1 - d2) <= tolerance;
    }

    private static IGeometry normalize(IGeometry geometry) {
        switch (geometry.getType()) {
            case POINT: 
            case RECTANGLE: 
            case ROUNDED_RECTANGLE: 
            case ELLIPSE: 
            case LEGACY_TEXT: {
                break;
            }
            case LEGACY_ARC: {
                geometry = Equals.normalizeLineString(((ILegacyArc)geometry).asLineString());
                break;
            }
            case LINE_STRING: {
                geometry = Equals.normalizeLineString((ILineString)geometry);
                break;
            }
            case CURVE: {
                geometry = Equals.normalizeCurve((ICurve)geometry);
                break;
            }
            case RING: {
                geometry = Equals.normalizeRing((IRing)geometry, geometry.getSpatialInfo().getTolerance());
                break;
            }
            case POLYGON: {
                geometry = Equals.normalizePolygon((IPolygon)geometry);
                break;
            }
            case MULTI_POINT: {
                if (((IMultiPoint)geometry).getPointCount() == 1) {
                    geometry = (IGeometry)((IMultiPoint)geometry).iterator().next();
                    break;
                }
                geometry = Equals.normalizeMultiPoint((IMultiPoint)geometry);
                break;
            }
            case MULTI_CURVE: {
                if (((IMultiCurve)geometry).getCurveCount() == 1) {
                    geometry = Equals.normalizeCurve((ICurve)((IMultiCurve)geometry).iterator().next());
                    break;
                }
                geometry = Equals.normalizeMultiCurve((IMultiCurve)geometry);
                break;
            }
            case MULTI_POLYGON: {
                if (((IMultiPolygon)geometry).getPolygonCount() == 1) {
                    geometry = Equals.normalizePolygon((IPolygon)((IMultiPolygon)geometry).iterator().next());
                    break;
                }
                geometry = Equals.normalizeMultiPolygon((IMultiPolygon)geometry);
                break;
            }
            case MULTI_FEATURE_GEOMETRY: {
                geometry = Equals.normalizeMultiFeatureGeometry((IMultiFeatureGeometry)geometry);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type - " + (Object)((Object)geometry.getType()));
            }
        }
        return geometry;
    }

    private static IGeometry normalizeMultiFeatureGeometry(IMultiFeatureGeometry mf) {
        GeometryFactory factory = new GeometryFactory(mf.getSpatialInfo());
        IMultiPoint mp = Equals.normalizeMultiPoint(mf.getAllPoints());
        IMultiCurve mc = Equals.normalizeMultiCurve(mf.getAllCurves());
        IMultiPolygon mpl = Equals.normalizeMultiPolygon(mf.getAllPolygons());
        if (!mp.isEmpty() && mc.isEmpty() && mpl.isEmpty()) {
            if (mp.getPointCount() == 1) {
                return (IGeometry)mp.iterator().next();
            }
            return mp;
        }
        if (mp.isEmpty() && !mc.isEmpty() && mpl.isEmpty()) {
            if (mc.getCurveCount() == 1) {
                return ((ICurve)mc.iterator().next()).asLineString();
            }
            return mc;
        }
        if (mp.isEmpty() && mc.isEmpty() && !mpl.isEmpty()) {
            if (mpl.getPolygonCount() == 1) {
                return (IGeometry)mpl.iterator().next();
            }
            return mpl;
        }
        ArrayList<Iterable<IPoint>> gl = new ArrayList<Iterable<IPoint>>(mf.getFeatureGeometryCount());
        gl.add(mp);
        gl.add(mc);
        gl.add(mpl);
        return factory.newMultiFeatureGeometryFromGeometry(gl);
    }

    private static IMultiCurve normalizeMultiCurve(IMultiCurve mcurve) {
        GeometryFactory factory = new GeometryFactory(mcurve.getSpatialInfo());
        ArrayList<Curve> clist = new ArrayList<Curve>(mcurve.getCurveCount());
        Iterator iter = mcurve.iterator();
        while (iter.hasNext()) {
            clist.add(factory.newCurve(Equals.normalizeLineString(((ICurve)iter.next()).asLineString()).getControlPoints(), GeometryType.LINE_STRING));
        }
        Collections.sort(clist, new Comparator<ICurve>(){

            @Override
            public int compare(ICurve o1, ICurve o2) {
                return Equals.compare(o1.asLineString(), o2.asLineString());
            }
        });
        return factory.newMultiCurve(clist);
    }

    private static IMultiPoint normalizeMultiPoint(IMultiPoint mp) {
        GeometryFactory factory = new GeometryFactory(mp.getSpatialInfo());
        ArrayList clist = new ArrayList(mp.getPointCount());
        Iterator iter = mp.iterator();
        while (iter.hasNext()) {
            clist.add(iter.next());
        }
        Collections.sort(clist, new Comparator<IPoint>(){

            @Override
            public int compare(IPoint o1, IPoint o2) {
                return Equals.compare(o1.getDirectPosition(), o2.getDirectPosition(), o1.getSpatialInfo().getTolerance());
            }
        });
        return factory.newMultiPoint(clist);
    }

    private static IMultiPolygon normalizeMultiPolygon(IMultiPolygon mp) {
        GeometryFactory factory = new GeometryFactory(mp.getSpatialInfo());
        ArrayList<IPolygon> clist = new ArrayList<IPolygon>(mp.getPolygonCount());
        Iterator iter = mp.iterator();
        while (iter.hasNext()) {
            clist.add(Equals.normalizePolygon((IPolygon)iter.next()));
        }
        Collections.sort(clist, new Comparator<IPolygon>(){

            @Override
            public int compare(IPolygon o1, IPolygon o2) {
                return Equals.compare(o1, o2);
            }
        });
        return factory.newMultiPolygon(clist);
    }

    private static ILineString normalizeCurve(ICurve curve) {
        return Equals.normalizeLineString(curve.asLineString());
    }

    private static ILineString normalizeLineString(ILineString line) {
        DirectPosition dp2;
        DirectPosition dp1 = line.getStartPosition();
        if (Equals.compare(dp1, dp2 = line.getEndPosition(), line.getSpatialInfo().getTolerance()) > 0) {
            return line.reverse();
        }
        return line;
    }

    private static IPolygon normalizePolygon(IPolygon polygon) {
        double tolerance = polygon.getSpatialInfo().getTolerance();
        IRing outerRing = Equals.normalizeRing(polygon.getExteriorRing(), tolerance);
        ArrayList<IRing> innerRings = new ArrayList<IRing>(polygon.getInteriorRingCount());
        if (polygon.getInteriorRingCount() > 0) {
            Iterator<IRing> inners = polygon.getInteriorRingIterator();
            while (inners.hasNext()) {
                innerRings.add(Equals.normalizeRing(inners.next(), tolerance));
            }
            Collections.sort(innerRings, new Comparator<IRing>(){

                @Override
                public int compare(IRing o1, IRing o2) {
                    return Equals.compare(o1, o2);
                }
            });
        }
        return new GeometryFactory(polygon.getSpatialInfo()).newPolygon(outerRing, innerRings);
    }

    public static IRing normalizeRing(IRing ring, double tolerance) {
        IDirectPositionList dpl = ring.asLineString().getControlPoints();
        if (GeometryUtilities.Orientation.COUNTER_CLOCKWISE.equals((Object)GeometryUtilities.orientation(ring))) {
            dpl = dpl.reverse();
        }
        DirectPosition dp1 = dpl.getDirectPosition(0, new DirectPosition());
        int startindex = 0;
        double minX = dp1.getX();
        double minY = dp1.getY();
        boolean isEndOfString = false;
        boolean foundDuplicatedPoint = false;
        for (int i = 1; i < dpl.size(); ++i) {
            if (Equals.equalsDouble((dp1 = dpl.getDirectPosition(i, dp1)).getX(), minX, tolerance)) {
                if (Equals.equalsDouble(dp1.getY(), minY, tolerance) && !isEndOfString) {
                    startindex = i;
                    foundDuplicatedPoint = true;
                    continue;
                }
                if (dp1.getY() < minY) {
                    startindex = i;
                    minX = dp1.getX();
                    minY = dp1.getY();
                    isEndOfString = false;
                    foundDuplicatedPoint = false;
                    continue;
                }
                if (!foundDuplicatedPoint) continue;
                isEndOfString = true;
                continue;
            }
            if (dp1.getX() < minX) {
                startindex = i;
                minX = dp1.getX();
                minY = dp1.getY();
                isEndOfString = false;
                foundDuplicatedPoint = false;
                continue;
            }
            if (!foundDuplicatedPoint) continue;
            isEndOfString = true;
        }
        if (startindex != 0) {
            int i;
            DirectPositionArray dpa = new DirectPositionArray(dpl.size());
            for (i = startindex; i < dpl.size(); ++i) {
                dpa.add(dpl.getDirectPosition(i, dp1));
            }
            for (i = 1; i < startindex; ++i) {
                dpa.add(dpl.getDirectPosition(i, dp1));
            }
            dpa.add(dpa.getDirectPosition(0, dp1));
            dpl = dpa;
        }
        return new GeometryFactory(ring.getSpatialInfo()).newRing(dpl, GeometryType.LINE_STRING);
    }

    private static int compare(IPolygon p1, IPolygon p2) {
        int result = Equals.compare(p1.getExteriorRing(), p2.getExteriorRing());
        if (result == 0 && p1.getInteriorRingCount() > 0) {
            Iterator<IRing> iter1 = p1.getInteriorRingIterator();
            Iterator<IRing> iter2 = p2.getInteriorRingIterator();
            while (iter1.hasNext()) {
                if (!iter2.hasNext()) {
                    return 1;
                }
                result = Equals.compare(iter1.next(), iter2.next());
                if (result == 0) continue;
                break;
            }
        }
        return result;
    }

    private static int compare(IRing r1, IRing r2) {
        return Equals.compare(r1.asLineString(), r2.asLineString());
    }

    private static int compare(ILineString ls1, ILineString ls2) {
        return Equals.compare(ls1.getControlPoints(), ls2.getControlPoints(), ls1.getSpatialInfo().getTolerance());
    }

    private static int compare(IDirectPositionList ls1, IDirectPositionList ls2, double tolerance) {
        DirectPosition dp1 = new DirectPosition();
        DirectPosition dp2 = new DirectPosition();
        int result = 0;
        for (int i = 0; i < ls1.size(); ++i) {
            if (i >= ls2.size()) {
                return 1;
            }
            result = Equals.compare(dp1 = ls1.getDirectPosition(i, dp1), dp2 = ls2.getDirectPosition(i, dp2), tolerance);
            if (result != 0) break;
        }
        return result;
    }

    private static int compare(DirectPosition dp1, DirectPosition dp2, double tolerance) {
        int result;
        if (Equals.equalsDouble(dp1.getX(), dp2.getX(), tolerance)) {
            if (Equals.equalsDouble(dp1.getY(), dp2.getY(), tolerance)) {
                return 0;
            }
            result = Double.compare(dp1.getY(), dp2.getY());
        } else {
            result = Double.compare(dp1.getX(), dp2.getX());
        }
        return result;
    }
}

