/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.unit.Offset;
import com.mapinfo.midev.util.DoubleRect;

public final class GeometryOperationsUtilities {
    static boolean equivalentPositions(SpatialInfo sp1, SpatialInfo sp2) {
        if (sp1 == sp2) {
            return true;
        }
        if (sp1 == null || sp2 == null) {
            return false;
        }
        if (!sp1.getCoordSys().equivalent(sp2.getCoordSys())) {
            return false;
        }
        return GeometryOperationsUtilities.equivalentZUnits(sp1.getZUnit(), sp2.getZUnit());
    }

    private static boolean equivalentZUnits(LinearUnit z1, LinearUnit z2) {
        if (z1 == z2) {
            return true;
        }
        if (z1 == null || z2 == null) {
            return false;
        }
        return z1.equals((Object)z2);
    }

    public static void adjustPointsUsingDistance(DirectPosition pnt1, DirectPosition pnt2, CoordSys csys, Offset goal, boolean bMoveBoth, boolean bAdjustX) {
        double dDistance = goal.getValue();
        DoubleRect userBounds = csys.getMBR();
        boolean bDone = false;
        dDistance = Math.abs(dDistance);
        for (int i = 0; i < 10 && !bDone; ++i) {
            double deltay;
            double deltax;
            double curdist = MeasurementUtilities.length(pnt1, pnt2, csys).getValue(goal.getUnit());
            if (curdist == 0.0) {
                if (bAdjustX) {
                    double d = deltax = pnt1.getX() != 0.0 ? pnt1.getX() / 100.0 : 1.0;
                    if (bMoveBoth) {
                        pnt1.setX(pnt1.getX() + deltax);
                    }
                    pnt2.setX(pnt2.getX() - deltax);
                    continue;
                }
                double d = deltay = pnt1.getY() != 0.0 ? pnt1.getY() / 100.0 : 1.0;
                if (bMoveBoth) {
                    pnt1.setY(pnt1.getY() + deltay);
                }
                pnt2.setY(pnt2.getY() - deltay);
                continue;
            }
            double dMult = dDistance / curdist - 1.0;
            if (Math.abs(dMult) < 1.0E-6) {
                bDone = true;
            } else {
                deltax = (pnt2.getX() - pnt1.getX()) * dMult;
                deltay = (pnt2.getY() - pnt1.getY()) * dMult;
                if (bMoveBoth) {
                    pnt1.setX(pnt1.getX() - (deltax /= 2.0));
                    pnt1.setY(pnt1.getY() - (deltay /= 2.0));
                }
                pnt2.setX(pnt2.getX() + deltax);
                pnt2.setY(pnt2.getY() + deltay);
            }
            if (bMoveBoth && !userBounds.contains(pnt1)) {
                GeometryOperationsUtilities.clip(pnt1, userBounds);
                bDone = true;
            }
            if (userBounds.contains(pnt2)) continue;
            GeometryOperationsUtilities.clip(pnt1, userBounds);
            bDone = true;
        }
    }

    private static void clip(DirectPosition pnt, DoubleRect bounds) {
        pnt.setX(Math.min(pnt.getX(), bounds.getMaxX()));
        pnt.setX(Math.max(pnt.getX(), bounds.getMinX()));
        pnt.setY(Math.min(pnt.getY(), bounds.getMaxY()));
        pnt.setY(Math.max(pnt.getY(), bounds.getMinY()));
    }
}

