/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.MultiFeatureGeometry;
import com.mapinfo.midev.geometry.jts.JTSGeometryConvertor;
import com.mapinfo.midev.geometry.operations.GeometryOperations;
import com.mapinfo.midev.geometry.operations.IAggregatedOperation;
import com.mapinfo.midev.geometry.operations.s2.CutterType;
import com.mapinfo.midev.geometry.operations.s2.EraseOutside;
import com.mapinfo.midev.geometry.util.LegacyGeometryUtilities;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.unit.Offset;
import com.mapinfo.midev.util.ArgumentValidator;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Intersection
implements IAggregatedOperation {
    private static final Logger LOG = LoggerFactory.getLogger(Intersection.class);
    private final GeometryFactory m_geometryFactory;
    private Geometry m_currentJTSIntersection;
    private IGeometry m_currentS2Intersection;
    private CoordSys m_coordSys;

    public Intersection(GeometryFactory geometryFactory) {
        ArgumentValidator.assertNotNullReference((String)"geometryFactory", (Object)geometryFactory);
        this.m_geometryFactory = geometryFactory;
    }

    @Override
    public void add(IGeometry geom) {
        if (geom == null) {
            return;
        }
        if (this.m_coordSys == null) {
            this.m_coordSys = geom.getCoordSys();
        }
        if (this.m_currentS2Intersection == null) {
            this.m_currentS2Intersection = geom;
            return;
        }
        if (this.m_currentS2Intersection.isEmpty()) {
            this.m_currentJTSIntersection = null;
            return;
        }
        if (this.m_currentJTSIntersection != null && this.m_currentJTSIntersection.isEmpty()) {
            if (!this.m_currentS2Intersection.isEmpty()) {
                this.m_currentS2Intersection = this.m_geometryFactory.newMultiFeatureGeometry();
            }
            this.m_currentJTSIntersection = null;
            return;
        }
        if (geom.isEmpty()) {
            this.m_currentS2Intersection = this.m_geometryFactory.newMultiFeatureGeometry();
            this.m_currentJTSIntersection = null;
            return;
        }
        boolean inputIsAreaGeom = this.isFullyAreaGeometry(geom);
        boolean s2IsAreaGeom = this.isFullyAreaGeometry(this.m_currentS2Intersection);
        if (inputIsAreaGeom && s2IsAreaGeom) {
            this.m_currentS2Intersection = Intersection.intersectUsingS2(this.m_currentS2Intersection, geom);
        } else if (this.m_currentJTSIntersection == null) {
            Geometry convertedS2Geom = Intersection.convertToJTSWithFixOfInvalidGeometry(this.m_currentS2Intersection);
            this.m_currentJTSIntersection = Intersection.intersectUsingJTS(convertedS2Geom, geom, this.m_coordSys);
            this.m_currentS2Intersection = null;
        } else {
            this.m_currentJTSIntersection = Intersection.intersectUsingJTS(this.m_currentJTSIntersection, geom, this.m_coordSys);
        }
    }

    private static Geometry intersectUsingJTS(Geometry jtsGeom, IGeometry inputGeom, CoordSys coordSys) {
        Geometry intersectionGeom = Intersection.convertToJTSWithFixOfInvalidGeometry(inputGeom = GeometryUtilities.convertIfNecessary(inputGeom, coordSys));
        if (intersectionGeom != null) {
            return JTSGeometryConvertor.prepareGeometryForOperations(jtsGeom.intersection(intersectionGeom));
        }
        return JTSGeometryConvertor.createEmptyGeometry();
    }

    private static IGeometry intersectUsingS2(IGeometry geometry1, IGeometry geometry2) {
        geometry2 = GeometryUtilities.convertIfNecessary(geometry2, geometry1.getCoordSys());
        if (!geometry1.getEnvelope().intersects(geometry2.getEnvelope())) {
            return new MultiFeatureGeometry(geometry1.getSpatialInfo());
        }
        CutterType geometry1CutterType = Intersection.getCutterType(geometry1, null);
        CutterType geometry2CutterType = Intersection.getCutterType(geometry2, geometry1CutterType);
        EraseOutside eraseOutside = new EraseOutside(geometry1.getSpatialInfo());
        eraseOutside.add(geometry1, geometry1CutterType);
        eraseOutside.add(geometry2, geometry2CutterType);
        return eraseOutside.result();
    }

    private static CutterType getCutterType(IGeometry geometry, CutterType currentlyUsedCutterType) {
        if (geometry.getDimension() == 2 && (currentlyUsedCutterType == null || currentlyUsedCutterType == CutterType.NONE)) {
            return CutterType.EXTERIOR;
        }
        return CutterType.NONE;
    }

    private boolean isFullyAreaGeometry(IGeometry geom) {
        if (geom == null) {
            return false;
        }
        if (geom instanceof IMultiFeatureGeometry) {
            IMultiFeatureGeometry mfGeom = (IMultiFeatureGeometry)geom;
            for (IFeatureGeometry subGeom : mfGeom) {
                if (this.isFullyAreaGeometry(subGeom)) continue;
                return false;
            }
            return true;
        }
        return geom.getDimension() == 2;
    }

    private static Geometry convertToJTSWithFixOfInvalidGeometry(IGeometry geom) {
        Geometry geometry = JTSGeometryConvertor.convert(geom);
        if (!geometry.isValid() && !(geometry = JTSGeometryConvertor.convert(geom = GeometryOperations.buffer(geom, new Offset(0.1, LinearUnit.MILLIMETER)))).isValid()) {
            IsValidOp validOp = new IsValidOp(geometry);
            TopologyValidationError err = validOp.getValidationError();
            LOG.error("Intersection: " + err.toString());
            geometry = JTSGeometryConvertor.createEmptyGeometry();
        }
        return geometry;
    }

    @Override
    public void addMultiple(Iterable<? extends IGeometry> geoms) {
        for (IGeometry iGeometry : geoms) {
            this.add(iGeometry);
        }
    }

    @Override
    public IFeatureGeometry result() {
        if (this.m_currentJTSIntersection != null && this.m_currentS2Intersection != null) {
            return JTSGeometryConvertor.convert(Intersection.intersectUsingJTS(this.m_currentJTSIntersection, this.m_currentS2Intersection, this.m_coordSys), this.m_geometryFactory.getSpatialInfo());
        }
        if (this.m_currentJTSIntersection != null) {
            return JTSGeometryConvertor.convert(this.m_currentJTSIntersection, this.m_geometryFactory.getSpatialInfo());
        }
        if (this.m_currentS2Intersection != null) {
            return this.m_geometryFactory.newFeatureGeometry(LegacyGeometryUtilities.toNonLegacyGeometry(this.m_currentS2Intersection));
        }
        return this.m_geometryFactory.newMultiFeatureGeometry();
    }
}

