/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations;

import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.jts.JTSGeometryConvertor;
import com.mapinfo.midev.geometry.operations.IPreparedGeometryOperation;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;

public final class PreparedGeometryOperationSupport<T> {
    private final IPreparedGeometryOperation<T> m_geometryOperation;
    private IGeometry m_prevFirst;
    private Geometry m_prevJtsFirst;
    private PreparedGeometry m_prevJtsPreparedFirst;
    private IGeometry m_prevSecond;
    private Geometry m_prevJtsSecond;

    public PreparedGeometryOperationSupport(IPreparedGeometryOperation<T> geometryOperation) {
        this.m_geometryOperation = geometryOperation;
    }

    public T doOperation(IGeometry first, IGeometry second) {
        Geometry jtsSecond;
        PreparedGeometry jtsPreparedFirst;
        Geometry jtsFirst;
        if (first.isTransient()) {
            jtsFirst = JTSGeometryConvertor.convert(first);
            jtsPreparedFirst = null;
        } else if (first == this.m_prevFirst) {
            jtsFirst = this.m_prevJtsFirst;
            jtsPreparedFirst = this.m_prevJtsPreparedFirst;
        } else {
            this.m_prevFirst = first;
            this.m_prevJtsFirst = JTSGeometryConvertor.convert(first);
            this.m_prevJtsPreparedFirst = JTSGeometryConvertor.createPreparedGeometry(this.m_prevJtsFirst);
            jtsFirst = this.m_prevJtsFirst;
            jtsPreparedFirst = this.m_prevJtsPreparedFirst;
        }
        if (second.isTransient()) {
            second = GeometryUtilities.convertIfNecessary(second, first.getCoordSys());
            jtsSecond = JTSGeometryConvertor.convert(second);
        } else if (second == this.m_prevSecond) {
            jtsSecond = this.m_prevJtsSecond;
        } else {
            this.m_prevSecond = second;
            second = GeometryUtilities.convertIfNecessary(second, first.getCoordSys());
            jtsSecond = this.m_prevJtsSecond = JTSGeometryConvertor.convert(second);
        }
        if (jtsPreparedFirst == null) {
            return this.m_geometryOperation.doOperation(jtsFirst, jtsSecond, first.getSpatialInfo());
        }
        return this.m_geometryOperation.doOperation(jtsPreparedFirst, jtsSecond, first.getSpatialInfo());
    }
}

