/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.cartesian;

import com.mapinfo.midev.geometry.DirectPosition;
import java.awt.geom.Point2D;

public final class Cartesian {
    private Cartesian() {
    }

    public static double distanceXY(DirectPosition dp1, DirectPosition dp2) {
        return Point2D.distance(dp1.getX(), dp1.getY(), dp2.getX(), dp2.getY());
    }

    public static DirectPosition interpolate(DirectPosition p1, DirectPosition p2, double frac, DirectPosition result) {
        if (result == null) {
            result = new DirectPosition();
        }
        if (frac == 0.0) {
            result.set(p1);
        } else if (frac == 1.0) {
            result.set(p2);
        } else {
            result.set(frac * p2.getX() + (1.0 - frac) * p1.getX(), frac * p2.getY() + (1.0 - frac) * p1.getY(), frac * p2.getZ() + (1.0 - frac) * p1.getZ(), null);
        }
        return result;
    }

    public static double interpolate(DirectPosition query, DirectPosition ref0, DirectPosition ref1) {
        double diffX = ref1.getX() - ref0.getX();
        double diffY = ref1.getY() - ref0.getY();
        double result = Math.abs(diffX) > Math.abs(diffY) ? (query.getX() - ref0.getX()) / diffX : (diffY == 0.0 && query.equalsXY(ref0) ? 0.0 : (query.getY() - ref0.getY()) / diffY);
        return result;
    }

    public static Turn turn(DirectPosition p0, DirectPosition p1, DirectPosition p2) {
        return Cartesian.turn(p0.getX(), p0.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static Turn turn(double x0, double y0, double x1, double y1, double x2, double y2) {
        double dot = (y1 - y0) * (x2 - x0) + -(x1 - x0) * (y2 - y0);
        if (dot > 0.0) {
            return Turn.CW;
        }
        if (dot < 0.0) {
            return Turn.CCW;
        }
        return Turn.COLINEAR;
    }

    public static double dotProduct(DirectPosition v1, DirectPosition v2) {
        return v1.getX() * v2.getX() + v1.getY() * v2.getY();
    }

    public static DirectPosition intersect(DirectPosition v11, DirectPosition v12, DirectPosition longv11, DirectPosition longv12, DirectPosition v21, DirectPosition v22, DirectPosition longv21, DirectPosition longv22, double tol, IntersectResult result) {
        double dy2;
        boolean parallel = false;
        boolean intersects = false;
        DirectPosition intPos = result != null && result.m_intersectionPoint != null ? result.m_intersectionPoint : new DirectPosition();
        double dx1 = longv12.getX() - longv11.getX();
        double dy1 = longv12.getY() - longv11.getY();
        double dx2 = longv22.getX() - longv21.getX();
        double detinv = dx2 * dy1 - (dy2 = longv22.getY() - longv21.getY()) * dx1;
        if (detinv == 0.0) {
            parallel = true;
            intPos.set(Double.NaN, Double.NaN, Double.NaN, null);
        } else {
            parallel = false;
            double dx21 = longv21.getX() - longv11.getX();
            double dy21 = longv21.getY() - longv11.getY();
            double s = (dx2 * dy21 - dy2 * dx21) / detinv;
            double t = (dx1 * dy21 - dy1 * dx21) / detinv;
            Cartesian.interpolate(longv21, longv22, t, intPos);
            double zV2 = intPos.getZ();
            Cartesian.interpolate(longv11, longv12, s, intPos);
            if (Double.isNaN(intPos.getZ())) {
                intPos.setZ(zV2);
            } else if (!Double.isNaN(zV2)) {
                intPos.setZ((intPos.getZ() + zV2) / 2.0);
            }
            if (tol >= 0.0) {
                if (Cartesian.distanceXY(intPos, v11) <= tol) {
                    intPos.set(v11.getX(), v11.getY(), v11.getZ(), v11.getM());
                    intersects = true;
                } else if (Cartesian.distanceXY(intPos, v12) <= tol) {
                    intPos.set(v12.getX(), v12.getY(), v12.getZ(), v12.getM());
                    intersects = true;
                }
                if (Cartesian.distanceXY(intPos, v21) <= tol) {
                    if (!intersects) {
                        intPos.set(v21.getX(), v21.getY(), v21.getZ(), v21.getM());
                    }
                    intersects = true;
                } else if (Cartesian.distanceXY(intPos, v22) <= tol) {
                    if (!intersects) {
                        intPos.set(v22.getX(), v22.getY(), v22.getZ(), v22.getM());
                    }
                    intersects = true;
                }
            }
            if (!intersects) {
                double s0 = Cartesian.interpolate(v11, longv11, longv12);
                double s1 = Cartesian.interpolate(v12, longv11, longv12);
                double t0 = Cartesian.interpolate(v21, longv21, longv22);
                double t1 = Cartesian.interpolate(v22, longv21, longv22);
                if (s >= s0 && s <= s1 && t >= t0 && t <= t1) {
                    intersects = true;
                }
            }
            if (intPos.getM() == null) {
                if (intPos.equalsXY(v11)) {
                    intPos.setM(v11.getM());
                } else if (intPos.equalsXY(v12)) {
                    intPos.setM(v12.getM());
                } else if (intPos.equalsXY(v21)) {
                    intPos.setM(v21.getM());
                } else if (intPos.equalsXY(v22)) {
                    intPos.setM(v22.getM());
                }
            }
        }
        if (result != null) {
            result.m_intersects = intersects;
            result.m_parallel = parallel;
            result.m_intersectionPoint = intPos;
        }
        return intPos;
    }

    public static DirectPosition projectPointOnVector(DirectPosition pt, DirectPosition vp1, DirectPosition vp2) {
        double denom;
        double dy;
        DirectPosition proj = new DirectPosition();
        double dx21 = vp2.getX() - vp1.getX();
        double dy21 = vp2.getY() - vp1.getY();
        double dx = vp1.getX() - pt.getX();
        double t = -(dx21 * dx + dy21 * (dy = vp1.getY() - pt.getY())) / (denom = dx21 * dx21 + dy21 * dy21);
        if (Double.isNaN(t)) {
            t = 0.5;
        }
        t = Math.min(Math.max(t, 0.0), 1.0);
        Cartesian.interpolate(vp1, vp2, t, proj);
        if (Double.isNaN(proj.getZ())) {
            proj.setZ(pt.getZ());
        }
        return proj;
    }

    public static final class IntersectResult {
        private boolean m_parallel;
        private boolean m_intersects;
        private DirectPosition m_intersectionPoint;

        public IntersectResult() {
            this(false, false, null);
        }

        private IntersectResult(boolean parallel, boolean intersects, DirectPosition intersectionPoint) {
            this.m_parallel = parallel;
            this.m_intersects = intersects;
            this.m_intersectionPoint = intersectionPoint == null ? null : new DirectPosition(intersectionPoint);
        }

        public boolean isParallel() {
            return this.m_parallel;
        }

        public boolean intersects() {
            return this.m_intersects;
        }

        public DirectPosition getIntersectionPoint() {
            return this.m_intersectionPoint;
        }
    }

    public static enum Turn {
        CCW,
        CW,
        COLINEAR;

    }
}

