/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.cartesian.contains;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.operations.cartesian.contains.RingContainsPoint;
import com.mapinfo.midev.geometry.operations.edge.prepared.RingGroup;
import java.util.List;

public final class PolygonContainsPoint {
    private PolygonContainsPoint() {
    }

    public static boolean contains(IMultiPolygon polygon, DirectPosition pt) {
        return PolygonContainsPoint.contains(RingGroup.getInstance(polygon, false), pt);
    }

    public static boolean contains(IPolygon polygon, DirectPosition pt) {
        return PolygonContainsPoint.contains(RingGroup.getInstance(polygon, false), pt);
    }

    public static boolean contains(List<RingGroup> ringGroupList, DirectPosition pt) {
        for (RingGroup ringGroup : ringGroupList) {
            if (!PolygonContainsPoint.contains(ringGroup, pt)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(RingGroup ringGroup, DirectPosition pt) {
        if (!RingContainsPoint.containsWithBoundary(ringGroup.getOuterRing(), pt)) {
            return false;
        }
        for (IRing ring : ringGroup.getInnerRings()) {
            if (!RingContainsPoint.containsWithoutBoundary(ring, pt)) continue;
            return false;
        }
        return true;
    }
}

