/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.cartesian.contains;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.operations.cartesian.intersects.LineIntersectsPoint;
import com.mapinfo.midev.geometry.operations.edge.prepared.IPreparedGeometry;
import com.mapinfo.midev.geometry.operations.rtree.JordanWidget;
import com.mapinfo.midev.geometry.operations.rtree.PointIntersectsWidget;
import com.mapinfo.midev.util.DoubleRect;

public final class RingContainsPoint {
    private RingContainsPoint() {
    }

    public static boolean containsWithBoundary(IRing ring, DirectPosition dp) {
        if (ring instanceof IPreparedGeometry ? !((IPreparedGeometry)((Object)ring)).getHelper().envelopeContains(dp) : !ring.getEnvelope().contains(dp)) {
            return false;
        }
        boolean bContains = RingContainsPoint.insideOrPartialBoundary(ring, dp);
        if (!bContains) {
            bContains = RingContainsPoint.onBoundary(ring, dp);
        }
        return bContains;
    }

    public static boolean containsWithoutBoundary(IRing ring, DirectPosition dp) {
        if (ring instanceof IPreparedGeometry ? !((IPreparedGeometry)((Object)ring)).getHelper().envelopeContains(dp) : !ring.getEnvelope().contains(dp)) {
            return false;
        }
        boolean bContains = RingContainsPoint.insideOrPartialBoundary(ring, dp);
        if (bContains) {
            bContains = !RingContainsPoint.onBoundary(ring, dp);
        }
        return bContains;
    }

    public static boolean insideOrPartialBoundary(IRing ring, DirectPosition dp) {
        int count;
        if (ring instanceof IPreparedGeometry && ((IPreparedGeometry)((Object)ring)).getHelper().isIndexed()) {
            DoubleRect searchMbr = new DoubleRect(dp, dp);
            searchMbr.setMinX(Double.NEGATIVE_INFINITY);
            JordanWidget counter = new JordanWidget(dp);
            ((IPreparedGeometry)((Object)ring)).getHelper().getIndexedEdges(true).search(searchMbr, counter);
            count = counter.getJordanCount();
        } else {
            DirectPosition start = new DirectPosition();
            DirectPosition end = new DirectPosition();
            count = 0;
            for (ICurveSegment cs : ring) {
                if (cs.getType() != GeometryType.LINE_STRING) {
                    cs = cs.asLineString();
                }
                IDirectPositionIterator dpIter = cs.getControlPointIterator();
                dpIter.nextDirectPosition(start);
                while (dpIter.hasNext()) {
                    dpIter.nextDirectPosition(end);
                    if (RingContainsPoint.intersectLeftRay(start, end, dp)) {
                        ++count;
                    }
                    start.set(end);
                }
            }
        }
        return count % 2 == 1;
    }

    private static boolean onBoundary(IRing ring, DirectPosition dp) {
        if (ring instanceof IPreparedGeometry && ((IPreparedGeometry)((Object)ring)).getHelper().isIndexed()) {
            DoubleRect searchMbr = new DoubleRect(dp, dp);
            PointIntersectsWidget intersectsWidget = new PointIntersectsWidget(dp, 0.0);
            ((IPreparedGeometry)((Object)ring)).getHelper().getIndexedEdges(true).search(searchMbr, intersectsWidget);
            return intersectsWidget.intersects();
        }
        for (ICurveSegment cs : ring) {
            if (!LineIntersectsPoint.intersects(cs, dp)) continue;
            return true;
        }
        return false;
    }

    private static boolean intersectLeftRay(DirectPosition p0, DirectPosition p1, DirectPosition pq) {
        return RingContainsPoint.intersectLeftRay(p0.getX(), p0.getY(), p1.getX(), p1.getY(), pq.getX(), pq.getY());
    }

    public static boolean intersectLeftRay(double x0, double y0, double x1, double y1, double xq, double yq) {
        if (y1 < y0) {
            double tmp = x0;
            x0 = x1;
            x1 = tmp;
            tmp = y0;
            y0 = y1;
            y1 = tmp;
        }
        if (yq >= y1 || yq < y0) {
            return false;
        }
        if (xq < x0 && xq < x1) {
            return false;
        }
        if (x0 < xq && x1 < xq) {
            return true;
        }
        double xi = x0 + (x1 - x0) * (yq - y0) / (y1 - y0);
        return xi < xq;
    }
}

