/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.cartesian.intersects;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.operations.cartesian.contains.PolygonContainsPoint;
import com.mapinfo.midev.geometry.operations.cartesian.intersects.PolygonIntersectsEdge;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.edge.prepared.GeometryOperationsHelper;
import com.mapinfo.midev.geometry.operations.edge.prepared.RingGroup;
import java.util.List;

public final class CartesianIntersects {
    private CartesianIntersects() {
    }

    public static boolean intersects(IGeometry left, IGeometry right) {
        if (!left.getEnvelope().intersects(right.getEnvelope())) {
            return false;
        }
        GeometryOperationsHelper leftHelper = GeometryOperationsHelper.getInstance(left, false);
        GeometryOperationsHelper rightHelper = GeometryOperationsHelper.getInstance(right, false);
        if (rightHelper.isIndexed() && !leftHelper.isIndexed()) {
            GeometryOperationsHelper tmp = rightHelper;
            rightHelper = leftHelper;
            leftHelper = tmp;
        }
        if (CartesianIntersects.testAreaAgainstPoints(leftHelper.getArea(), rightHelper.getPoints()) || CartesianIntersects.testAreaAgainstPoints(rightHelper.getArea(), leftHelper.getPoints())) {
            return true;
        }
        if (CartesianIntersects.testAreaAgainstEdges(leftHelper.getArea(), rightHelper) || CartesianIntersects.testAreaAgainstEdges(rightHelper.getArea(), leftHelper)) {
            return true;
        }
        if (CartesianIntersects.testCurvesAgainstPoints(leftHelper.getCurvesAsEdges(true), rightHelper.getPoints())) {
            return true;
        }
        if (CartesianIntersects.testCurvesAgainstPoints(rightHelper.getCurvesAsEdges(true), leftHelper.getPoints())) {
            return true;
        }
        for (Edge leftCurve : leftHelper.getCurvesAsEdges(true)) {
            for (Edge rightCurve : rightHelper.getCurvesAsEdges(true)) {
                if (!leftCurve.intersects(rightCurve, 0.0)) continue;
                return true;
            }
        }
        for (DirectPosition leftPoint : leftHelper.getPoints()) {
            for (DirectPosition rightPoint : rightHelper.getPoints()) {
                if (!leftPoint.equalsXY(rightPoint)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean testAreaAgainstPoints(List<RingGroup> area, List<DirectPosition> points) {
        for (DirectPosition point : points) {
            if (!PolygonContainsPoint.contains(area, point)) continue;
            return true;
        }
        return false;
    }

    private static boolean testAreaAgainstEdges(List<RingGroup> area, GeometryOperationsHelper rightHelper) {
        List<Edge> edges = rightHelper.getLineAndAreaEdges(true);
        for (Edge edge : edges) {
            if (!PolygonIntersectsEdge.intersects(area, edge)) continue;
            return true;
        }
        return false;
    }

    private static boolean testCurvesAgainstPoints(List<Edge> curves, List<DirectPosition> points) {
        for (Edge leftCurve : curves) {
            for (DirectPosition rightPoint : points) {
                if (!leftCurve.intersects(rightPoint, 0.0)) continue;
                return true;
            }
        }
        return false;
    }
}

