/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.cartesian.intersects;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.util.MathUtil;

public final class PointOnLine {
    private final double m_xq;
    private final double m_yq;
    private final double m_tolerance;
    private final double m_toleranceSquared;
    private double m_x0;
    private double m_y0;
    private boolean m_bFirstTime;

    public PointOnLine(DirectPosition startPt, DirectPosition qp, double tolerance) {
        this.m_x0 = startPt.getX();
        this.m_y0 = startPt.getY();
        this.m_xq = qp.getX();
        this.m_yq = qp.getY();
        this.m_tolerance = tolerance;
        this.m_toleranceSquared = MathUtil.square((double)tolerance);
        this.m_bFirstTime = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pointOnLine(DirectPosition endPt) {
        double x1 = endPt.getX();
        double y1 = endPt.getY();
        try {
            double yi;
            double yDist;
            boolean bXok;
            double xi;
            double xDist;
            boolean bYok;
            if (this.m_bFirstTime && MathUtil.square((double)(this.m_x0 - this.m_xq)) + MathUtil.square((double)(this.m_y0 - this.m_yq)) <= this.m_toleranceSquared) {
                boolean bl = true;
                return bl;
            }
            this.m_bFirstTime = false;
            boolean bl = this.m_y0 <= y1 ? this.m_y0 <= this.m_yq && this.m_yq <= y1 : (bYok = y1 <= this.m_yq && this.m_yq <= this.m_y0);
            if (bYok && (xDist = Math.abs((xi = this.m_x0 + (x1 - this.m_x0) * (this.m_yq - this.m_y0) / (y1 - this.m_y0)) - this.m_xq)) <= this.m_tolerance) {
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = this.m_x0 <= x1 ? this.m_x0 <= this.m_xq && this.m_xq <= x1 : (bXok = x1 <= this.m_xq && this.m_xq <= this.m_x0);
            if (bXok && (yDist = Math.abs((yi = this.m_y0 + (y1 - this.m_y0) * (this.m_xq - this.m_x0) / (x1 - this.m_x0)) - this.m_yq)) <= this.m_tolerance) {
                boolean bl4 = true;
                return bl4;
            }
            if (bYok && bXok) {
                boolean bl5 = false;
                return bl5;
            }
            boolean bl6 = MathUtil.square((double)(x1 - this.m_xq)) + MathUtil.square((double)(y1 - this.m_yq)) <= this.m_toleranceSquared;
            return bl6;
        }
        finally {
            this.m_x0 = x1;
            this.m_y0 = y1;
        }
    }

    public static boolean pointOnLine(double x0, double y0, double x1, double y1, double xq, double yq, double tolerance) {
        double yi;
        double yDist;
        boolean bXok;
        double xi;
        double xDist;
        boolean bYok;
        if (y1 < y0) {
            double tmp = x0;
            x0 = x1;
            x1 = tmp;
            tmp = y0;
            y0 = y1;
            y1 = tmp;
        }
        boolean bl = bYok = y0 <= yq && yq <= y1;
        if (bYok && (xDist = Math.abs((xi = x0 + (x1 - x0) * (yq - y0) / (y1 - y0)) - xq)) <= tolerance) {
            return true;
        }
        boolean bl2 = x0 <= x1 ? x0 <= xq && xq <= x1 : (bXok = x1 <= xq && xq <= x0);
        if (bXok && (yDist = Math.abs((yi = y0 + (y1 - y0) * (xq - x0) / (x1 - x0)) - yq)) <= tolerance) {
            return true;
        }
        if (bYok && bXok) {
            return false;
        }
        double tolsqr = MathUtil.square((double)tolerance);
        if (MathUtil.square((double)(x0 - xq)) + MathUtil.square((double)(y0 - yq)) <= tolsqr) {
            return true;
        }
        return MathUtil.square((double)(x1 - xq)) + MathUtil.square((double)(y1 - yq)) <= tolsqr;
    }
}

