/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.cartesian.intersects;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.operations.cartesian.contains.RingContainsPoint;
import com.mapinfo.midev.geometry.operations.cartesian.intersects.RingIntersectsLine;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.edge.prepared.RingGroup;
import java.util.List;

final class PolygonIntersectsEdge {
    private PolygonIntersectsEdge() {
    }

    public static boolean intersects(List<RingGroup> ringGroupList, Edge edge) {
        for (RingGroup ringGroup : ringGroupList) {
            if (!PolygonIntersectsEdge.intersects(ringGroup, edge)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersects(RingGroup polygon, Edge edge) {
        if (!polygon.getOuterRing().getEnvelope().asDoubleRect().intersects(edge.getBounds())) {
            return false;
        }
        if (RingIntersectsLine.crossesBoundary(polygon.getOuterRing(), edge)) {
            return true;
        }
        for (IRing innerRing : polygon.getInnerRings()) {
            if (!RingIntersectsLine.crossesBoundary(innerRing, edge)) continue;
            return true;
        }
        DirectPosition pt = edge.getPoint1();
        if (!RingContainsPoint.insideOrPartialBoundary(polygon.getOuterRing(), pt)) {
            return false;
        }
        for (IRing innerRing : polygon.getInnerRings()) {
            if (!RingContainsPoint.insideOrPartialBoundary(innerRing, pt)) continue;
            return false;
        }
        return true;
    }
}

