/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.clip;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.geometry.impl.MultiFeatureGeometry;
import com.mapinfo.midev.geometry.impl.MultiPoint;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.impl.Polygon;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.jts.JTSGeometryConvertor;
import com.mapinfo.midev.geometry.operations.clip.CohenSutherland;
import com.mapinfo.midev.geometry.operations.clip.SutherlandHodgeman;
import com.mapinfo.midev.util.DoubleRect;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.TopologyException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClipOp {
    private final DoubleRect m_window;
    private static final Logger LOG = LoggerFactory.getLogger(ClipOp.class);

    public ClipOp(DoubleRect window) {
        this.m_window = window;
    }

    public IGeometry clip(IGeometry geometry) {
        DoubleRect mbr = geometry.getEnvelope().asDoubleRect();
        if (!mbr.intersects(this.m_window)) {
            return null;
        }
        if (this.m_window.contains(mbr)) {
            return geometry;
        }
        switch (geometry.getType()) {
            case POINT: {
                return this.clip((IPoint)geometry);
            }
            case MULTI_POINT: {
                return this.clip((IMultiPoint)geometry);
            }
            case LINE_STRING: {
                return this.clip((ILineString)geometry);
            }
            case CURVE: {
                return this.clip(((ICurve)geometry).asLineString());
            }
            case MULTI_CURVE: {
                return this.clip((IMultiCurve)geometry);
            }
            case RING: {
                return this.clip((IRing)geometry);
            }
            case POLYGON: {
                return this.clip((IPolygon)geometry);
            }
            case MULTI_POLYGON: {
                return this.clip((IMultiPolygon)geometry);
            }
            case MULTI_FEATURE_GEOMETRY: {
                return this.clip((IMultiFeatureGeometry)geometry);
            }
            case RECTANGLE: {
                return this.clip(((IRectangle)geometry).asMultiPolygon());
            }
            case ROUNDED_RECTANGLE: {
                return this.clip(((ILegacyRoundedRectangle)geometry).asMultiPolygon());
            }
            case ELLIPSE: {
                return this.clip(((ILegacyEllipse)geometry).asMultiPolygon());
            }
            case LEGACY_ARC: {
                return this.clip(((ILegacyArc)geometry).asMultiCurve());
            }
            case LEGACY_TEXT: {
                return this.clip((ILegacyText)geometry);
            }
        }
        throw new IllegalArgumentException("Unable to clip geometry type: " + (Object)((Object)geometry.getType()));
    }

    private Point clip(IPoint point) {
        return this.m_window.contains(point.getDirectPosition()) ? new Point(point.getSpatialInfo(), point.getDirectPosition()) : null;
    }

    private MultiPoint clip(IMultiPoint multiPoint) {
        DirectPositionArray result = new DirectPositionArray(multiPoint.getPointCount());
        DirectPosition tmp = new DirectPosition();
        IDirectPositionIterator i = multiPoint.getDirectPositionIterator();
        while (i.hasNext()) {
            i.nextDirectPosition(tmp);
            if (!this.m_window.contains(tmp)) continue;
            result.add(tmp);
        }
        return result.isEmpty() ? null : new MultiPoint(multiPoint.getSpatialInfo(), result);
    }

    private MultiCurve clip(ILineString lineString) {
        return CohenSutherland.clip(lineString, this.m_window);
    }

    private MultiCurve clip(IMultiCurve multiCurve) {
        ArrayList<Curve> result = new ArrayList<Curve>();
        for (ICurve curve : multiCurve) {
            MultiCurve clippedCurve = this.clip(curve.asLineString());
            if (clippedCurve == null) continue;
            for (ICurve c : clippedCurve) {
                result.add((Curve)c);
            }
        }
        return result.isEmpty() ? null : new MultiCurve(multiCurve.getSpatialInfo(), result);
    }

    private Ring clip(IRing ring) {
        return SutherlandHodgeman.clip(ring, this.m_window);
    }

    private MultiPolygon clip(IPolygon polygon) {
        if (polygon.getInteriorRingCount() == 0) {
            Ring outerRing = this.clip(polygon.getExteriorRing());
            if (outerRing == null) {
                return null;
            }
            return new MultiPolygon(outerRing.getSpatialInfo(), outerRing);
        }
        IFeatureGeometry resultGeometry = new MultiPolygon(polygon.getSpatialInfo());
        try {
            resultGeometry = JTSGeometryConvertor.convert(JTSGeometryConvertor.convert(polygon).intersection((Geometry)JTSGeometryConvertor.convert(new Envelope(this.m_window, polygon.getSpatialInfo()))), polygon.getSpatialInfo());
        }
        catch (TopologyException tpx) {
            LOG.error("Topologically incorrect geometry detected");
            return new MultiPolygon(polygon.getSpatialInfo(), (Polygon)polygon);
        }
        catch (IllegalArgumentException iax) {
            LOG.error("Unable to handle input geometry of type: " + polygon.getType().toString());
            return new MultiPolygon(polygon.getSpatialInfo(), (Polygon)polygon);
        }
        catch (Exception ex) {
            LOG.error("Unexpected: " + ex.getMessage());
            return new MultiPolygon(polygon.getSpatialInfo(), (Polygon)polygon);
        }
        if (resultGeometry.isEmpty()) {
            return new MultiPolygon(resultGeometry.getSpatialInfo());
        }
        if (resultGeometry instanceof MultiPolygon) {
            return (MultiPolygon)resultGeometry;
        }
        LOG.error("Unable to handle feature geometry of type: " + resultGeometry.getType().toString());
        return new MultiPolygon(polygon.getSpatialInfo(), (Polygon)polygon);
    }

    private MultiPolygon clip(IMultiPolygon multiPolygon) {
        ArrayList<Polygon> result = new ArrayList<Polygon>(multiPolygon.getPolygonCount());
        for (IPolygon polygon : multiPolygon) {
            MultiPolygon clippedPolygon = this.clip(polygon);
            if (clippedPolygon == null) continue;
            for (IPolygon p : clippedPolygon) {
                result.add((Polygon)p);
            }
        }
        return result.isEmpty() ? null : new MultiPolygon(multiPolygon.getSpatialInfo(), result);
    }

    private MultiFeatureGeometry clip(IMultiFeatureGeometry multiFeatureGeometry) {
        ArrayList<Point> pointList = new ArrayList<Point>(multiFeatureGeometry.getCount(GeometryType.POINT));
        ArrayList<MultiPoint> multiPointList = new ArrayList<MultiPoint>(multiFeatureGeometry.getCount(GeometryType.MULTI_POINT));
        ArrayList<MultiCurve> multiCurveList = new ArrayList<MultiCurve>(multiFeatureGeometry.getCount(GeometryType.MULTI_CURVE));
        ArrayList<MultiPolygon> multiPolygonList = new ArrayList<MultiPolygon>(multiFeatureGeometry.getCount(GeometryType.MULTI_POLYGON));
        Iterator<IFeatureGeometry> i = multiFeatureGeometry.getPointIterator();
        while (i.hasNext()) {
            CollectionUtils.addIgnoreNull(pointList, (Object)this.clip(i.next()));
        }
        i = multiFeatureGeometry.getMultiPointIterator();
        while (i.hasNext()) {
            CollectionUtils.addIgnoreNull(multiPointList, (Object)this.clip((IMultiPoint)i.next()));
        }
        i = multiFeatureGeometry.getMultiCurveIterator();
        while (i.hasNext()) {
            CollectionUtils.addIgnoreNull(multiCurveList, (Object)this.clip((IMultiCurve)i.next()));
        }
        i = multiFeatureGeometry.getMultiPolygonIterator();
        while (i.hasNext()) {
            CollectionUtils.addIgnoreNull(multiPolygonList, (Object)this.clip((IMultiPolygon)i.next()));
        }
        if (pointList.isEmpty() && multiPointList.isEmpty() && multiCurveList.isEmpty() && multiPolygonList.isEmpty()) {
            return null;
        }
        return new MultiFeatureGeometry(multiFeatureGeometry.getSpatialInfo(), pointList, multiPointList, multiCurveList, multiPolygonList);
    }

    private ILegacyText clip(ILegacyText text) {
        return this.clip(text.getRectangle().asMultiPolygon()) != null ? text : null;
    }
}

