/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.clip;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.geometry.operations.clip.OutCode;
import com.mapinfo.midev.util.DoubleRect;
import java.util.ArrayList;

final class CohenSutherland {
    private CohenSutherland() {
    }

    static MultiCurve clip(ICurveSegment pointList, DoubleRect window) {
        GeometryFactory geometryFactory = new GeometryFactory(pointList.getSpatialInfo());
        ArrayList<Curve> result = new ArrayList<Curve>();
        DirectPositionArray part = new DirectPositionArray();
        DirectPosition a = new DirectPosition();
        DirectPosition b = new DirectPosition();
        DirectPosition lastPosition = new DirectPosition();
        IDirectPositionIterator pointIterator = pointList.getControlPointIterator();
        pointIterator.nextDirectPosition(a);
        byte codeA = OutCode.computeOutCode(a, window);
        while (pointIterator.hasNext()) {
            byte lastCode;
            pointIterator.nextDirectPosition(b);
            lastPosition.set(b);
            byte codeB = lastCode = OutCode.computeOutCode(b, window);
            while (true) {
                if ((codeA | codeB) == 0) {
                    part.add(a);
                    if (codeB != lastCode) {
                        part.add(b);
                        if (!pointIterator.hasNext()) break;
                        result.add(geometryFactory.newCurve(part, GeometryType.LINE_STRING));
                        part = new DirectPositionArray();
                        if (codeB != 0 || lastCode == 0) break;
                        b.set(lastPosition);
                        break;
                    }
                    if (pointIterator.hasNext()) break;
                    part.add(b);
                    break;
                }
                if ((codeA & codeB) != 0) break;
                if (codeA != 0) {
                    a = OutCode.intersection(a, b, codeA, window);
                    codeA = OutCode.computeOutCode(a, window);
                    continue;
                }
                b = OutCode.intersection(a, b, codeB, window);
                codeB = OutCode.computeOutCode(b, window);
            }
            a.set(b);
            codeA = lastCode;
        }
        if (!part.isEmpty()) {
            result.add(geometryFactory.newCurve(part, GeometryType.LINE_STRING));
        }
        return result.isEmpty() ? null : geometryFactory.newMultiCurve(result);
    }
}

