/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.clip;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.util.DoubleRect;

final class OutCode {
    private static final byte INSIDE = 0;
    private static final byte LEFT = 1;
    private static final byte RIGHT = 2;
    private static final byte BOTTOM = 4;
    private static final byte TOP = 8;
    private static final byte[] EDGE_LIST = new byte[]{1, 2, 4, 8};

    private OutCode() {
    }

    static byte[] edges() {
        return EDGE_LIST;
    }

    static DirectPosition intersection(DirectPosition a, DirectPosition b, byte edge, DoubleRect window) {
        if ((edge & 8) != 0) {
            return new DirectPosition(a.getX() + (b.getX() - a.getX()) * (window.getMaxY() - a.getY()) / (b.getY() - a.getY()), window.getMaxY());
        }
        if ((edge & 4) != 0) {
            return new DirectPosition(a.getX() + (b.getX() - a.getX()) * (window.getMinY() - a.getY()) / (b.getY() - a.getY()), window.getMinY());
        }
        if ((edge & 2) != 0) {
            return new DirectPosition(window.getMaxX(), a.getY() + (b.getY() - a.getY()) * (window.getMaxX() - a.getX()) / (b.getX() - a.getX()));
        }
        if ((edge & 1) != 0) {
            return new DirectPosition(window.getMinX(), a.getY() + (b.getY() - a.getY()) * (window.getMinX() - a.getX()) / (b.getX() - a.getX()));
        }
        return null;
    }

    static byte computeOutCode(DirectPosition p, DoubleRect window) {
        return OutCode.computeOutCode(p.getX(), p.getY(), window);
    }

    static byte computeOutCode(double x, double y, DoubleRect window) {
        byte code = 0;
        if (x < window.getMinX()) {
            code = (byte)(code | 1);
        } else if (x > window.getMaxX()) {
            code = (byte)(code | 2);
        }
        if (y < window.getMinY()) {
            code = (byte)(code | 4);
        } else if (y > window.getMaxY()) {
            code = (byte)(code | 8);
        }
        return code;
    }
}

