/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.clip;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.operations.clip.OutCode;
import com.mapinfo.midev.util.DoubleRect;

final class SutherlandHodgeman {
    private SutherlandHodgeman() {
    }

    static Ring clip(IRing ring, DoubleRect window) {
        IDirectPositionList result = SutherlandHodgeman.clip(ring.asLineString().getControlPoints(), window);
        return result == null ? null : new Ring(ring.getSpatialInfo(), new LineString(ring.getSpatialInfo(), result));
    }

    private static IDirectPositionList clip(IDirectPositionList pointList, DoubleRect window) {
        DirectPositionArray result = new DirectPositionArray(pointList.size());
        DirectPosition prev = new DirectPosition();
        DirectPosition pt = new DirectPosition();
        for (byte edge : OutCode.edges()) {
            result.clear();
            pointList.getDirectPosition(pointList.size() - 1, prev);
            boolean prevInside = (OutCode.computeOutCode(prev, window) & edge) == 0;
            IDirectPositionIterator i = pointList.getDirectPositionIterator();
            while (i.hasNext()) {
                boolean inside;
                i.nextDirectPosition(pt);
                boolean bl = inside = (OutCode.computeOutCode(pt, window) & edge) == 0;
                if (inside != prevInside) {
                    result.add(OutCode.intersection(prev, pt, edge, window));
                }
                if (inside) {
                    result.add(pt.getX(), pt.getY());
                }
                prev.set(pt);
                prevInside = inside;
            }
            pointList = new DirectPositionArray(result);
            if (pointList.isEmpty()) break;
        }
        return result.isEmpty() ? null : SutherlandHodgeman.makeClosed(result);
    }

    private static DirectPositionArray makeClosed(DirectPositionArray pts) {
        if (pts.getX(0) != pts.getX(pts.size() - 1) || pts.getY(0) != pts.getY(pts.size() - 1)) {
            pts.add(pts.getX(0), pts.getY(0));
        }
        return pts;
    }
}

