/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.edge;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.operations.cartesian.intersects.PointOnLine;
import com.mapinfo.midev.geometry.operations.edge.DistanceResult;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.edge.EdgeFactory;
import com.mapinfo.midev.util.MathUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;

public final class CartesianOps {
    private CartesianOps() {
    }

    public static DistanceResult distance(DirectPosition pt1, DirectPosition pt2) {
        double dx = pt1.getX() - pt2.getX();
        double dy = pt1.getY() - pt2.getY();
        DistanceResult result = new DistanceResult();
        result.setA(pt1);
        result.setB(pt2);
        result.setProxyDistance2(dx * dx + dy * dy);
        return result;
    }

    public static boolean intersects(Edge.CartesianEdge edge, DirectPosition pt, double tolerance) {
        return PointOnLine.pointOnLine(edge.getPoint1().getX(), edge.getPoint1().getY(), edge.getPoint2().getX(), edge.getPoint2().getY(), pt.getX(), pt.getY(), tolerance);
    }

    public static boolean intersects(Edge.CartesianEdge left, Edge.CartesianEdge right, double tolerance) {
        if (CartesianOps.intersectVecVec(left.getPoint1().getX(), left.getPoint1().getY(), left.getPoint2().getX(), left.getPoint2().getY(), right.getPoint1().getX(), right.getPoint1().getY(), right.getPoint2().getX(), right.getPoint2().getY(), null)) {
            return true;
        }
        double toleranceSquared = MathUtil.square((double)tolerance);
        double distance2 = CartesianOps.distance(right, left.getPoint1(), null);
        if (distance2 <= toleranceSquared) {
            return true;
        }
        distance2 = CartesianOps.distance(right, left.getPoint2(), null);
        if (distance2 <= toleranceSquared) {
            return true;
        }
        distance2 = CartesianOps.distance(left, right.getPoint1(), null);
        if (distance2 <= toleranceSquared) {
            return true;
        }
        distance2 = CartesianOps.distance(left, right.getPoint2(), null);
        return distance2 <= toleranceSquared;
    }

    public static DistanceResult distance(Edge.CartesianEdge edge, DirectPosition pt) {
        DirectPosition vectorPt = new DirectPosition();
        double distance2 = CartesianOps.distance(edge, pt, vectorPt);
        DistanceResult result = new DistanceResult();
        result.setA(pt);
        result.setB(vectorPt);
        result.setProxyDistance2(distance2);
        return result;
    }

    public static DistanceResult distance(Edge.CartesianEdge left, Edge.CartesianEdge right) {
        DirectPosition ptOnLeft = new DirectPosition();
        DirectPosition ptOnRight = new DirectPosition();
        double distance2 = CartesianOps.distance(left, right, ptOnLeft, ptOnRight);
        DistanceResult result = new DistanceResult();
        result.setA(ptOnLeft);
        result.setB(ptOnRight);
        result.setProxyDistance2(distance2);
        return result;
    }

    private static double distance(Edge.CartesianEdge edge, DirectPosition pt, DirectPosition vectorPt) {
        double proj_pt_y;
        double proj_pt_x;
        double denom;
        double dy;
        double dx21 = edge.getPoint2().getX() - edge.getPoint1().getX();
        double dy21 = edge.getPoint2().getY() - edge.getPoint1().getY();
        double dx = edge.getPoint1().getX() - pt.getX();
        double t = -(dx21 * dx + dy21 * (dy = edge.getPoint1().getY() - pt.getY())) / (denom = dx21 * dx21 + dy21 * dy21);
        if (t > 0.0) {
            if (t < 1.0) {
                proj_pt_x = edge.getPoint1().getX() + t * dx21;
                proj_pt_y = edge.getPoint1().getY() + t * dy21;
            } else {
                proj_pt_x = edge.getPoint2().getX();
                proj_pt_y = edge.getPoint2().getY();
            }
        } else {
            proj_pt_x = edge.getPoint1().getX();
            proj_pt_y = edge.getPoint1().getY();
        }
        dx = proj_pt_x - pt.getX();
        dy = proj_pt_y - pt.getY();
        double distance2 = dx * dx + dy * dy;
        if (vectorPt != null) {
            vectorPt.setXY(proj_pt_x, proj_pt_y);
        }
        return distance2;
    }

    private static double distance(Edge.CartesianEdge left, Edge.CartesianEdge right, DirectPosition ptOnLeft, DirectPosition ptOnRight) {
        double d;
        double d2;
        double d3;
        if (CartesianOps.intersectVecVec(left.getPoint1().getX(), left.getPoint1().getY(), left.getPoint2().getX(), left.getPoint2().getY(), right.getPoint1().getX(), right.getPoint1().getY(), right.getPoint2().getX(), right.getPoint2().getY(), ptOnLeft)) {
            if (ptOnRight != null) {
                ptOnRight.set(ptOnLeft);
            }
            return 0.0;
        }
        double min = CartesianOps.distance(right, left.getPoint1(), ptOnRight);
        if (ptOnLeft != null) {
            ptOnLeft.setXY(left.getPoint1().getX(), left.getPoint1().getY());
        }
        DirectPosition p = new DirectPosition();
        double newmin = CartesianOps.distance(right, left.getPoint2(), p);
        if (d3 < min) {
            min = newmin;
            if (ptOnLeft != null) {
                ptOnLeft.setXY(left.getPoint2().getX(), left.getPoint2().getY());
            }
            if (ptOnRight != null) {
                ptOnRight.set(p);
            }
        }
        newmin = CartesianOps.distance(left, right.getPoint1(), p);
        if (d2 < min) {
            min = newmin;
            if (ptOnRight != null) {
                ptOnRight.setXY(right.getPoint1().getX(), right.getPoint1().getY());
            }
            if (ptOnLeft != null) {
                ptOnLeft.set(p);
            }
        }
        newmin = CartesianOps.distance(left, right.getPoint2(), p);
        if (d < min) {
            min = newmin;
            if (ptOnRight != null) {
                ptOnRight.setXY(right.getPoint2().getX(), right.getPoint2().getY());
            }
            if (ptOnLeft != null) {
                ptOnLeft.set(p);
            }
        }
        return min;
    }

    private static boolean intersectVecVec(double v11_x, double v11_y, double v12_x, double v12_y, double v21_x, double v21_y, double v22_x, double v22_y, DirectPosition intersectionPoint) {
        double dx1 = v12_x - v11_x;
        double dy1 = v12_y - v11_y;
        double dx2 = v22_x - v21_x;
        double dy2 = v22_y - v21_y;
        double detinv = dx2 * dy1 - dy2 * dx1;
        double dx21 = v21_x - v11_x;
        double dy21 = v21_y - v11_y;
        double s = (dx2 * dy21 - dy2 * dx21) / detinv;
        double t = (dx1 * dy21 - dy1 * dx21) / detinv;
        if (s >= 0.0 && s <= 1.0 && t >= 0.0 && t <= 1.0) {
            if (intersectionPoint != null) {
                intersectionPoint.setXY(v11_x + dx1 * s, v11_y + dy1 * s);
            }
            return true;
        }
        return false;
    }

    public static EdgeIntersectsRelation relate(Edge left, Edge right, double tolerance) {
        DirectPosition pt = new DirectPosition();
        if (CartesianOps.intersectVecVec(left.getPoint1().getX(), left.getPoint1().getY(), left.getPoint2().getX(), left.getPoint2().getY(), right.getPoint1().getX(), right.getPoint1().getY(), right.getPoint2().getX(), right.getPoint2().getY(), pt)) {
            return new EdgeIntersectsRelation(true, pt, null);
        }
        double toleranceSquared = MathUtil.square((double)tolerance);
        LinkedHashSet<DirectPosition> intersectionPoints = new LinkedHashSet<DirectPosition>(4);
        double distance2 = CartesianOps.distance((Edge.CartesianEdge)right, left.getPoint1(), null);
        if (distance2 <= toleranceSquared) {
            intersectionPoints.add(left.getPoint1());
        }
        if ((distance2 = CartesianOps.distance((Edge.CartesianEdge)right, left.getPoint2(), null)) <= toleranceSquared) {
            intersectionPoints.add(left.getPoint2());
        }
        if ((distance2 = CartesianOps.distance((Edge.CartesianEdge)left, right.getPoint1(), null)) <= toleranceSquared) {
            intersectionPoints.add(right.getPoint1());
        }
        if ((distance2 = CartesianOps.distance((Edge.CartesianEdge)left, right.getPoint2(), null)) <= toleranceSquared) {
            intersectionPoints.add(right.getPoint2());
        }
        switch (intersectionPoints.size()) {
            case 4: {
                return new EdgeIntersectsRelation(true, null, left);
            }
            case 2: {
                Iterator i = intersectionPoints.iterator();
                Edge edge = new EdgeFactory(true).newEdge((DirectPosition)i.next(), (DirectPosition)i.next());
                return new EdgeIntersectsRelation(true, null, edge);
            }
            case 1: {
                return new EdgeIntersectsRelation(true, (DirectPosition)intersectionPoints.iterator().next(), null);
            }
        }
        return new EdgeIntersectsRelation(false, null, null);
    }

    public static class EdgeIntersectsRelation {
        private boolean m_intersects;
        private DirectPosition m_intersectionPoint;
        private Edge m_intersectionEdge;

        EdgeIntersectsRelation(boolean intersects, DirectPosition intersectionPoint, Edge intersectionEdge) {
            this.m_intersects = intersects;
            this.m_intersectionPoint = intersectionPoint;
            this.m_intersectionEdge = intersectionEdge;
        }

        public boolean isIntersects() {
            return this.m_intersects;
        }

        public DirectPosition getIntersectionPoint() {
            return this.m_intersectionPoint;
        }

        public Edge getIntersectionEdge() {
            return this.m_intersectionEdge;
        }
    }
}

