/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.edge;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.operations.edge.SphericalOps;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class DistanceResult {
    private final DirectPosition m_A = new DirectPosition();
    private final DirectPosition m_B = new DirectPosition();
    private double m_proxyDistance2 = Double.POSITIVE_INFINITY;
    private boolean m_aIs3D = false;
    private boolean m_bIs3D = false;

    public DirectPosition getA() {
        return this.m_A;
    }

    public DirectPosition getB() {
        return this.m_B;
    }

    public void setA(double x, double y) {
        this.m_A.setXY(x, y);
        this.m_aIs3D = false;
    }

    public void setB(double x, double y) {
        this.m_B.setXY(x, y);
        this.m_bIs3D = false;
    }

    public void setA(DirectPosition newA) {
        this.m_A.set(newA);
    }

    public void setB(DirectPosition newB) {
        this.m_B.set(newB);
    }

    public void setA(DirectPosition newA, boolean transformed) {
        this.m_A.set(newA);
        this.m_aIs3D = transformed;
    }

    public void setB(DirectPosition newB, boolean transformed) {
        this.m_B.set(newB);
        this.m_bIs3D = transformed;
    }

    public double getProxyDistance2() {
        return this.m_proxyDistance2;
    }

    public void setProxyDistance2(double proxyDistance2) {
        this.m_proxyDistance2 = proxyDistance2;
    }

    public Pair<DirectPosition, DirectPosition> getPoints() {
        DirectPosition pt1 = this.m_A;
        DirectPosition pt2 = this.m_B;
        if (this.m_aIs3D) {
            pt1 = SphericalOps.toLLFrom3D(pt1);
        }
        if (this.m_bIs3D) {
            pt2 = SphericalOps.toLLFrom3D(pt2);
        }
        return new ImmutablePair((Object)pt1, (Object)pt2);
    }

    public Length getDistance(CoordSys csys, ComputationType model) {
        if (this.m_proxyDistance2 == 0.0) {
            return new Length(0.0, LinearUnit.METER, model);
        }
        Pair<DirectPosition, DirectPosition> pts = this.getPoints();
        return MeasurementUtilities.length((DirectPosition)pts.getLeft(), (DirectPosition)pts.getRight(), csys, model);
    }
}

