/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.edge;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.operations.edge.CartesianOps;
import com.mapinfo.midev.geometry.operations.edge.DistanceResult;
import com.mapinfo.midev.geometry.operations.edge.SphericalOps;
import com.mapinfo.midev.util.DoubleRect;
import java.io.Serializable;

public abstract class Edge
implements Serializable {
    private final DirectPosition m_point1 = new DirectPosition();
    private final DirectPosition m_point2 = new DirectPosition();
    private final boolean m_isCartesian;

    private Edge(boolean isCartesian, DirectPosition pt1, DirectPosition pt2) {
        this.m_isCartesian = isCartesian;
        this.m_point1.setXY(pt1.getX(), pt1.getY());
        this.m_point2.setXY(pt2.getX(), pt2.getY());
    }

    public boolean isCartesian() {
        return this.m_isCartesian;
    }

    public DirectPosition getPoint1() {
        return this.m_point1;
    }

    public DirectPosition getPoint2() {
        return this.m_point2;
    }

    public abstract DirectPosition getTransA();

    public abstract DirectPosition getTransB();

    public abstract DoubleRect getBounds();

    public abstract DistanceResult distance(DirectPosition var1);

    public abstract DistanceResult distance(Edge var1);

    public abstract boolean intersects(DirectPosition var1, double var2);

    public abstract boolean intersects(Edge var1, double var2);

    static final class SphericalEdge
    extends Edge {
        private final DirectPosition m_transA;
        private final DirectPosition m_transB;
        private final DirectPosition m_cross;
        private final DoubleRect m_bounds;

        public SphericalEdge(DirectPosition pt1, DirectPosition pt2) {
            super(false, pt1, pt2);
            this.m_transA = SphericalOps.to3DFromLL(pt1);
            this.m_transB = SphericalOps.to3DFromLL(pt2);
            this.m_cross = SphericalEdge.crossProduct(this.m_transA, this.m_transB);
            this.m_bounds = new DoubleRect(this.m_transA, this.m_transB);
            SphericalEdge.extendMbrByGreatCircle(this.m_bounds, this.m_transA, this.m_transB, this.m_cross);
        }

        @Override
        public DirectPosition getTransA() {
            return this.m_transA;
        }

        @Override
        public DirectPosition getTransB() {
            return this.m_transB;
        }

        public DirectPosition getCross() {
            return this.m_cross;
        }

        @Override
        public DoubleRect getBounds() {
            return this.m_bounds;
        }

        @Override
        public DistanceResult distance(DirectPosition pt) {
            return SphericalOps.distance(this, pt);
        }

        @Override
        public DistanceResult distance(Edge right) {
            SphericalEdge.verifyEdge(right);
            return SphericalOps.distance(this, (SphericalEdge)right);
        }

        @Override
        public boolean intersects(DirectPosition pt, double tolerance) {
            return SphericalOps.intersects(this, pt, tolerance);
        }

        @Override
        public boolean intersects(Edge edge2, double tolerance) {
            SphericalEdge.verifyEdge(edge2);
            return SphericalOps.intersects(this, (SphericalEdge)edge2, tolerance);
        }

        private static void verifyEdge(Edge edge) {
            if (!(edge instanceof SphericalEdge)) {
                throw new IllegalArgumentException();
            }
        }

        private static DirectPosition crossProduct(DirectPosition A, DirectPosition B) {
            return new DirectPosition(A.getY() * B.getZ() - A.getZ() * B.getY(), A.getZ() * B.getX() - A.getX() * B.getZ(), A.getX() * B.getY() - A.getY() * B.getX());
        }

        private static void extendMbrByGreatCircle(DoubleRect mbr, DirectPosition A, DirectPosition B, DirectPosition AxB) {
            SphericalEdge.extendMbrByGreatCircleOneAxis(mbr, A, B, AxB, 1.0, 0.0, 0.0);
            SphericalEdge.extendMbrByGreatCircleOneAxis(mbr, A, B, AxB, 0.0, 1.0, 0.0);
            SphericalEdge.extendMbrByGreatCircleOneAxis(mbr, A, B, AxB, 0.0, 0.0, 1.0);
        }

        private static void extendMbrByGreatCircleOneAxis(DoubleRect mbr, DirectPosition A, DirectPosition B, DirectPosition AxB, double x_unit, double y_unit, double z_unit) {
            double notX = 1.0 - x_unit;
            double notY = 1.0 - y_unit;
            double notZ = 1.0 - z_unit;
            double AxB_len2 = AxB.getX() * AxB.getX() + AxB.getY() * AxB.getY() + AxB.getZ() * AxB.getZ();
            double dot = notX * AxB.getX() * AxB.getX() + notY * AxB.getY() * AxB.getY() + notZ * AxB.getZ() * AxB.getZ();
            double temp = dot / AxB_len2;
            DirectPosition maxZ = new DirectPosition(notX * AxB.getX() - AxB.getX() * temp, notY * AxB.getY() - AxB.getY() * temp, notZ * AxB.getZ() - AxB.getZ() * temp);
            temp = Math.sqrt(maxZ.getX() * maxZ.getX() + maxZ.getY() * maxZ.getY() + maxZ.getZ() * maxZ.getZ());
            if (Math.abs(temp) < 1.0E-20) {
                maxZ.setXYZ(x_unit, y_unit, z_unit);
            } else {
                maxZ.setXYZ(maxZ.getX() / temp, maxZ.getY() / temp, maxZ.getZ() / temp);
            }
            dot = (maxZ.getY() * A.getZ() - maxZ.getZ() * A.getY()) * (maxZ.getY() * B.getZ() - maxZ.getZ() * B.getY()) + (maxZ.getZ() * A.getX() - maxZ.getX() * A.getZ()) * (maxZ.getZ() * B.getX() - maxZ.getX() * B.getZ()) + (maxZ.getX() * A.getY() - maxZ.getY() * A.getX()) * (maxZ.getX() * B.getY() - maxZ.getY() * B.getX());
            if (dot < 0.0) {
                dot = maxZ.getX() * (A.getX() + B.getX()) + maxZ.getY() * (A.getY() + B.getY()) + maxZ.getZ() * (A.getZ() + B.getZ());
                if (dot < 0.0) {
                    maxZ.setXYZ(-maxZ.getX(), -maxZ.getY(), -maxZ.getZ());
                }
                mbr.merge(maxZ);
            }
        }
    }

    static final class CartesianEdge
    extends Edge {
        private final DoubleRect m_bounds;

        public CartesianEdge(DirectPosition pt1, DirectPosition pt2) {
            super(true, pt1, pt2);
            this.m_bounds = new DoubleRect(pt1, pt2);
        }

        @Override
        public DirectPosition getTransA() {
            return this.getPoint1();
        }

        @Override
        public DirectPosition getTransB() {
            return this.getPoint2();
        }

        @Override
        public DoubleRect getBounds() {
            return this.m_bounds;
        }

        @Override
        public DistanceResult distance(DirectPosition pt) {
            return CartesianOps.distance(this, pt);
        }

        @Override
        public DistanceResult distance(Edge right) {
            CartesianEdge.verifyEdge(right);
            return CartesianOps.distance(this, (CartesianEdge)right);
        }

        @Override
        public boolean intersects(DirectPosition pt, double tolerance) {
            return CartesianOps.intersects(this, pt, tolerance);
        }

        @Override
        public boolean intersects(Edge edge2, double tolerance) {
            CartesianEdge.verifyEdge(edge2);
            return CartesianOps.intersects(this, (CartesianEdge)edge2, tolerance);
        }

        private static void verifyEdge(Edge edge) {
            if (!(edge instanceof CartesianEdge)) {
                throw new IllegalArgumentException();
            }
        }
    }
}

