/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.edge;

import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.util.DoubleRect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class EdgeList
implements Iterable<Edge>,
Serializable {
    private final List<Edge> m_edges;
    private final DoubleRect m_bounds;
    private final boolean m_isCartesian;

    public EdgeList(boolean isCartesian) {
        this.m_isCartesian = isCartesian;
        this.m_edges = new ArrayList<Edge>();
        this.m_bounds = new DoubleRect();
        this.m_bounds.initBounds();
    }

    public boolean isCartesian() {
        return this.m_isCartesian;
    }

    public DoubleRect getBounds() {
        return this.m_bounds;
    }

    public List<Edge> getEdges() {
        return this.m_edges;
    }

    public void add(Edge edge) {
        if (this.m_isCartesian != edge.isCartesian()) {
            throw new IllegalStateException();
        }
        this.m_bounds.merge(edge.getBounds());
        this.m_edges.add(edge);
    }

    public void addAll(EdgeList edgeList) {
        if (this.m_isCartesian != edgeList.isCartesian()) {
            throw new IllegalStateException();
        }
        this.m_bounds.merge(edgeList.getBounds());
        this.m_edges.addAll(edgeList.getEdges());
    }

    public boolean isEmpty() {
        return this.m_edges.isEmpty();
    }

    @Override
    public Iterator<Edge> iterator() {
        return this.m_edges.iterator();
    }
}

