/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.edge;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.operations.edge.DistanceResult;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.util.MathUtil;

public final class SphericalOps {
    private static final double LL_MAX_TRUNCATION = 1.0;
    private static final double SPHERICAL_VECTOR_TOO_SMALL = 1.0E-20;

    private SphericalOps() {
    }

    public static DistanceResult distance(DirectPosition pt1, DirectPosition pt2) {
        double dx = pt1.getX() - pt2.getX();
        double dy = pt1.getY() - pt2.getY();
        double dz = pt1.getZ() - pt2.getZ();
        DistanceResult result = new DistanceResult();
        result.setA(pt1);
        result.setB(pt2);
        result.setProxyDistance2(dx * dx + dy * dy + dz * dz);
        return result;
    }

    protected static double LLDistanceM(DirectPosition a, DirectPosition b) throws IllegalArgumentException {
        SphericalOps.LLTruncate(a);
        a.setX(Math.toRadians(a.getX()));
        a.setY(Math.toRadians(a.getY()));
        SphericalOps.LLTruncate(b);
        b.setX(Math.toRadians(b.getX()));
        b.setY(Math.toRadians(b.getY()));
        double sinx = Math.sin((b.getX() - a.getX()) / 2.0);
        double siny = Math.sin((b.getY() - a.getY()) / 2.0);
        double gc_ang = Math.asin(Math.sqrt(siny * siny + Math.cos(a.getY()) * Math.cos(b.getY()) * sinx * sinx)) * 2.0;
        return gc_ang * 6370997.0;
    }

    private static void LLTruncate(DirectPosition pos) {
        if (pos.getX() < -360.0) {
            if (pos.getX() < -361.0) {
                throw new IllegalArgumentException();
            }
            pos.setX(-360.0);
        } else if (pos.getX() > 360.0) {
            if (pos.getX() > 361.0) {
                throw new IllegalArgumentException();
            }
            pos.setX(360.0);
        }
        if (pos.getY() < -90.0) {
            if (pos.getY() < -91.0) {
                throw new IllegalArgumentException();
            }
            pos.setY(-90.0);
        } else if (pos.getY() > 90.0) {
            if (pos.getY() > 91.0) {
                throw new IllegalArgumentException();
            }
            pos.setY(90.0);
        }
    }

    public static boolean intersects(Edge.SphericalEdge edge, DirectPosition pt, double tolerance) {
        return SphericalOps.distance(edge, pt).getProxyDistance2() < MathUtil.square((double)tolerance);
    }

    public static boolean intersects(Edge.SphericalEdge left, Edge.SphericalEdge right, double tolerance) {
        if (SphericalOps.intersectEdgeEdge(left, right, null)) {
            return true;
        }
        double toleranceSquared = MathUtil.square((double)tolerance);
        double distance2 = SphericalOps.distance(right, left.getTransA(), null);
        if (distance2 < toleranceSquared) {
            return true;
        }
        distance2 = SphericalOps.distance(right, left.getTransB(), null);
        if (distance2 < toleranceSquared) {
            return true;
        }
        distance2 = SphericalOps.distance(left, right.getTransA(), null);
        if (distance2 < toleranceSquared) {
            return true;
        }
        distance2 = SphericalOps.distance(left, right.getTransB(), null);
        return distance2 < toleranceSquared;
    }

    public static DistanceResult distance(Edge.SphericalEdge edge, DirectPosition pt) {
        DirectPosition vectorPt = new DirectPosition();
        double distance2 = SphericalOps.distance(edge, pt, vectorPt);
        DistanceResult result = new DistanceResult();
        result.setA(pt);
        result.setB(vectorPt, true);
        result.setProxyDistance2(distance2);
        return result;
    }

    public static DistanceResult distance(Edge.SphericalEdge left, Edge.SphericalEdge right) {
        DirectPosition ptOnLeft = new DirectPosition();
        DirectPosition ptOnRight = new DirectPosition();
        double distance2 = SphericalOps.distance(left, right, ptOnLeft, ptOnRight);
        DistanceResult result = new DistanceResult();
        result.setA(ptOnLeft);
        result.setB(ptOnRight);
        result.setProxyDistance2(distance2);
        return result;
    }

    public static DirectPosition to3DFromLL(DirectPosition LL) {
        DirectPosition dp = new DirectPosition(LL);
        SphericalOps.transformTo3DFromLL(dp);
        return dp;
    }

    public static void transformTo3DFromLL(DirectPosition LL) {
        double x = Math.toRadians(LL.getX());
        double y = Math.toRadians(LL.getY());
        double cosY = Math.cos(y);
        LL.setXYZ(Math.sin(x) * cosY, Math.cos(x) * cosY, Math.sin(y));
    }

    public static DirectPosition toLLFrom3D(DirectPosition p3D) {
        DirectPosition dp = new DirectPosition(p3D);
        SphericalOps.transformToLLFrom3D(dp);
        return dp;
    }

    public static void transformToLLFrom3D(DirectPosition p3D) {
        double resultX = Math.toDegrees(Math.atan2(p3D.getX(), p3D.getY()));
        double temp = p3D.getZ() / Math.sqrt(p3D.getX() * p3D.getX() + p3D.getY() * p3D.getY() + p3D.getZ() * p3D.getZ());
        if (temp >= -1.0) {
            if (!(temp <= 1.0)) {
                temp = 1.0;
            }
        } else {
            temp = -1.0;
        }
        double resultY = Math.toDegrees(Math.asin(temp));
        p3D.setXYZ(resultX, resultY, Double.NaN);
    }

    private static double distance(Edge.SphericalEdge edge, DirectPosition pt, DirectPosition returned_proj_pt) {
        return SphericalOps.distance(edge.getTransA().getX(), edge.getTransA().getY(), edge.getTransA().getZ(), edge.getTransB().getX(), edge.getTransB().getY(), edge.getTransB().getZ(), edge.getCross().getX(), edge.getCross().getY(), edge.getCross().getZ(), pt.getX(), pt.getY(), pt.getZ(), returned_proj_pt);
    }

    public static double distance(double edgeTransAX, double edgeTransAY, double edgeTransAZ, double edgeTransBX, double edgeTransBY, double edgeTransBZ, double edgeCrossX, double edgeCrossY, double edgeCrossZ, double ptX, double ptY, double ptZ, DirectPosition returned_proj_pt) {
        double newdist;
        DirectPosition projected_pt = returned_proj_pt != null ? returned_proj_pt : new DirectPosition();
        boolean projection_ok = false;
        double distproxy = 0.0;
        DirectPosition Vk = new DirectPosition(ptY * edgeTransBZ - ptY * edgeTransAZ + ptZ * edgeTransAY - ptZ * edgeTransBY, ptZ * edgeTransBX - ptZ * edgeTransAX + ptX * edgeTransAZ - ptX * edgeTransBZ, ptX * edgeTransBY - ptX * edgeTransAY + ptY * edgeTransAX - ptY * edgeTransBX);
        DirectPosition Vc = new DirectPosition(ptY * edgeTransAZ - ptZ * edgeTransAY, ptZ * edgeTransAX - ptX * edgeTransAZ, ptX * edgeTransAY - ptY * edgeTransAX);
        double k_coef = Vk.getX() * edgeCrossX + Vk.getY() * edgeCrossY + Vk.getZ() * edgeCrossZ;
        double const_coef = Vc.getX() * edgeCrossX + Vc.getY() * edgeCrossY + Vc.getZ() * edgeCrossZ;
        double k = -const_coef / k_coef;
        if (k > 0.0 && k < 1.0) {
            projection_ok = true;
            projected_pt.setX((1.0 - k) * edgeTransAX + k * edgeTransBX);
            projected_pt.setY((1.0 - k) * edgeTransAY + k * edgeTransBY);
            projected_pt.setZ((1.0 - k) * edgeTransAZ + k * edgeTransBZ);
            double temp = Math.sqrt(projected_pt.getX() * projected_pt.getX() + projected_pt.getY() * projected_pt.getY() + projected_pt.getZ() * projected_pt.getZ());
            if (temp != 1.0) {
                projected_pt.setX(projected_pt.getX() / temp);
                projected_pt.setY(projected_pt.getY() / temp);
                projected_pt.setZ(projected_pt.getZ() / temp);
            }
            distproxy = SphericalOps.distancePtPt2(projected_pt.getX(), projected_pt.getY(), projected_pt.getZ(), ptX, ptY, ptZ);
        }
        if ((newdist = SphericalOps.distancePtPt2(edgeTransAX, edgeTransAY, edgeTransAZ, ptX, ptY, ptZ)) < distproxy || !projection_ok) {
            distproxy = newdist;
            projected_pt.set(edgeTransAX, edgeTransAY, edgeTransAZ, null);
        }
        if ((newdist = SphericalOps.distancePtPt2(edgeTransBX, edgeTransBY, edgeTransBZ, ptX, ptY, ptZ)) < distproxy) {
            distproxy = newdist;
            projected_pt.set(edgeTransBX, edgeTransBY, edgeTransBZ, null);
        }
        return distproxy;
    }

    private static double distance(Edge.SphericalEdge left, Edge.SphericalEdge right, DirectPosition ptOnLeft, DirectPosition ptOnRight) {
        DirectPosition newPt = new DirectPosition();
        if (ptOnLeft == null) {
            ptOnLeft = newPt;
            ptOnRight = newPt;
        }
        if (SphericalOps.intersectEdgeEdge(left, right, newPt)) {
            ptOnLeft.set(newPt);
            ptOnRight.set(newPt);
            return 0.0;
        }
        double dist = SphericalOps.distance(right, left.getTransA(), newPt);
        ptOnRight.set(newPt);
        ptOnLeft.set(left.getTransA());
        double newdist = SphericalOps.distance(right, left.getTransB(), newPt);
        if (newdist < dist) {
            dist = newdist;
            ptOnRight.set(newPt);
            ptOnLeft.set(left.getTransB());
        }
        if ((newdist = SphericalOps.distance(left, right.getTransA(), newPt)) < dist) {
            dist = newdist;
            ptOnLeft.set(newPt);
            ptOnRight.set(right.getTransA());
        }
        if ((newdist = SphericalOps.distance(left, right.getTransB(), newPt)) < dist) {
            dist = newdist;
            ptOnLeft.set(newPt);
            ptOnRight.set(right.getTransB());
        }
        return dist;
    }

    private static boolean intersectEdgeEdge(Edge.SphericalEdge A, Edge.SphericalEdge B, DirectPosition intersectionPt) {
        if (SphericalOps.dotProduct(A.getTransA(), B.getCross()) * SphericalOps.dotProduct(A.getTransB(), B.getCross()) > 0.0) {
            return false;
        }
        if (SphericalOps.dotProduct(B.getTransA(), A.getCross()) * SphericalOps.dotProduct(B.getTransB(), A.getCross()) > 0.0) {
            return false;
        }
        DirectPosition intr = SphericalOps.crossProduct(A.getCross(), B.getCross());
        double intr_len2 = intr.getX() * intr.getX() + intr.getY() * intr.getY() + intr.getZ() * intr.getZ();
        if (intr_len2 < 1.0E-20) {
            return false;
        }
        DirectPosition mid2 = new DirectPosition(A.getTransA().getX() + A.getTransB().getX(), A.getTransA().getY() + A.getTransB().getY(), A.getTransA().getZ() + A.getTransB().getZ());
        if (SphericalOps.dotProduct(mid2, intr) < 0.0) {
            intr.setX(-intr.getX());
            intr.setY(-intr.getY());
            intr.setZ(-intr.getZ());
        }
        mid2.setX(B.getTransA().getX() + B.getTransB().getX());
        mid2.setY(B.getTransA().getY() + B.getTransB().getY());
        mid2.setZ(B.getTransA().getZ() + B.getTransB().getZ());
        if (SphericalOps.dotProduct(mid2, intr) < 0.0) {
            return false;
        }
        if (intersectionPt != null) {
            intersectionPt.set(intr);
        }
        return true;
    }

    private static double dotProduct(DirectPosition a, DirectPosition b) {
        return a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ();
    }

    private static DirectPosition crossProduct(DirectPosition A, DirectPosition B) {
        return new DirectPosition(A.getY() * B.getZ() - A.getZ() * B.getY(), A.getZ() * B.getX() - A.getX() * B.getZ(), A.getX() * B.getY() - A.getY() * B.getX());
    }

    private static double distancePtPt2(double ax, double ay, double az, double bx, double by, double bz) {
        double dx = ax - bx;
        double dy = ay - by;
        double dz = az - bz;
        return dx * dx + dy * dy + dz * dz;
    }
}

