/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.edge.prepared;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.edge.EdgeFactory;
import com.mapinfo.midev.geometry.operations.edge.EdgeList;
import com.mapinfo.midev.geometry.operations.edge.prepared.IPreparedGeometry;
import com.mapinfo.midev.geometry.operations.edge.prepared.RingGroup;
import com.mapinfo.midev.geometry.operations.rtree.GeometryRTree;
import com.mapinfo.midev.geometry.util.LegacyGeometryUtilities;
import com.mapinfo.midev.util.DoubleRect;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.ListUtils;

public final class GeometryOperationsHelper
implements Serializable {
    private final IGeometry m_original;
    private final boolean m_indexed;
    private final DoubleRect m_mbr;
    private List<RingGroup> m_area = null;
    private List<DirectPosition> m_points = null;
    private List<Edge> m_cartesianLineAndAreaEdges = null;
    private List<Edge> m_sphericalLineAndAreaEdges = null;
    private List<Edge> m_cartesianCurvesAsEdges = null;
    private List<Edge> m_sphericalCurvesAsEdges = null;
    private EdgeList m_cartesianEdgeList;
    private EdgeList m_sphericalEdgeList;
    private GeometryRTree m_cartesianIndexedEdges;
    private GeometryRTree m_sphericalIndexedEdges;

    private GeometryOperationsHelper(IGeometry original, boolean index) {
        this.m_original = LegacyGeometryUtilities.toNonLegacyGeometry(original);
        this.m_indexed = index;
        Envelope env = original.getEnvelope();
        this.m_mbr = env.isEmpty() ? null : new DoubleRect(env.getLowerLeft(), env.getUpperRight());
    }

    public static GeometryOperationsHelper getInstance(IGeometry geometry, boolean index) {
        GeometryOperationsHelper result = geometry instanceof IPreparedGeometry ? ((IPreparedGeometry)geometry).getHelper() : new GeometryOperationsHelper(geometry, index);
        return result;
    }

    public boolean isIndexed() {
        return this.m_indexed;
    }

    public boolean envelopeContains(DirectPosition pt) {
        return this.m_mbr != null && this.m_mbr.contains(pt);
    }

    public EdgeList getEdges(boolean isCartesian) {
        if (isCartesian) {
            if (this.m_cartesianEdgeList == null) {
                this.m_cartesianEdgeList = new EdgeFactory(true).create(this.m_original);
            }
            return this.m_cartesianEdgeList;
        }
        if (this.m_sphericalEdgeList == null) {
            this.m_sphericalEdgeList = new EdgeFactory(false).create(this.m_original);
        }
        return this.m_sphericalEdgeList;
    }

    public GeometryRTree getIndexedEdges(boolean isCartesian) {
        if (!this.m_indexed) {
            throw new UnsupportedOperationException("Unable to get indexed edges from non-indexed helper.");
        }
        if (isCartesian) {
            if (this.m_cartesianIndexedEdges == null) {
                this.m_cartesianIndexedEdges = new GeometryRTree(this.getEdges(true));
            }
            return this.m_cartesianIndexedEdges;
        }
        if (this.m_sphericalIndexedEdges == null) {
            this.m_sphericalIndexedEdges = new GeometryRTree(this.getEdges(false));
        }
        return this.m_sphericalIndexedEdges;
    }

    public List<RingGroup> getArea() {
        if (this.m_area == null) {
            this.m_area = RingGroup.getInstance(this.m_original, this.m_indexed);
        }
        return this.m_area;
    }

    public List<DirectPosition> getPoints() {
        if (this.m_points == null) {
            switch (this.m_original.getType()) {
                case POINT: {
                    this.m_points = Collections.singletonList(((IPoint)this.m_original).getDirectPosition());
                    break;
                }
                case MULTI_POINT: {
                    IMultiPoint mp = (IMultiPoint)this.m_original;
                    this.m_points = new ArrayList<DirectPosition>(mp.getPointCount());
                    IDirectPositionIterator i = mp.getDirectPositionIterator();
                    while (i.hasNext()) {
                        this.m_points.add(i.nextDirectPosition(new DirectPosition()));
                    }
                    break;
                }
                case MULTI_FEATURE_GEOMETRY: {
                    IMultiPoint mp = ((IMultiFeatureGeometry)this.m_original).getAllPoints();
                    this.m_points = new ArrayList<DirectPosition>(mp.getPointCount());
                    IDirectPositionIterator i = mp.getDirectPositionIterator();
                    while (i.hasNext()) {
                        this.m_points.add(i.nextDirectPosition(new DirectPosition()));
                    }
                    break;
                }
                default: {
                    this.m_points = Collections.emptyList();
                }
            }
            this.m_points = Collections.unmodifiableList(this.m_points);
        }
        return this.m_points;
    }

    public List<Edge> getCurvesAsEdges(boolean isCartesian) {
        if (isCartesian) {
            if (this.m_cartesianCurvesAsEdges == null) {
                this.m_cartesianCurvesAsEdges = this.buildCurvesAsEdges(true);
            }
            return this.m_cartesianCurvesAsEdges;
        }
        if (this.m_sphericalCurvesAsEdges == null) {
            this.m_sphericalCurvesAsEdges = this.buildCurvesAsEdges(false);
        }
        return this.m_sphericalCurvesAsEdges;
    }

    private List<Edge> buildCurvesAsEdges(boolean isCartesian) {
        EdgeFactory edgeFactory = new EdgeFactory(isCartesian);
        switch (this.m_original.getType()) {
            case MULTI_FEATURE_GEOMETRY: {
                return edgeFactory.create((IGeometry)((IMultiFeatureGeometry)this.m_original).getAllCurves()).getEdges();
            }
            case MULTI_CURVE: 
            case CURVE: 
            case LINE_STRING: {
                return edgeFactory.create(this.m_original).getEdges();
            }
        }
        return Collections.emptyList();
    }

    private List<Edge> buildAreasAsEdges(boolean isCartesian) {
        EdgeFactory edgeFactory = new EdgeFactory(isCartesian);
        switch (this.m_original.getType()) {
            case MULTI_FEATURE_GEOMETRY: {
                return edgeFactory.create((IGeometry)((IMultiFeatureGeometry)this.m_original).getAllPolygons()).getEdges();
            }
            case MULTI_POLYGON: 
            case POLYGON: 
            case RING: {
                return edgeFactory.create(this.m_original).getEdges();
            }
        }
        return Collections.emptyList();
    }

    public List<Edge> getLineAndAreaEdges(boolean isCartesian) {
        if (isCartesian) {
            if (this.m_cartesianLineAndAreaEdges == null) {
                this.m_cartesianLineAndAreaEdges = ListUtils.union(this.buildAreasAsEdges(true), this.getCurvesAsEdges(true));
            }
            return this.m_cartesianLineAndAreaEdges;
        }
        if (this.m_sphericalLineAndAreaEdges == null) {
            this.m_sphericalLineAndAreaEdges = ListUtils.union(this.buildAreasAsEdges(false), this.getCurvesAsEdges(false));
        }
        return this.m_sphericalLineAndAreaEdges;
    }
}

