/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.edge.prepared;

import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.operations.edge.prepared.IPreparedGeometry;
import com.mapinfo.midev.geometry.operations.edge.prepared.PreparedGeometryFactory;
import com.mapinfo.midev.geometry.util.LegacyGeometryUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class RingGroup
implements Serializable {
    private final IRing m_outerRing;
    private final List<IRing> m_innerRings;

    private RingGroup(IRing outerRing, List<IRing> innerRings) {
        this.m_outerRing = outerRing;
        this.m_innerRings = innerRings;
    }

    public IRing getOuterRing() {
        return this.m_outerRing;
    }

    public List<IRing> getInnerRings() {
        return this.m_innerRings;
    }

    public static List<RingGroup> getInstance(IGeometry geometry, boolean index) {
        if (geometry instanceof IPreparedGeometry) {
            return ((IPreparedGeometry)geometry).getHelper().getArea();
        }
        return RingGroup.create(geometry, index);
    }

    private static List<RingGroup> create(IGeometry geometry, boolean index) {
        if (geometry.getDimension() != 2) {
            return Collections.emptyList();
        }
        geometry = LegacyGeometryUtilities.toNonLegacyGeometry(geometry);
        switch (geometry.getType()) {
            case RING: {
                IRing ring = RingGroup.getRing((IRing)geometry, index);
                return Collections.singletonList(new RingGroup(ring, Collections.emptyList()));
            }
            case POLYGON: {
                return Collections.singletonList(RingGroup.toRingGroup((IPolygon)geometry, index));
            }
            case MULTI_POLYGON: {
                return RingGroup.toRingGroupList((IMultiPolygon)geometry, index);
            }
            case MULTI_FEATURE_GEOMETRY: {
                IMultiFeatureGeometry multiFeatureGeometry = (IMultiFeatureGeometry)geometry;
                ArrayList<RingGroup> result = new ArrayList<RingGroup>();
                Iterator<IMultiPolygon> i = multiFeatureGeometry.getMultiPolygonIterator();
                while (i.hasNext()) {
                    result.addAll(RingGroup.toRingGroupList(i.next(), index));
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    private static List<RingGroup> toRingGroupList(IMultiPolygon multiPolygon, boolean index) {
        ArrayList<RingGroup> result = new ArrayList<RingGroup>(multiPolygon.getPolygonCount());
        for (IPolygon p : multiPolygon) {
            result.add(RingGroup.toRingGroup(p, index));
        }
        return result;
    }

    private static RingGroup toRingGroup(IPolygon polygon, boolean index) {
        IRing outerRing = RingGroup.getRing(polygon.getExteriorRing(), index);
        ArrayList<IRing> innerRings = new ArrayList<IRing>(polygon.getInteriorRingCount());
        Iterator<IRing> i = polygon.getInteriorRingIterator();
        while (i.hasNext()) {
            innerRings.add(RingGroup.getRing(i.next(), index));
        }
        return new RingGroup(outerRing, innerRings);
    }

    private static IRing getRing(IRing ring, boolean index) {
        return index ? PreparedGeometryFactory.prepare(ring, true) : ring;
    }
}

