/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.rtree;

import com.mapinfo.midev.geometry.operations.edge.Edge;
import com.mapinfo.midev.geometry.operations.edge.EdgeList;
import com.mapinfo.midev.geometry.operations.rtree.TreeNode;
import com.mapinfo.midev.geometry.operations.rtree.TreeNodeOp;
import com.mapinfo.midev.util.DoubleRect;
import java.io.Serializable;
import java.util.List;

public final class GeometryRTree
implements Serializable {
    private final TreeNode m_root;
    private final boolean m_isCartesian;

    public GeometryRTree(EdgeList edgeList) {
        this.m_isCartesian = edgeList.isCartesian();
        List<Edge> edges = edgeList.getEdges();
        this.m_root = new TreeNode(edges.toArray(new Edge[edges.size()]), edgeList.getBounds());
        this.m_root.trySplit();
    }

    public boolean isCartesian() {
        return this.m_isCartesian;
    }

    public TreeNode getRoot() {
        return this.m_root;
    }

    public void search(DoubleRect searchMbr, TreeNodeOp op) {
        this.m_root.searchNode(searchMbr, op);
    }
}

