/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.operations.cartesian.Cartesian;
import com.mapinfo.midev.geometry.operations.s2.ActiveLineList;
import com.mapinfo.midev.geometry.operations.s2.IActiveLineInfo;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweep;
import com.mapinfo.midev.geometry.operations.s2.PointComparator;
import com.mapinfo.midev.geometry.operations.s2.SkipListIterator;
import com.mapinfo.midev.geometry.operations.s2.SweepEventLinePartiallySwept;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;
import java.util.List;
import java.util.Objects;

final class ActiveLine
implements Comparable<ActiveLine> {
    private final ActiveLineList m_ghostSlice;
    private SkipListIterator<ActiveLine> m_ghostNode;
    private int m_ghostParity = 0;
    private PlaneSweep m_sweep;
    private SkipListIterator<ActiveLine> m_sliceNode;
    private final DirectPosition[] m_pt = new DirectPosition[2];
    private final DirectPosition[] m_longPt = new DirectPosition[2];
    private final IActiveLineInfo m_info;
    private List<IDirectPositionList> m_holes;

    public ActiveLine(IActiveLineInfo info, ActiveLineList sourceID, DirectPosition p0, DirectPosition p1) {
        this(info, sourceID, p0, p1, null);
    }

    public ActiveLine(IActiveLineInfo info, ActiveLineList sourceID, DirectPosition p0, DirectPosition p1, PlaneSweep sweep) {
        this.m_ghostSlice = sourceID;
        this.m_ghostNode = sourceID != null ? sourceID.end() : null;
        this.m_sweep = sweep;
        this.m_sliceNode = sweep != null ? sweep.slice().end() : null;
        this.m_info = info;
        this.m_pt[0] = p0;
        this.m_pt[1] = p1;
        this.m_longPt[0] = p0;
        this.m_longPt[1] = p1;
        if (sweep != null) {
            this.activatePair(null, sweep);
        }
    }

    PlaneSweep getSweep() {
        return this.m_sweep;
    }

    ActiveLineList getGhostSlice() {
        return this.m_ghostSlice;
    }

    int getGhostParity() {
        return this.m_ghostParity;
    }

    void setGhostParity(int ghostParity) {
        this.m_ghostParity = ghostParity;
    }

    SkipListIterator<ActiveLine> getGhostNode() {
        return this.m_ghostNode;
    }

    DirectPosition[] getPt() {
        return this.m_pt;
    }

    DirectPosition[] getLongPt() {
        return this.m_longPt;
    }

    IActiveLineInfo getLineInfo() {
        return this.m_info;
    }

    SkipListIterator<ActiveLine> sliceNode() {
        return this.m_sliceNode;
    }

    List<IDirectPositionList> getHoles() {
        return this.m_holes;
    }

    void setHoles(List<IDirectPositionList> holes) {
        this.m_holes = holes;
    }

    void setRightSliceEndPoint(DirectPosition pt) {
        this.m_pt[1] = pt;
    }

    public int compareToMid(ActiveLine other) {
        double otherY;
        double x1;
        double x0 = Math.max(other.m_pt[0].getX(), this.m_pt[0].getX());
        double mid = (x0 + (x1 = Math.min(other.m_pt[1].getX(), this.m_pt[1].getX()))) / 2.0;
        double thisY = this.yAt(mid, 0);
        if (thisY > (otherY = other.yAt(mid, 0))) {
            return 1;
        }
        if (thisY < otherY) {
            return -1;
        }
        return this.compareTo(other);
    }

    @Override
    public int compareTo(ActiveLine other) {
        double otherY;
        double x1;
        double x0 = Math.max(other.m_pt[0].getX(), this.m_pt[0].getX());
        if (x0 > (x1 = Math.min(other.m_pt[1].getX(), this.m_pt[1].getX()))) {
            double diff = this.m_pt[0].getY() + this.m_pt[1].getY() - (other.m_pt[0].getY() + other.m_pt[1].getY());
            if (diff > 0.0) {
                return 1;
            }
            if (diff < 0.0) {
                return -1;
            }
            return 0;
        }
        double thisY = this.yAt(x0, 0);
        if (thisY > (otherY = other.yAt(x0, 0))) {
            return 1;
        }
        if (thisY < otherY) {
            return -1;
        }
        thisY = this.yAt(x1, 1);
        if (thisY > (otherY = other.yAt(x1, 1))) {
            return 1;
        }
        if (thisY < otherY) {
            return -1;
        }
        return this.m_info.tieBreak(this, other);
    }

    public double yAt(double x, int preferredEnd) {
        if (x == this.m_pt[preferredEnd].getX()) {
            return this.m_pt[preferredEnd].getY();
        }
        if (x == this.m_pt[1 - preferredEnd].getX()) {
            return this.m_pt[1 - preferredEnd].getY();
        }
        double m = (x - this.m_pt[0].getX()) / (this.m_pt[1].getX() - this.m_pt[0].getX());
        return this.m_pt[0].getY() + m * (this.m_pt[1].getY() - this.m_pt[0].getY());
    }

    public void activatePair(ActiveLine otherLine, PlaneSweep sweep) {
        SkipListIterator<ActiveLine> prevExistingGhost;
        this.m_sweep = sweep;
        this.m_sliceNode = this.m_sweep.slice().insert(this);
        if (this.m_ghostSlice != null) {
            this.m_ghostNode = this.m_ghostSlice.insert(this);
            this.correctGhostOrdering();
            prevExistingGhost = this.m_ghostNode.getCopy();
            prevExistingGhost.prev();
        }
        this.bubbleMove();
        SkipListIterator<ActiveLine> prevExisting = this.m_sliceNode.getCopy();
        prevExisting.prev();
        boolean swappedPair = false;
        if (otherLine != null) {
            SkipListIterator<ActiveLine> next;
            int offset;
            otherLine.m_sliceNode = sweep.slice().insert(this);
            otherLine.m_sliceNode.getElement().setDatum(otherLine);
            otherLine.m_sweep = sweep;
            if (otherLine.m_ghostSlice != null) {
                otherLine.m_ghostNode = otherLine.m_ghostSlice.insert(this);
                otherLine.correctGhostOrdering();
            }
            for (offset = otherLine.m_sliceNode.subtract(this.m_sliceNode); offset > 1; --offset) {
                next = this.m_sliceNode.getCopy();
                next.next();
                this.swapWithNext(next, true);
            }
            while (offset < 0) {
                SkipListIterator<ActiveLine> prev = this.m_sweep.slice().prev(this.m_sliceNode);
                prev.getElement().getDatum().swapWithNext(this.m_sliceNode, true);
                ++offset;
            }
            Assert.assertCondition(otherLine.m_sliceNode.subtract(this.m_sliceNode) == 1);
            prevExisting = this.m_sliceNode.getCopy();
            prevExisting.prev();
            if (this.m_ghostSlice != null) {
                prevExistingGhost = this.m_ghostNode.getCopy();
                prevExistingGhost.prev();
            }
            Assert.assertCondition(Objects.equals(this.m_ghostSlice, otherLine.m_ghostSlice));
            Assert.assertCondition(this.m_ghostSlice == null || otherLine.m_ghostNode.subtract(this.m_ghostNode) == 1);
            if (this.compareTo(otherLine) > 0) {
                next = this.m_sliceNode.getCopy();
                next.next();
                this.swapWithNext(next, true);
                swappedPair = true;
            }
        }
        if (swappedPair) {
            this.m_info.activatePair(otherLine, this);
        } else {
            this.m_info.activatePair(this, otherLine);
        }
        if (otherLine == null) {
            sweep.started(this);
            ActiveLine.verifyOrdering(this, false);
        } else {
            sweep.startedPair(this, otherLine);
            ActiveLine.verifyOrdering(this, false);
            ActiveLine.verifyOrdering(otherLine, false);
        }
    }

    private void correctGhostOrdering() {
        SkipListIterator<ActiveLine> temp;
        ActiveLine nextLine;
        SkipListIterator<ActiveLine> next = this.m_ghostNode.getCopy();
        next.next();
        while (!next.equals(this.m_ghostSlice.end()) && !this.m_sliceNode.lessThan(next.get().m_sliceNode)) {
            nextLine = next.get();
            nextLine.m_ghostNode.set(this);
            this.m_ghostNode.set(nextLine);
            temp = this.m_ghostNode;
            this.m_ghostNode = nextLine.m_ghostNode;
            nextLine.m_ghostNode = temp;
            next.next();
        }
        next = this.m_ghostNode.getCopy();
        next.prev();
        while (!next.equals(this.m_ghostSlice.rend()) && this.m_sliceNode.lessThan(next.get().m_sliceNode)) {
            nextLine = next.get();
            nextLine.m_ghostNode.set(this);
            this.m_ghostNode.set(nextLine);
            temp = this.m_ghostNode;
            this.m_ghostNode = nextLine.m_ghostNode;
            nextLine.m_ghostNode = temp;
            next.prev();
        }
    }

    public void sweepTo(DirectPosition newStart) {
        Assert.assertCondition(PointComparator.INSTANCE.compare(newStart, this.m_pt[1]) <= 0);
        Assert.assertCondition(PointComparator.INSTANCE.compare(newStart, this.m_pt[0]) >= 0);
        Assert.assertCondition(PointComparator.INSTANCE.compare(newStart, this.m_longPt[1]) <= 0);
        this.m_sweep.sweepTo(this, newStart);
        this.m_pt[0] = newStart;
    }

    static void verifyOrdering(ActiveLine dirtyLine, boolean quiet) {
        ActiveLine.verifyOrdering(dirtyLine, dirtyLine, quiet);
    }

    private void bubbleMove() {
        SkipListIterator<ActiveLine> neighbour = this.m_sweep.slice().next(this.m_sliceNode);
        while (!neighbour.equals(this.m_sweep.slice().end())) {
            if (this.compareTo(neighbour.getElement().getDatum()) > 0) {
                this.swapWithNext(neighbour, true);
                neighbour = this.m_sweep.slice().next(this.m_sliceNode);
                continue;
            }
            neighbour = this.m_sweep.slice().end();
        }
        neighbour = this.m_sweep.slice().prev(this.m_sliceNode);
        while (!neighbour.equals(this.m_sweep.slice().rend())) {
            if (this.compareTo(neighbour.get()) < 0) {
                neighbour.getElement().getDatum().swapWithNext(this.m_sliceNode, true);
                neighbour = this.m_sweep.slice().prev(this.m_sliceNode);
                continue;
            }
            neighbour = this.m_sweep.slice().rend();
        }
    }

    void swapWithNext(SkipListIterator<ActiveLine> next, boolean quiet) {
        ActiveLine nextLine = next.getElement().getDatum();
        if (this.m_ghostSlice != null && this.m_ghostSlice.equals(nextLine.m_ghostSlice)) {
            this.swapWithNextGhost(nextLine, quiet);
        }
        if (!quiet) {
            this.m_sweep.swapped(this.m_sliceNode, nextLine);
        }
        next.getElement().setDatum(this);
        this.m_sliceNode.getElement().setDatum(nextLine);
        nextLine.m_sliceNode = this.m_sliceNode;
        this.m_sliceNode = next;
    }

    private void swapWithNextGhost(ActiveLine nextLine, boolean quiet) {
        Assert.assertCondition(!nextLine.m_ghostNode.equals(this.m_ghostSlice.end()));
        Assert.assertCondition(!nextLine.m_ghostNode.equals(this.m_ghostSlice.rend()));
        nextLine.m_ghostNode.getElement().setDatum(this);
        this.m_ghostNode.getElement().setDatum(nextLine);
        SkipListIterator<ActiveLine> temp = this.m_ghostNode;
        this.m_ghostNode = nextLine.m_ghostNode;
        nextLine.m_ghostNode = temp;
        if (!quiet) {
            --this.m_ghostParity;
            ++nextLine.m_ghostParity;
        }
    }

    void swept() {
        this.m_sweep.swept(this);
        SkipListIterator<ActiveLine> nextNode = this.m_sweep.slice().next(this.m_sliceNode);
        this.m_sweep.slice().erase(this.m_sliceNode);
        this.m_sliceNode = null;
        if (this.m_ghostNode != null) {
            this.m_ghostSlice.erase(this.m_ghostNode);
            this.m_ghostNode = null;
        }
        if (nextNode != null && nextNode.getElement() != null) {
            ActiveLine.verifyOrdering(nextNode.getElement().getDatum(), false);
        }
    }

    static void verifyOrdering(ActiveLine bottom, ActiveLine top, boolean quiet) {
        while (top != null) {
            SkipListIterator<ActiveLine> neighbour = ActiveLine.prev(bottom.m_sliceNode);
            boolean swapped = false;
            boolean changed = false;
            if (!neighbour.equals(bottom.m_sweep.slice().rend())) {
                Assert.assertCondition(ActiveLine.next(neighbour).equals(bottom.m_sliceNode));
                Assert.assertCondition(bottom.m_sliceNode.getElement().getDatum().equals(bottom));
                ActiveLine al = neighbour.getElement().getDatum();
                changed = ActiveLine.intersectPair(al, bottom, quiet);
                if (neighbour.getElement().getDatum().compareToMid(bottom) > 0) {
                    if (bottom.equals(top)) {
                        top = neighbour.getElement().getDatum();
                    }
                    neighbour.getElement().getDatum().swapWithNext(bottom.m_sliceNode, quiet);
                    swapped = true;
                } else if (changed) {
                    bottom = neighbour.getElement().getDatum();
                }
            }
            if (swapped || changed) continue;
            neighbour = ActiveLine.next(bottom.m_sliceNode);
            swapped = false;
            changed = false;
            if (!neighbour.equals(bottom.m_sweep.slice().end())) {
                Assert.assertCondition(ActiveLine.next(bottom.m_sliceNode).equals(neighbour));
                Assert.assertCondition(ActiveLine.prev(neighbour).equals(bottom.m_sliceNode));
                Assert.assertCondition(bottom.m_sliceNode.getElement().getDatum().equals(bottom));
                Assert.assertCondition(neighbour.getElement().getDatum().m_sliceNode.equals(neighbour));
                changed = ActiveLine.intersectPair(bottom, neighbour.getElement().getDatum(), quiet);
                if (bottom.compareToMid(neighbour.getElement().getDatum()) > 0) {
                    if (neighbour.getElement().getDatum().equals(top)) {
                        top = bottom;
                    }
                    ActiveLine newBottom = neighbour.getElement().getDatum();
                    bottom.swapWithNext(neighbour, quiet);
                    bottom = newBottom;
                    swapped = true;
                } else if (changed && bottom.equals(top)) {
                    top = neighbour.getElement().getDatum();
                }
            }
            if (swapped || changed) continue;
            if (bottom.equals(top)) {
                top = null;
                bottom = null;
                continue;
            }
            bottom = neighbour.getElement().getDatum();
        }
    }

    private static boolean intersectPair(ActiveLine lineA, ActiveLine lineB, boolean quiet) {
        PlaneSweep sweep = lineA.m_sweep;
        Assert.assertCondition(lineA.m_sweep.slice().next(lineA.m_sliceNode).equals(lineB.m_sliceNode));
        Assert.assertCondition(lineA.m_sweep.slice().next(lineA.m_sliceNode).getElement().getDatum().equals(lineB));
        boolean truncA = false;
        boolean truncB = false;
        CrossStatus crossingStatus = CrossStatus.MAY_CROSS;
        int orderLeft = PointComparator.INSTANCE.compare(lineA.m_pt[0], lineB.m_pt[0]);
        int orderRight = PointComparator.INSTANCE.compare(lineA.m_pt[1], lineB.m_pt[1]);
        double x0 = Math.max(lineA.m_pt[0].getX(), lineB.m_pt[0].getX());
        double x1 = Math.min(lineA.m_pt[1].getX(), lineB.m_pt[1].getX());
        double ay0 = Math.min(lineA.m_pt[0].getY(), lineA.m_pt[1].getY());
        double ay1 = Math.max(lineA.m_pt[0].getY(), lineA.m_pt[1].getY());
        double by0 = Math.min(lineB.m_pt[0].getY(), lineB.m_pt[1].getY());
        double by1 = Math.max(lineB.m_pt[0].getY(), lineB.m_pt[1].getY());
        double y0 = Math.max(ay0, by0);
        double y1 = Math.min(ay1, by1);
        double aMinY = Math.min(lineA.m_pt[0].getY(), lineA.m_pt[1].getY()) - sweep.tol();
        double aMaxY = Math.max(lineA.m_pt[0].getY(), lineA.m_pt[1].getY()) + sweep.tol();
        Assert.assertCondition(x1 >= x0);
        if (orderLeft == 0 || orderRight == 0) {
            crossingStatus = CrossStatus.COMMON_END;
        } else if (aMinY > Math.max(lineB.m_pt[0].getY(), lineB.m_pt[1].getY()) || aMaxY < Math.min(lineB.m_pt[0].getY(), lineB.m_pt[1].getY())) {
            return false;
        }
        Cartesian.IntersectResult intResult = new Cartesian.IntersectResult();
        Cartesian.intersect(lineA.m_pt[0], lineA.m_pt[1], lineA.m_longPt[0], lineA.m_longPt[1], lineB.m_pt[0], lineB.m_pt[1], lineB.m_longPt[0], lineB.m_longPt[1], -1.0, intResult);
        DirectPosition truncPt = intResult.getIntersectionPoint();
        if (intResult.intersects()) {
            if (truncPt.getX() < x0) {
                truncPt.setX(x0);
            }
            if (truncPt.getX() > x1) {
                truncPt.setX(x1);
            }
            if (truncPt.getY() < y0) {
                truncPt.setY(y0);
            }
            if (truncPt.getY() > y1) {
                truncPt.setY(y1);
            }
        }
        if (intResult.isParallel()) {
            ActiveLine truncatedLine;
            if (orderLeft == 0) {
                if (orderRight == 0) {
                    truncatedLine = null;
                } else if (orderRight < 0) {
                    truncPt = lineA.m_pt[1];
                    truncB = true;
                    truncatedLine = lineB;
                } else {
                    truncPt = lineB.m_pt[1];
                    truncA = true;
                    truncatedLine = lineA;
                }
            } else if (orderLeft < 0) {
                truncPt = lineB.m_pt[0];
                truncA = true;
                truncatedLine = lineA;
            } else {
                truncPt = lineA.m_pt[0];
                truncB = true;
                truncatedLine = lineB;
            }
            if (truncatedLine == null) {
                truncB = false;
                truncA = false;
            } else {
                DirectPosition projectedPoint = Cartesian.projectPointOnVector(truncPt, truncatedLine.m_pt[0], truncatedLine.m_pt[1]);
                if (!(Cartesian.distanceXY(projectedPoint, truncPt) <= sweep.tol())) {
                    truncB = false;
                    truncA = false;
                }
            }
        } else if (intResult.intersects()) {
            if (crossingStatus == CrossStatus.COMMON_END) {
                return false;
            }
            truncA = true;
            truncB = true;
        }
        if (truncA && PointComparator.INSTANCE.compare(truncPt, lineA.m_pt[0]) <= 0) {
            truncA = false;
        } else if (truncA && PointComparator.INSTANCE.compare(truncPt, lineA.m_pt[1]) >= 0) {
            truncA = false;
        }
        if (truncB && PointComparator.INSTANCE.compare(truncPt, lineB.m_pt[0]) <= 0) {
            truncB = false;
        } else if (truncB && PointComparator.INSTANCE.compare(truncPt, lineB.m_pt[1]) >= 0) {
            truncB = false;
        }
        if (!truncA && !truncB) {
            return false;
        }
        if (PointComparator.INSTANCE.compare(truncPt, sweep.now()) < 0) {
            if (truncA) {
                lineA.m_pt[0] = truncPt;
                sweep.sweepTo(lineA, truncPt);
            }
            if (truncB) {
                lineB.m_pt[0] = truncPt;
                sweep.sweepTo(lineB, truncPt);
            }
        } else {
            SweepEventLinePartiallySwept event;
            if (truncA) {
                Assert.assertCondition(PointComparator.INSTANCE.compare(truncPt, lineA.m_pt[0]) > 0);
                event = new SweepEventLinePartiallySwept(truncPt, lineA, lineA.m_pt[1]);
                event.setEventOrder(event.getEventOrder() + lineA.m_info.getEventBias());
                sweep.events().add(event);
                lineA.m_pt[1] = truncPt;
            }
            if (truncB) {
                Assert.assertCondition(PointComparator.INSTANCE.compare(truncPt, lineB.m_pt[0]) > 0);
                event = new SweepEventLinePartiallySwept(truncPt, lineB, lineB.m_pt[1]);
                event.setEventOrder(event.getEventOrder() + lineB.m_info.getEventBias());
                sweep.events().add(event);
                lineB.m_pt[1] = truncPt;
            }
        }
        return true;
    }

    static void sweptPair(ActiveLine lineA, ActiveLine lineB) {
        Assert.assertCondition(lineA.m_sweep.equals(lineB.m_sweep));
        PlaneSweep sweep = lineA.m_sweep;
        sweep.swept(lineA);
        sweep.swept(lineB);
        Assert.assertCondition(!lineA.m_sliceNode.equals(lineA.m_sweep.slice().end()));
        Assert.assertCondition(!lineB.m_sliceNode.equals(lineB.m_sweep.slice().end()));
        Assert.assertCondition(lineA.m_sweep.slice().next(lineA.m_sliceNode).equals(lineB.m_sliceNode));
        SkipListIterator<ActiveLine> nextNode = sweep.slice().next(lineB.m_sliceNode);
        sweep.slice().erase(lineA.m_sliceNode);
        sweep.slice().erase(lineB.m_sliceNode);
        lineA.m_sliceNode = lineA.m_sweep.slice().end();
        lineB.m_sliceNode = lineB.m_sweep.slice().end();
        if (lineA.m_ghostSlice != null && !lineA.m_ghostNode.equals(lineA.m_ghostSlice.end())) {
            lineA.m_ghostSlice.erase(lineA.m_ghostNode);
            lineA.m_ghostNode = lineA.m_sweep.slice().end();
        }
        if (lineB.m_ghostSlice != null && !lineB.m_ghostNode.equals(lineB.m_ghostSlice.rend())) {
            lineB.m_ghostSlice.erase(lineB.m_ghostNode);
            lineB.m_ghostNode = lineB.m_sweep.slice().end();
        }
        if (!nextNode.equals(lineB.m_sweep.slice().end())) {
            ActiveLine.verifyOrdering(nextNode.getElement().getDatum(), false);
        }
    }

    private static SkipListIterator<ActiveLine> prev(SkipListIterator<ActiveLine> itr) {
        SkipListIterator<ActiveLine> result = itr.getCopy();
        result.prev();
        return result;
    }

    private static SkipListIterator<ActiveLine> next(SkipListIterator<ActiveLine> itr) {
        SkipListIterator<ActiveLine> result = itr.getCopy();
        result.next();
        return result;
    }

    private static enum CrossStatus {
        COMMON_END,
        MAY_CROSS;

    }
}

