/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.operations.s2.ConventionalBufferWidget;

public class CartesianBufferWidget
extends ConventionalBufferWidget {
    private final IDirectPositionList m_dirs = new DirectPositionArray();

    @Override
    IDirectPositionList rawBuffer(DirectPosition pt) {
        DirectPositionArray circle = new DirectPositionArray(this.m_dirs.size() + 1);
        double xwidth = Math.abs(this.getWidth().getFirst());
        double ywidth = Math.abs(this.getWidth().getSecond());
        IDirectPositionIterator i = this.m_dirs.getDirectPositionIterator();
        DirectPosition offset = new DirectPosition();
        while (i.hasNext()) {
            i.nextDirectPosition(offset);
            circle.add(pt.getX() + xwidth * offset.getX(), pt.getY() + ywidth * offset.getY(), pt.getZ());
        }
        circle.add(circle.getDirectPosition(0, new DirectPosition()));
        return circle;
    }

    boolean isInside(DirectPosition q, DirectPosition centre) {
        double y;
        double x = (q.getX() - centre.getX()) / this.getWidth().getFirst();
        return x * x + (y = (q.getY() - centre.getY()) / this.getWidth().getSecond()) * y < 1.0;
    }

    @Override
    void parametersUpdated() {
        if (this.getWidth().getFirst() * this.getWidth().getSecond() < 0.0) {
            throw new IllegalStateException("Width can't be both positive and negative");
        }
        if (this.getWidth().getFirst() > 0.0) {
            this.setSign(1);
        } else if (this.getWidth().getFirst() < 0.0) {
            this.setSign(-1);
        } else {
            this.setSign(0);
        }
        this.m_dirs.clear();
        if (this.getSign() != 0) {
            for (int i = 0; i < this.getResolution(); ++i) {
                double val = Math.PI * 2 * (double)i / (double)this.getResolution();
                this.m_dirs.add(-Math.cos(val), Math.sin(val));
            }
        }
    }
}

