/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.impl.Polygon;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.operations.cartesian.Cartesian;
import com.mapinfo.midev.geometry.operations.s2.ConvexHull;
import com.mapinfo.midev.geometry.operations.s2.IBufferWidget;
import com.mapinfo.midev.geometry.operations.s2.IProgressMonitor;
import com.mapinfo.midev.geometry.operations.s2.InputType;
import com.mapinfo.midev.geometry.operations.s2.S2Utilities;
import com.mapinfo.midev.geometry.operations.s2.Strand;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.tuple.Pair;

abstract class ConventionalBufferWidget
implements IBufferWidget {
    private static final int AVG_SAUSAGE_PIECE = 10;
    private static final int NO_FATTEN_RESOLUTION = 24;
    private IBufferWidget.BufferWidgetOutput m_output = null;
    private IProgressMonitor m_monitor;
    private int m_sign = 0;
    private XYWidth m_width;
    private int m_resolution;
    private double m_tol = 0.0;
    private boolean m_tolSet = false;
    private int m_coordsAdded = 0;
    private int m_totalCoords = 1;

    abstract void parametersUpdated();

    abstract IDirectPositionList rawBuffer(DirectPosition var1);

    @Override
    public void registerOutput(IBufferWidget.BufferWidgetOutput output) {
        this.m_output = output;
    }

    @Override
    public void registerProgressMonitor(IProgressMonitor monitor) {
        this.m_monitor = monitor;
    }

    double getTolerance() {
        return this.m_tol;
    }

    IBufferWidget setTolerance(double tol) {
        this.m_tol = tol;
        this.m_tolSet = true;
        return this;
    }

    int getResolution() {
        return this.m_resolution;
    }

    public void setResolution(int resolution) {
        this.m_resolution = resolution;
        this.parametersUpdated();
    }

    XYWidth getWidth() {
        return this.m_width;
    }

    public void setWidth(XYWidth width) {
        this.m_width = width;
        this.parametersUpdated();
    }

    public void setParameters(XYWidth width, int resolution) {
        this.m_width = width;
        this.m_resolution = resolution;
        this.parametersUpdated();
    }

    public int getSign() {
        return this.m_sign;
    }

    public void setSign(int sign) {
        this.m_sign = sign;
    }

    public int getCoordsAdded() {
        return this.m_coordsAdded;
    }

    public void setCoordsAdded(int coordsAdded) {
        this.m_coordsAdded = coordsAdded;
    }

    public int getTotalCoords() {
        return this.m_totalCoords;
    }

    public void setTotalCoords(int totalCoords) {
        this.m_totalCoords = totalCoords;
    }

    void output(IGeometry geom, boolean target, boolean clean, InputType model) {
        if (this.m_monitor != null) {
            this.m_monitor.progress(this.m_coordsAdded, this.m_totalCoords);
        }
        this.m_output.add(geom, target, clean, model);
    }

    void buffer(SpatialInfo spatialInfo, DirectPosition pt) {
        ++this.m_coordsAdded;
        if (this.m_sign > 0) {
            this.output(new Polygon(spatialInfo, new Ring(spatialInfo, new LineString(spatialInfo, this.rawBuffer(pt)))), true, true, InputType.RingXOR);
        } else if (this.m_sign == 0) {
            this.output(new Point(spatialInfo, pt), true, true, InputType.RingXOR);
        }
    }

    @Override
    public boolean objectOutputsMixable() {
        return this.m_sign >= 0;
    }

    @Override
    public boolean outputPolygonsOnly() {
        return this.m_sign != 0;
    }

    private void buffer(IPolygon poly) {
        boolean enclosed;
        boolean bl = enclosed = this.m_sign > 0;
        if (poly.getInteriorRingCount() == 0) {
            enclosed = this.buffer(poly.getExteriorRing(), enclosed);
        } else {
            enclosed = false;
            this.buffer(poly.getExteriorRing(), false);
            Iterator<IRing> ringIterator = poly.getInteriorRingIterator();
            while (ringIterator.hasNext()) {
                this.buffer(ringIterator.next(), false);
            }
        }
        this.m_coordsAdded += GeometryUtilities.getNodeCount(poly);
        if (this.m_sign > 0) {
            if (!enclosed) {
                this.output(poly, true, false, InputType.RingXOR);
            }
        } else {
            this.output(poly, true, false, InputType.RingXOR);
        }
    }

    @Override
    public void buffer(IGeometry geom) {
        if (this.m_sign == 0) {
            this.m_totalCoords = 1;
            this.m_coordsAdded = 1;
            this.output(geom, true, false, InputType.RingXOR);
            return;
        }
        this.m_totalCoords = 1;
        this.m_coordsAdded = 0;
        if (this.m_monitor != null) {
            this.m_totalCoords = 0;
            if ((double)this.m_sign > 0.0) {
                this.m_totalCoords += S2Utilities.getAllPoints(geom).size();
                this.m_totalCoords += GeometryUtilities.getNodeCount(S2Utilities.getAllCurves(geom));
            }
            this.m_totalCoords += 2 * GeometryUtilities.getNodeCount(S2Utilities.getAllPolygons(geom));
        }
        if (this.m_sign > 0) {
            IDirectPositionList pts = S2Utilities.getAllPoints(geom);
            IDirectPositionIterator ptIterator = pts.getDirectPositionIterator();
            while (ptIterator.hasNext()) {
                this.buffer(geom.getSpatialInfo(), ptIterator.nextDirectPosition(new DirectPosition()));
            }
            IMultiCurve allCurves = S2Utilities.getAllCurves(geom);
            for (ICurve curve : allCurves) {
                this.buffer(curve, false);
            }
        }
        IMultiPolygon allPolygons = S2Utilities.getAllPolygons(geom);
        boolean index = false;
        for (IPolygon polygon : allPolygons) {
            this.buffer(polygon);
            if (this.objectOutputsMixable()) continue;
            this.m_output.flushLocal();
        }
    }

    private boolean buffer(ICurve curve, boolean enclosable) {
        if (curve.getCurveSegmentCount() == 1) {
            return this.buffer(curve.getCurveSegment(0), enclosable);
        }
        for (ICurveSegment segment : curve) {
            this.buffer(segment, false);
        }
        return false;
    }

    private boolean buffer(IRing ring, boolean enclosable) {
        if (ring.getCurveSegmentCount() == 1) {
            return this.buffer(ring.getCurveSegment(0), enclosable);
        }
        for (ICurveSegment segment : ring) {
            this.buffer(segment, false);
        }
        return false;
    }

    private static DirectPosition normalPerp(DirectPosition pt1, DirectPosition pt2) {
        DirectPosition perpVec = new DirectPosition(pt2.getY() - pt1.getY(), -(pt2.getX() - pt1.getX()));
        double len = Math.sqrt(perpVec.getX() * perpVec.getX() + perpVec.getY() * perpVec.getY());
        if (len != 0.0) {
            perpVec.setX(perpVec.getX() / len);
            perpVec.setY(perpVec.getY() / len);
        }
        return perpVec;
    }

    private static boolean perpSort(DirectPosition a, DirectPosition b, double centerY) {
        if (a.getY() >= centerY && b.getY() < centerY) {
            return true;
        }
        if (a.getY() < centerY && b.getY() >= centerY) {
            return false;
        }
        if (a.getY() >= centerY) {
            return a.getX() < b.getX();
        }
        return a.getX() > b.getX();
    }

    private BallInfo fatBall(IDirectPositionList coords, int k, boolean isClosed) {
        if (isClosed) {
            if (coords.size() < 3) {
                isClosed = false;
            } else {
                S2Utilities.assertClosed(coords);
            }
        }
        double xwidth = Math.abs(this.m_width.first);
        double ywidth = Math.abs(this.m_width.second);
        double centerY = coords.getDirectPosition(k, new DirectPosition()).getY();
        ArrayList<Object> perps = new ArrayList<Object>();
        if (this.m_resolution < 24) {
            DirectPosition perpVec;
            int adj = k;
            if (k > 0) {
                adj = k - 1;
            } else if (isClosed) {
                adj = coords.size() - 2;
            }
            if (adj != k && ((perpVec = ConventionalBufferWidget.normalPerp(coords.getDirectPosition(k, new DirectPosition()), coords.getDirectPosition(adj, new DirectPosition()))).getX() != 0.0 || perpVec.getY() != 0.0)) {
                perps.add(new DirectPosition(coords.getDirectPosition(k, new DirectPosition()).getX() + xwidth * perpVec.getX(), coords.getDirectPosition(k, new DirectPosition()).getY() + ywidth * perpVec.getY()));
                perps.add(new DirectPosition(coords.getDirectPosition(k, new DirectPosition()).getX() - xwidth * perpVec.getX(), coords.getDirectPosition(k, new DirectPosition()).getY() - ywidth * perpVec.getY()));
            }
            adj = k;
            if (k + 1 < coords.size()) {
                adj = k + 1;
            } else if (isClosed) {
                adj = 1;
            }
            if (adj != k && ((perpVec = ConventionalBufferWidget.normalPerp(coords.getDirectPosition(k, new DirectPosition()), coords.getDirectPosition(adj, new DirectPosition()))).getX() != 0.0 || perpVec.getY() != 0.0)) {
                perps.add(new DirectPosition(coords.getDirectPosition(k, new DirectPosition()).getX() + xwidth * perpVec.getX(), coords.getDirectPosition(k, new DirectPosition()).getY() + ywidth * perpVec.getY()));
                perps.add(new DirectPosition(coords.getDirectPosition(k, new DirectPosition()).getX() - xwidth * perpVec.getX(), coords.getDirectPosition(k, new DirectPosition()).getY() - ywidth * perpVec.getY()));
            }
        }
        for (int sorted = 1; sorted < perps.size(); ++sorted) {
            int insertPt;
            DirectPosition temp = (DirectPosition)perps.get(sorted);
            for (insertPt = sorted; insertPt > 0 && ConventionalBufferWidget.perpSort(temp, (DirectPosition)perps.get(insertPt - 1), centerY); --insertPt) {
            }
            for (int k2 = sorted; k2 > insertPt; --k2) {
                perps.set(k2, perps.get(k2 - 1));
            }
            perps.set(insertPt, temp);
        }
        IDirectPositionList rawBall = this.rawBuffer(coords.getDirectPosition(k, new DirectPosition()));
        if (perps.size() == 0) {
            return new BallInfo(coords.getDirectPosition(k, new DirectPosition()), rawBall);
        }
        DirectPositionArray ball = new DirectPositionArray(rawBall.size() + perps.size());
        int rb_end = rawBall.size() - 1;
        ball.add(rawBall.getDirectPosition(0, new DirectPosition()));
        int rb = 1;
        int p = 0;
        while (p < perps.size() && rb < rb_end) {
            if (ConventionalBufferWidget.perpSort((DirectPosition)perps.get(p), rawBall.getDirectPosition(rb, new DirectPosition()), centerY)) {
                ball.add((DirectPosition)perps.get(p));
                ++p;
                continue;
            }
            ball.add(rawBall.getDirectPosition(rb, new DirectPosition()));
            ++rb;
        }
        while (p < perps.size()) {
            ball.add((DirectPosition)perps.get(p));
            ++p;
        }
        while (rb < rawBall.size()) {
            ball.add(rawBall.getDirectPosition(rb, new DirectPosition()));
            ++rb;
        }
        S2Utilities.assertClosed(rawBall);
        return new BallInfo(coords.getDirectPosition(k, new DirectPosition()), ball);
    }

    private static void pushConvexHull(Pair<Strand, Strand> strands, IDirectPositionList top, IDirectPositionList bottom, DirectPosition dir) {
        Assert.assertCondition(((Strand)strands.getLeft()).size() == 0);
        if (top.size() + bottom.size() == 0) {
            return;
        }
        ConvexHullWrapper ch = new ConvexHullWrapper(top, bottom);
        int index = 0;
        double minDot = 0.0;
        int minDotIndex = index;
        double maxDot = 0.0;
        int maxDotIndex = index;
        do {
            double dot = Cartesian.dotProduct(ch.get(index), dir);
            if (index == minDotIndex || dot < minDot) {
                minDot = dot;
                minDotIndex = index;
            }
            if (index != maxDotIndex && !(dot > maxDot)) continue;
            maxDot = dot;
            maxDotIndex = index;
        } while ((index = ch.next(index, Cartesian.Turn.CW)) != 0);
        index = minDotIndex;
        while (index != maxDotIndex) {
            ((Strand)strands.getLeft()).push(ch.get(index));
            index = ch.next(index, Cartesian.Turn.CW);
        }
        ((Strand)strands.getLeft()).push(ch.get(maxDotIndex));
        index = ch.next(minDotIndex, Cartesian.Turn.CCW);
        while (index != maxDotIndex) {
            ((Strand)strands.getRight()).push(ch.get(index));
            index = ch.next(index, Cartesian.Turn.CCW);
        }
        ((Strand)strands.getRight()).push(ch.get(maxDotIndex));
    }

    private static void merge(Pair<Strand, Strand> strands, IDirectPositionList top, IDirectPositionList bottom, DirectPosition dir, boolean backtracking) {
        int temp;
        if (((Strand)strands.getLeft()).size() == 0) {
            ConventionalBufferWidget.pushConvexHull(strands, top, bottom, dir);
            return;
        }
        ShortenResult firstResult = ConventionalBufferWidget.shorten((Strand)strands.getLeft(), top, bottom);
        if (backtracking && firstResult.m_type == eStatus.EXACT) {
            throw new SausageThrow(SausageThrow.Value.BACKTRACK);
        }
        ShortenResult secondResult = ConventionalBufferWidget.shorten((Strand)strands.getRight(), top, bottom);
        if (backtracking && secondResult.m_type == eStatus.EXACT) {
            throw new SausageThrow(SausageThrow.Value.BACKTRACK);
        }
        if (firstResult.m_edge2 < 0) {
            temp = firstResult.m_edge2;
            firstResult.m_edge2 = firstResult.m_edge1;
            firstResult.m_edge1 = temp;
        }
        if (secondResult.m_edge2 < 0) {
            temp = secondResult.m_edge2;
            secondResult.m_edge2 = secondResult.m_edge1;
            secondResult.m_edge1 = temp;
        }
        ConvexHullWrapper ch = new ConvexHullWrapper(top, bottom);
        firstResult.m_edge1 = ch.normalize(firstResult.m_edge1);
        firstResult.m_edge2 = ch.normalize(firstResult.m_edge2);
        secondResult.m_edge1 = ch.normalize(secondResult.m_edge1);
        secondResult.m_edge2 = ch.normalize(secondResult.m_edge2);
        DirectPosition leftStrand = firstResult.m_type == eStatus.EXACT ? ch.get(firstResult.m_edge2) : firstResult.m_intersection;
        DirectPosition rightStrand = secondResult.m_type == eStatus.EXACT ? ch.get(secondResult.m_edge2) : secondResult.m_intersection;
        int index = firstResult.m_edge2;
        DirectPosition cur = ch.get(index);
        int count = top.size() + bottom.size();
        boolean found = false;
        while (!found && count > 0) {
            --count;
            index = ch.next(index, Cartesian.Turn.CW);
            DirectPosition next = ch.get(index);
            switch (Cartesian.turn(leftStrand, rightStrand, next)) {
                case CCW: {
                    found = true;
                    break;
                }
                case COLINEAR: {
                    break;
                }
                case CW: {
                    throw new SausageThrow(SausageThrow.Value.HULL_WRONG_WAY);
                }
            }
        }
        if (!found) {
            throw new SausageThrow(SausageThrow.Value.CANT_ORIENT_HULL);
        }
        while (firstResult.m_numDrop > 0) {
            ((Strand)strands.getLeft()).pop_back();
            --firstResult.m_numDrop;
        }
        while (secondResult.m_numDrop > 0) {
            ((Strand)strands.getRight()).pop_back();
            --secondResult.m_numDrop;
        }
        double maxDot = 0.0;
        int maxDotIndex = index = firstResult.m_edge2;
        count = 1;
        do {
            ++count;
            double dot = Cartesian.dotProduct(ch.get(index), dir);
            if (index != maxDotIndex && !(dot > maxDot)) continue;
            maxDot = dot;
            maxDotIndex = index;
        } while ((index = ch.next(index, Cartesian.Turn.CW)) != secondResult.m_edge1);
        int lastIndex = index;
        if (firstResult.m_type == eStatus.OUT) {
            ((Strand)strands.getLeft()).push(firstResult.m_intersection);
        }
        index = firstResult.m_edge2;
        while (index != maxDotIndex) {
            Assert.assertCondition(count > 0);
            --count;
            ((Strand)strands.getLeft()).push(ch.get(index));
            index = ch.next(index, Cartesian.Turn.CW);
        }
        ((Strand)strands.getLeft()).push(ch.get(maxDotIndex));
        if (secondResult.m_type == eStatus.OUT) {
            ((Strand)strands.getRight()).push(secondResult.m_intersection);
        }
        index = lastIndex;
        while (count > 0) {
            --count;
            ((Strand)strands.getRight()).push(ch.get(index));
            index = ch.next(index, Cartesian.Turn.CCW);
        }
        Assert.assertCondition(((Strand)strands.getRight()).get(0).equals((Object)ch.get(maxDotIndex)));
    }

    private static ShortenResult shorten(Strand strand, IDirectPositionList top, IDirectPositionList bottom) {
        Cartesian.IntersectResult intResult;
        int tsize = top.size();
        int bsize = bottom.size();
        Assert.assertCondition(top.getDirectPosition(0, new DirectPosition()).equalsXY(bottom.getDirectPosition(0, new DirectPosition())) || top.getDirectPosition(tsize - 1, new DirectPosition()).equalsXY(bottom.getDirectPosition(bsize - 1, new DirectPosition())));
        int curStrand = 0;
        DirectPosition curStrandPt = strand.get(curStrand);
        eStatus curStrandStatus = eStatus.NOINFO;
        int curStrandMatch = 0;
        eStatus prevStrandStatus = eStatus.NOINFO;
        int prevStrandMatch = 0;
        int tPt = tsize / 2;
        int bPt = bsize / 2;
        boolean done = false;
        while (!done) {
            while (tPt > 0) {
                DirectPosition directPosition = new DirectPosition();
                if (!(top.getDirectPosition(tPt, directPosition).getX() > curStrandPt.getX())) break;
                --tPt;
            }
            while (tPt + 2 < tsize) {
                DirectPosition directPosition = new DirectPosition();
                if (!(top.getDirectPosition(tPt + 1, directPosition).getX() <= curStrandPt.getX())) break;
                ++tPt;
            }
            while (bPt > 0) {
                DirectPosition directPosition = new DirectPosition();
                if (!(bottom.getDirectPosition(bPt, directPosition).getX() > curStrandPt.getX())) break;
                --bPt;
            }
            while (bPt + 2 < bsize) {
                DirectPosition directPosition = new DirectPosition();
                if (!(bottom.getDirectPosition(bPt + 1, directPosition).getX() <= curStrandPt.getX())) break;
                ++bPt;
            }
            if (curStrandPt.equalsXY(top.getDirectPosition(tPt, new DirectPosition()))) {
                curStrandStatus = eStatus.EXACT;
                curStrandMatch = tPt;
            } else if (curStrandPt.equalsXY(bottom.getDirectPosition(bPt, new DirectPosition()))) {
                curStrandStatus = eStatus.EXACT;
                curStrandMatch = -bPt;
            } else if (Cartesian.turn(top.getDirectPosition(tPt, new DirectPosition()), curStrandPt, top.getDirectPosition(tPt + 1, new DirectPosition())) == Cartesian.Turn.CW || Cartesian.turn(bottom.getDirectPosition(bPt, new DirectPosition()), curStrandPt, bottom.getDirectPosition(bPt + 1, new DirectPosition())) == Cartesian.Turn.CCW) {
                curStrandStatus = eStatus.OUT;
                done = true;
            } else {
                curStrandStatus = eStatus.IN;
            }
            if (done) continue;
            if (++curStrand >= strand.size()) {
                throw new SausageThrow(SausageThrow.Value.STRAND_EXHAUSTED);
            }
            curStrandPt = strand.get(curStrand);
            prevStrandStatus = curStrandStatus;
            prevStrandMatch = curStrandMatch;
            curStrandStatus = eStatus.NOINFO;
        }
        if (curStrandStatus != eStatus.OUT) {
            throw new SausageThrow(SausageThrow.Value.STRAND_NEVER_OUT);
        }
        if (prevStrandStatus == eStatus.OUT || prevStrandStatus == eStatus.NOINFO) {
            throw new SausageThrow(SausageThrow.Value.UNCLEAN_TRANSITION);
        }
        ShortenResult result = new ShortenResult();
        if (prevStrandStatus != eStatus.EXACT) {
            prevStrandMatch = Integer.MAX_VALUE;
        }
        result.m_numDrop = curStrand;
        result.m_type = eStatus.OUT;
        Assert.assertCondition(curStrand > 0);
        DirectPosition lastDropped = strand.get(curStrand - 1);
        double minx = Math.min(curStrandPt.getX(), lastDropped.getX());
        double maxx = Math.max(curStrandPt.getX(), lastDropped.getX());
        double miny = Math.min(curStrandPt.getY(), lastDropped.getY());
        double maxy = Math.max(curStrandPt.getY(), lastDropped.getY());
        while (tPt > 0) {
            DirectPosition directPosition = new DirectPosition();
            if (!(top.getDirectPosition(tPt, directPosition).getX() >= minx)) break;
            --tPt;
        }
        while (tPt + 1 < tsize) {
            block31: {
                block30: {
                    DirectPosition directPosition = new DirectPosition();
                    if (!(top.getDirectPosition(tPt, directPosition).getX() <= maxx)) break;
                    DirectPosition directPosition2 = new DirectPosition();
                    if (!(top.getDirectPosition(tPt, directPosition2).getY() < miny)) break block30;
                    if (top.getDirectPosition(tPt + 1, new DirectPosition()).getY() < miny) break block31;
                }
                if (!(top.getDirectPosition(tPt, new DirectPosition()).getY() > maxy && top.getDirectPosition(tPt + 1, new DirectPosition()).getY() > maxy || tPt == prevStrandMatch || tPt + 1 == prevStrandMatch)) {
                    intResult = new Cartesian.IntersectResult();
                    Cartesian.intersect(curStrandPt, lastDropped, curStrandPt, lastDropped, top.getDirectPosition(tPt, new DirectPosition()), top.getDirectPosition(tPt + 1, new DirectPosition()), top.getDirectPosition(tPt, new DirectPosition()), top.getDirectPosition(tPt + 1, new DirectPosition()), 0.0, intResult);
                    if (intResult.intersects()) {
                        result.m_intersection = intResult.getIntersectionPoint();
                        result.m_edge1 = tPt;
                        result.m_edge2 = tPt + 1;
                        return result;
                    }
                }
            }
            ++tPt;
        }
        while (bPt > 0) {
            DirectPosition directPosition = new DirectPosition();
            if (!(bottom.getDirectPosition(bPt, directPosition).getX() >= minx)) break;
            --bPt;
        }
        while (bPt + 1 < bsize) {
            block33: {
                block32: {
                    DirectPosition directPosition = new DirectPosition();
                    if (!(bottom.getDirectPosition(bPt, directPosition).getX() <= maxx)) break;
                    DirectPosition directPosition3 = new DirectPosition();
                    if (!(bottom.getDirectPosition(bPt, directPosition3).getY() < miny)) break block32;
                    if (bottom.getDirectPosition(bPt + 1, new DirectPosition()).getY() < miny) break block33;
                }
                if (!(bottom.getDirectPosition(bPt, new DirectPosition()).getY() > maxy && bottom.getDirectPosition(bPt + 1, new DirectPosition()).getY() > maxy || -bPt == prevStrandMatch || -(bPt + 1) == prevStrandMatch)) {
                    intResult = new Cartesian.IntersectResult();
                    Cartesian.intersect(curStrandPt, lastDropped, curStrandPt, lastDropped, bottom.getDirectPosition(bPt, new DirectPosition()), bottom.getDirectPosition(bPt + 1, new DirectPosition()), bottom.getDirectPosition(bPt, new DirectPosition()), bottom.getDirectPosition(bPt + 1, new DirectPosition()), 0.0, intResult);
                    if (intResult.intersects()) {
                        result.m_intersection = intResult.getIntersectionPoint();
                        result.m_edge1 = -bPt;
                        result.m_edge2 = -(bPt + 1);
                        return result;
                    }
                }
            }
            ++bPt;
        }
        if (prevStrandStatus == eStatus.EXACT) {
            result.m_numDrop = curStrand;
            result.m_type = eStatus.EXACT;
            result.m_edge1 = result.m_edge2 = prevStrandMatch;
            return result;
        }
        throw new SausageThrow(SausageThrow.Value.NO_INTERSECTION);
    }

    private IDirectPositionList flatSortBalls(IDirectPositionList ballA, IDirectPositionList ballB) {
        DirectPositionArray result = new DirectPositionArray(ballA.size() + ballB.size());
        int startA = 0;
        int endA = ballA.size() - 1;
        int startB = 0;
        int endB = ballB.size() - 1;
        if (ballA.size() > 0 && ballB.size() > 0) {
            while (startA <= endA && startB <= endB) {
                int indexA = ballA.getDirectPosition(startA, new DirectPosition()).getX() < ballA.getDirectPosition(endA, new DirectPosition()).getX() ? startA : endA;
                int indexB = ballB.getDirectPosition(startB, new DirectPosition()).getX() < ballB.getDirectPosition(endB, new DirectPosition()).getX() ? startB : endB;
                DirectPosition directPosition = new DirectPosition();
                DirectPosition directPosition2 = new DirectPosition();
                if (ballA.getDirectPosition(indexA, directPosition).getX() < ballB.getDirectPosition(indexB, directPosition2).getX()) {
                    result.add(ballA.getDirectPosition(indexA, new DirectPosition()));
                    if (indexA == startA) {
                        ++startA;
                        continue;
                    }
                    --endA;
                    continue;
                }
                result.add(ballB.getDirectPosition(indexB, new DirectPosition()));
                if (indexB == startB) {
                    ++startB;
                    continue;
                }
                --endB;
            }
        }
        if (ballA.size() > 0) {
            while (startA <= endA) {
                DirectPosition directPosition = new DirectPosition();
                DirectPosition directPosition3 = new DirectPosition();
                if (ballA.getDirectPosition(startA, directPosition).getX() < ballA.getDirectPosition(endA, directPosition3).getX()) {
                    result.add(ballA.getDirectPosition(startA, new DirectPosition()));
                    ++startA;
                    continue;
                }
                result.add(ballA.getDirectPosition(endA, new DirectPosition()));
                --endA;
            }
        }
        if (ballB.size() > 0) {
            while (startB <= endB) {
                DirectPosition directPosition = new DirectPosition();
                DirectPosition directPosition4 = new DirectPosition();
                if (ballB.getDirectPosition(startB, directPosition).getX() < ballB.getDirectPosition(endB, directPosition4).getX()) {
                    result.add(ballB.getDirectPosition(startB, new DirectPosition()));
                    ++startB;
                    continue;
                }
                result.add(ballB.getDirectPosition(endB, new DirectPosition()));
                --endB;
            }
        }
        return result;
    }

    boolean buffer(ICurveSegment seg, boolean enclosable) {
        boolean isClosed = seg.isClosed();
        if (!isClosed) {
            enclosable = false;
        }
        enclosable = false;
        DirectPositionArray coords = new DirectPositionArray(seg.getControlPoints());
        DirectPosition lastCoord = coords.getDirectPosition(0, new DirectPosition());
        int n = coords.size();
        int out = 1;
        for (int in = 1; in < n; ++in) {
            if (in != out) {
                coords.set(out, coords.getDirectPosition(in, new DirectPosition()));
            }
            if (lastCoord.equalsXY(coords.getDirectPosition(in, new DirectPosition()))) continue;
            ++out;
            lastCoord = coords.getDirectPosition(in, new DirectPosition());
        }
        n = out;
        if (n == 1) {
            this.output(new Polygon(seg.getSpatialInfo(), new Ring(seg.getSpatialInfo(), new LineString(seg.getSpatialInfo(), this.rawBuffer(coords.getDirectPosition(0, new DirectPosition()))))), this.m_sign >= 0, true, InputType.RingXOR);
            return enclosable;
        }
        ++this.m_coordsAdded;
        Pair<Strand, Strand> strands = Strand.newPair();
        BallInfo prevBall = this.fatBall(coords, 0, isClosed);
        DirectPosition prevPt = new DirectPosition(coords.getDirectPosition(0, new DirectPosition()));
        DirectPosition prevDir = new DirectPosition(0.0, 0.0);
        int sausageCount = 0;
        for (int cur = 1; cur < n; ++cur) {
            ++this.m_coordsAdded;
            BallInfo curBall = this.fatBall(coords, cur, isClosed);
            DirectPositionArray top = new DirectPositionArray();
            DirectPositionArray bottom = new DirectPositionArray();
            ConvexHull.compute(this.flatSortBalls(prevBall.m_ball, curBall.m_ball), top, bottom);
            DirectPosition curPt = coords.getDirectPosition(cur, new DirectPosition());
            DirectPosition dir = new DirectPosition(curPt.getX() - prevPt.getX(), curPt.getY() - prevPt.getY());
            boolean outputStrand = false;
            if (sausageCount >= 20) {
                outputStrand = true;
            } else {
                try {
                    boolean backtracking = Cartesian.dotProduct(dir, prevDir) < 0.0;
                    ConventionalBufferWidget.merge(strands, top, bottom, dir, backtracking);
                    ++sausageCount;
                }
                catch (SausageThrow oops) {
                    outputStrand = true;
                }
            }
            if (outputStrand) {
                this.output(new Polygon(seg.getSpatialInfo(), new Ring(seg.getSpatialInfo(), new LineString(seg.getSpatialInfo(), ((Strand)strands.getLeft()).asCoordList(0.0)))), this.m_sign >= 0, false, InputType.Orientable);
                strands = Strand.newPair();
                ConventionalBufferWidget.merge(strands, top, bottom, dir, false);
                sausageCount = 1;
                prevDir = new DirectPosition(0.0, 0.0);
            } else {
                prevDir = dir;
            }
            prevPt = curPt;
            prevBall = curBall;
        }
        this.output(new Polygon(seg.getSpatialInfo(), new Ring(seg.getSpatialInfo(), new LineString(seg.getSpatialInfo(), ((Strand)strands.getLeft()).asCoordList(0.0)))), this.m_sign >= 0, false, InputType.Orientable);
        return enclosable;
    }

    private static class SausageThrow
    extends RuntimeException {
        private final Value m_value;

        private SausageThrow(Value value) {
            this.m_value = value;
        }

        private Value getValue() {
            return this.m_value;
        }

        static enum Value {
            STRAND_EXHAUSTED,
            STRAND_NEVER_OUT,
            UNCLEAN_TRANSITION,
            NO_INTERSECTION,
            CANT_ORIENT_HULL,
            HULL_WRONG_WAY,
            EXACT_SHOULD_BE_IN,
            BACKTRACK,
            size;

        }
    }

    private static class ShortenResult {
        int m_numDrop = 0;
        eStatus m_type = eStatus.NOINFO;
        int m_edge1 = 0;
        int m_edge2 = 0;
        DirectPosition m_intersection = null;

        private ShortenResult() {
        }
    }

    public static class XYWidth {
        private final double first;
        private final double second;

        public XYWidth(double first, double second) {
            this.first = first;
            this.second = second;
        }

        public double getFirst() {
            return this.first;
        }

        public double getSecond() {
            return this.second;
        }
    }

    private static final class BallInfo {
        private IDirectPositionList m_ball;
        private DirectPosition m_centre;

        private BallInfo(DirectPosition centre, IDirectPositionList ball) {
            this.m_centre = centre;
            this.m_ball = ball;
        }

        int next(int cur, int dir) {
            if (dir < 0 && cur == 0) {
                return this.m_ball.size() - 1;
            }
            if (dir > 0 && cur == this.m_ball.size() - 1) {
                return 0;
            }
            return cur + dir;
        }
    }

    private static enum eStatus {
        NOINFO,
        IN,
        OUT,
        EXACT;

    }

    private static class ConvexHullWrapper {
        private final IDirectPositionList m_top;
        private final int m_tsize;
        private final IDirectPositionList m_bottom;
        private final int m_bsize;

        private ConvexHullWrapper(IDirectPositionList top, IDirectPositionList bottom) {
            this.m_top = top;
            this.m_tsize = top.size();
            this.m_bottom = bottom;
            this.m_bsize = bottom.size();
        }

        DirectPosition get(int index) {
            if (index >= 0) {
                return this.m_top.getDirectPosition(index, new DirectPosition());
            }
            return this.m_bottom.getDirectPosition(-index, new DirectPosition());
        }

        int normalize(int index) {
            if (index == -(this.m_bsize - 1)) {
                return this.m_tsize - 1;
            }
            return index;
        }

        int next(int index, Cartesian.Turn dir) {
            int result = index;
            if (dir == Cartesian.Turn.CW) {
                if (++result >= this.m_tsize) {
                    result = -(this.m_bsize - 2);
                }
            } else if (dir == Cartesian.Turn.CCW) {
                if (--result <= -(this.m_bsize - 1)) {
                    result = this.m_tsize - 1;
                }
            } else {
                throw new IllegalStateException();
            }
            return result;
        }
    }
}

