/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.MultiFeatureGeometry;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.impl.XYDirectPositionArray;
import com.mapinfo.midev.geometry.operations.s2.CutterType;
import com.mapinfo.midev.geometry.operations.s2.InputType;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweepErase;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweepMultiErase;
import com.mapinfo.midev.geometry.operations.s2.S2Utilities;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class EraseOutside {
    private final List<Pair<IGeometry, CutterType>> m_geoms = new ArrayList<Pair<IGeometry, CutterType>>();
    private final SpatialInfo m_spatialInfo;

    public EraseOutside(SpatialInfo spatialInfo) {
        this.m_spatialInfo = spatialInfo;
    }

    public void add(IGeometry geometry, CutterType cutterType) {
        this.m_geoms.add((Pair<IGeometry, CutterType>)new ImmutablePair((Object)geometry, (Object)cutterType));
    }

    public IFeatureGeometry result() {
        PlaneSweepMultiErase sweep = new PlaneSweepMultiErase(this.m_spatialInfo, 0.0);
        for (Pair<IGeometry, CutterType> geom : this.m_geoms) {
            sweep.addGeometry((IGeometry)geom.getLeft(), (CutterType)((Object)geom.getRight()), InputType.RingXOR);
        }
        Ring extra_cutter = EraseOutside.createExtraCutter(this.m_spatialInfo);
        sweep.addGeometry(extra_cutter, CutterType.INTERIOR, InputType.RingXOR);
        ArrayList<IGeometry> result = new ArrayList<IGeometry>();
        sweep.sweep(result);
        return S2Utilities.toMinimalFeatureGeometry(this.m_spatialInfo, result);
    }

    public static IFeatureGeometry eraseOutside(IGeometry target, IGeometry cutter) {
        if (target.isEmpty()) {
            return new MultiFeatureGeometry(target.getSpatialInfo());
        }
        PlaneSweepErase sweep = new PlaneSweepErase(target.getSpatialInfo(), 0.0);
        Ring extra_cutter = EraseOutside.createExtraCutter(target.getSpatialInfo());
        sweep.addGeometry(target, CutterType.NONE, InputType.RingXOR);
        sweep.addGeometry(cutter, CutterType.EXTERIOR, InputType.RingXOR);
        sweep.addGeometry(extra_cutter, CutterType.EXTERIOR, InputType.RingXOR);
        return sweep.sweep();
    }

    private static Ring createExtraCutter(SpatialInfo spatialInfo) {
        XYDirectPositionArray coords = new XYDirectPositionArray(new DirectPosition(-1.7976931348623157E308, -1.7976931348623157E308), new DirectPosition(Double.MAX_VALUE, -1.7976931348623157E308), new DirectPosition(Double.MAX_VALUE, Double.MAX_VALUE), new DirectPosition(-1.7976931348623157E308, Double.MAX_VALUE), new DirectPosition(-1.7976931348623157E308, -1.7976931348623157E308));
        return new Ring(spatialInfo, new LineString(spatialInfo, coords));
    }
}

