/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.operations.GeometryOperationsUtilities;
import com.mapinfo.midev.geometry.operations.s2.ConventionalBufferWidget;
import com.mapinfo.midev.geometry.operations.s2.IWidthProvider;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.unit.Offset;

public class FauxSphericalWidthProvider
implements IWidthProvider {
    private final Offset m_offset;

    public FauxSphericalWidthProvider(Offset offset) {
        this.m_offset = Offset.convert((Offset)offset, (LinearUnit)LinearUnit.METER);
    }

    @Override
    public int getSign() {
        return this.m_offset.getValue() == 0.0 ? 0 : (this.m_offset.getValue() > 0.0 ? 1 : -1);
    }

    @Override
    public ConventionalBufferWidget.XYWidth create(IGeometry geometry) {
        Envelope bounds = geometry.getEnvelope();
        DirectPosition middle = bounds.isEmpty() ? new DirectPosition(0.0, 0.0) : bounds.getCenter();
        int sign = this.m_offset.getValue() > 0.0 ? 1 : -1;
        DirectPosition dpX = new DirectPosition(middle);
        DirectPosition dpY = new DirectPosition(middle);
        GeometryOperationsUtilities.adjustPointsUsingDistance(middle, dpX, bounds.getSpatialInfo().getCoordSys(), this.m_offset, false, true);
        GeometryOperationsUtilities.adjustPointsUsingDistance(middle, dpY, bounds.getSpatialInfo().getCoordSys(), this.m_offset, false, false);
        double bufferDistanceX = (double)sign * Math.abs(middle.getX() - dpX.getX());
        double bufferDistanceY = (double)sign * Math.abs(middle.getY() - dpY.getY());
        LinearUnit destinationUnit = CoordSysUtilities.getLinearUnit((CoordSys)geometry.getCoordSys());
        if (destinationUnit != null && destinationUnit != this.m_offset.getUnit()) {
            bufferDistanceX = LinearUnit.convert((double)bufferDistanceX, (LinearUnit)this.m_offset.getUnit(), (LinearUnit)destinationUnit);
            bufferDistanceY = LinearUnit.convert((double)bufferDistanceY, (LinearUnit)this.m_offset.getUnit(), (LinearUnit)destinationUnit);
        }
        return new ConventionalBufferWidget.XYWidth(bufferDistanceX, bufferDistanceY);
    }
}

