/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.impl.MultiPoint;
import com.mapinfo.midev.geometry.operations.s2.CartesianBufferWidget;
import com.mapinfo.midev.geometry.operations.s2.ConventionalBufferWidget;
import com.mapinfo.midev.geometry.operations.s2.IWidthProvider;
import com.mapinfo.midev.geometry.operations.s2.S2Utilities;

public class LegacyBufferWidget
extends CartesianBufferWidget {
    private final IWidthProvider m_widthProvider;
    private final int m_resolution;

    public LegacyBufferWidget(IWidthProvider widthProvider, int resolution) {
        this.m_widthProvider = widthProvider;
        this.m_resolution = Math.max(4, resolution);
    }

    @Override
    public boolean objectOutputsMixable() {
        return this.m_widthProvider.getSign() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buffer(IGeometry geom) {
        this.setParameters(this.m_widthProvider.create(geom), this.m_resolution);
        if (this.getSign() >= 0) {
            super.buffer(geom);
        } else {
            super.buffer(S2Utilities.getAllPolygons(geom));
            this.setSign(1);
            ConventionalBufferWidget.XYWidth originalWidth = this.getWidth();
            this.setWidth(new ConventionalBufferWidget.XYWidth(Math.abs(originalWidth.getFirst()), Math.abs(originalWidth.getSecond())));
            try {
                super.buffer(S2Utilities.getAllCurves(geom));
                super.buffer(new MultiPoint(geom.getSpatialInfo(), S2Utilities.getAllPoints(geom)));
            }
            finally {
                this.setSign(-1);
                this.setWidth(originalWidth);
            }
        }
    }
}

