/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.operations.s2.ActiveLine;
import com.mapinfo.midev.geometry.operations.s2.ActiveLineList;
import com.mapinfo.midev.geometry.operations.s2.CutterType;
import com.mapinfo.midev.geometry.operations.s2.IProgressMonitor;
import com.mapinfo.midev.geometry.operations.s2.InputType;
import com.mapinfo.midev.geometry.operations.s2.LoopList;
import com.mapinfo.midev.geometry.operations.s2.PointComparator;
import com.mapinfo.midev.geometry.operations.s2.S2Utilities;
import com.mapinfo.midev.geometry.operations.s2.SkipListIterator;
import com.mapinfo.midev.geometry.operations.s2.SweepEvent;
import com.mapinfo.midev.geometry.operations.s2.SweepEventControlPoint;
import com.mapinfo.midev.geometry.operations.s2.SweepEventEnd;
import com.mapinfo.midev.geometry.operations.s2.SweepEventStart;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

abstract class PlaneSweep {
    public static final int DEFAULT_CALLBACK_FREQUENCY = 1000;
    private final double m_tolerance;
    private final PriorityQueue<SweepEvent> m_events = new PriorityQueue();
    private final ActiveLineList m_slice = new ActiveLineList();
    private final DirectPosition m_now = new DirectPosition(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    private double m_eventsFinished;
    private double m_expectedRefiringEvents;
    private double m_eventsProcessed;
    private boolean m_refactorInputRings = true;
    private final List<ActiveLineList> m_ghostInventory = new ArrayList<ActiveLineList>();
    private IProgressMonitor m_monitor;
    private int m_callbackFrequency;

    public PlaneSweep(double tolerance) {
        this.m_tolerance = tolerance;
    }

    public ActiveLineList slice() {
        return this.m_slice;
    }

    public double tol() {
        return this.m_tolerance;
    }

    public DirectPosition now() {
        return this.m_now;
    }

    public PriorityQueue<SweepEvent> events() {
        return this.m_events;
    }

    public void registerProgressMonitor(IProgressMonitor monitor) {
        this.registerProgressMonitor(monitor, 1000);
    }

    public void registerProgressMonitor(IProgressMonitor monitor, int callbackFrequency) {
        this.m_monitor = monitor;
        this.m_callbackFrequency = callbackFrequency;
    }

    public void addGeometry(IGeometry geometry, CutterType isCutter, InputType model) {
        this.addGeometry(GeometryUtilities.convertToFeatureGeometry(geometry), isCutter, model);
    }

    public void addGeometry(IFeatureGeometry geometry, CutterType isCutter, InputType model) {
        switch (geometry.getType()) {
            case POINT: {
                this.addLineString(((IPoint)geometry).getDirectPosition(), isCutter);
                break;
            }
            case MULTI_POINT: {
                DirectPosition tmp = new DirectPosition();
                IDirectPositionIterator i = ((IMultiPoint)geometry).getDirectPositionIterator();
                while (i.hasNext()) {
                    this.addLineString(i.nextDirectPosition(tmp), isCutter);
                }
                break;
            }
            case MULTI_CURVE: {
                for (ICurve curve : (IMultiCurve)geometry) {
                    this.addGeometry(curve, isCutter);
                }
                break;
            }
            case MULTI_POLYGON: {
                for (IPolygon polygon : (IMultiPolygon)geometry) {
                    this.addGeometry(polygon, isCutter, model);
                }
                break;
            }
            case MULTI_FEATURE_GEOMETRY: {
                for (IFeatureGeometry geom : (IMultiFeatureGeometry)geometry) {
                    this.addGeometry(geom, isCutter, model);
                }
                break;
            }
            case RECTANGLE: {
                this.addGeometry(((IRectangle)geometry).asMultiPolygon(), isCutter, model);
                break;
            }
            case ROUNDED_RECTANGLE: {
                this.addGeometry(((ILegacyRoundedRectangle)geometry).asMultiPolygon(), isCutter, model);
                break;
            }
            case ELLIPSE: {
                this.addGeometry(((ILegacyEllipse)geometry).asMultiPolygon(), isCutter, model);
                break;
            }
            case LEGACY_ARC: {
                this.addGeometry(((ILegacyArc)geometry).asMultiCurve(), isCutter, model);
                break;
            }
            case LEGACY_TEXT: {
                this.addGeometry(((ILegacyText)geometry).getRectangle(), isCutter, model);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported geometry type: " + (Object)((Object)geometry.getType()));
            }
        }
    }

    public void addGeometry(ICurve curve, CutterType isCutter) {
        this.addLineString(curve.asLineString().getControlPoints(), Type.Linear, isCutter, InputType.RingXOR);
    }

    public void addGeometry(IPolygon geometry, CutterType isCutter, InputType model) {
        this.addGeometry(geometry.getExteriorRing(), false, isCutter, model);
        Iterator<IRing> ringIterator = geometry.getInteriorRingIterator();
        while (ringIterator.hasNext()) {
            this.addGeometry(ringIterator.next(), true, isCutter, model);
        }
    }

    private void addGeometry(IRing ring, boolean hole, CutterType isCutter, InputType model) {
        IDirectPositionList ringPts = ring.asLineString().getControlPoints();
        if (this.m_refactorInputRings) {
            if (hole) {
                ringPts = this.refactorRing(ringPts, null, null);
            } else {
                DirectPositionArray outPts = new DirectPositionArray();
                ArrayList<IDirectPositionList> outStrands = new ArrayList<IDirectPositionList>();
                ringPts = this.refactorRing(ringPts, outPts, outStrands);
                IDirectPositionIterator i = outPts.getDirectPositionIterator();
                DirectPosition tmp = new DirectPosition();
                while (i.hasNext()) {
                    this.addLineString(i.nextDirectPosition(tmp), isCutter);
                }
                for (IDirectPositionList strand : outStrands) {
                    this.addLineString(strand, Type.Linear, isCutter, model);
                }
            }
        }
        if (ringPts.size() > 0) {
            if (hole) {
                this.addLineString(ringPts, Type.HoleTop, isCutter, model);
            } else {
                this.addLineString(ringPts, Type.ExteriorTop, isCutter, model);
            }
        }
    }

    private void addLineString(DirectPosition coord, CutterType isCutter) {
        this.addLineString(new DirectPositionArray(coord), Type.Point, isCutter, InputType.RingXOR);
    }

    private void addLineString(IDirectPositionList inputList, Type lineType, CutterType isCutter, InputType model) {
        if (inputList.size() == 1) {
            lineType = Type.Point;
        }
        ActiveLineList sourceID = null;
        Type lrType = lineType;
        Type rlType = lineType;
        if (model == InputType.RingXOR) {
            if (lineType.isRegion()) {
                sourceID = new ActiveLineList();
                this.m_ghostInventory.add(sourceID);
            }
        } else {
            boolean orient = false;
            if (lineType.isRegion()) {
                if (lineType.isHole()) {
                    lrType = Type.HoleTop;
                    rlType = Type.HoleBottom;
                    orient = true;
                } else {
                    lrType = Type.ExteriorTop;
                    rlType = Type.ExteriorBottom;
                    orient = true;
                }
            }
            if (orient) {
                S2Utilities.assertClosed(inputList);
                if (GeometryUtilities.orientation(inputList) == GeometryUtilities.Orientation.COUNTER_CLOCKWISE) {
                    Type temp = lrType;
                    lrType = rlType;
                    rlType = temp;
                }
            }
        }
        int eventOrderBias = 0;
        eventOrderBias = isCutter != CutterType.NONE ? (lineType.isHole() ? 1 : (lineType.isRegion() ? -1 : -1)) : (lineType.isHole() ? -1 : (lineType.isRegion() ? 1 : 1));
        boolean zeroLength = true;
        DirectPosition tmp1 = new DirectPosition();
        DirectPosition tmp2 = new DirectPosition();
        for (int k = 1; k < inputList.size() && zeroLength; ++k) {
            if (inputList.getDirectPosition(0, tmp1).equalsXY(inputList.getDirectPosition(k, tmp2))) continue;
            zeroLength = false;
        }
        if (zeroLength) {
            DirectPositionArray list = new DirectPositionArray(2);
            DirectPosition pt = inputList.getDirectPosition(0, new DirectPosition());
            list.add(pt);
            list.add(pt);
            SweepEventControlPoint lineEvent = this.newMonotoneSection(list, 0, 1, 1, lineType, isCutter, sourceID, true);
            SweepEventStart startEvent = new SweepEventStart();
            startEvent.setMultiStart(list.getDirectPosition(0, new DirectPosition()), eventOrderBias);
            startEvent.add(lineEvent);
            this.m_events.add(startEvent);
            SweepEventEnd endEvent = new SweepEventEnd();
            endEvent.setMultiEnd(list.getDirectPosition(0, new DirectPosition()), -eventOrderBias);
            endEvent.add(lineEvent.getActiveLine());
            this.m_events.add(endEvent);
        } else {
            int start;
            int processingEnd;
            int processingStart;
            SweepEvent multiEvent = null;
            SweepEvent firstMultiEvent = null;
            boolean firstMultiEventStart = true;
            if (!S2Utilities.isClosed(inputList)) {
                processingStart = 0;
                processingEnd = inputList.size() - 1;
            } else {
                int leftMost = 0;
                for (int i = 1; i < inputList.size(); ++i) {
                    if (PointComparator.INSTANCE.compare(inputList.getDirectPosition(i, tmp1), inputList.getDirectPosition(leftMost, tmp2)) >= 0) continue;
                    leftMost = i;
                }
                processingStart = processingEnd = leftMost;
            }
            int end = start = processingStart;
            int dir = 0;
            do {
                SweepEventControlPoint lineEvent;
                Assert.assertCondition(start == end);
                int count = 0;
                do {
                    if (dir == 0) {
                        dir = PointComparator.INSTANCE.compare(inputList.getDirectPosition(this.next(inputList, end), tmp1), inputList.getDirectPosition(end, tmp2));
                    }
                    end = this.next(inputList, end);
                    ++count;
                } while (end != processingEnd && dir * PointComparator.INSTANCE.compare(inputList.getDirectPosition(this.next(inputList, end), tmp1), inputList.getDirectPosition(end, tmp2)) >= 0);
                if (count > 0) {
                    --count;
                }
                if (dir > 0) {
                    SweepEventStart startEvent;
                    lineEvent = this.newMonotoneSection(inputList, start, end, dir, lrType, isCutter, sourceID, true);
                    if (multiEvent == null) {
                        startEvent = new SweepEventStart();
                        firstMultiEvent = startEvent;
                        firstMultiEventStart = true;
                    } else {
                        startEvent = (SweepEventStart)multiEvent;
                    }
                    startEvent.setMultiStart(inputList.getDirectPosition(start, new DirectPosition()), eventOrderBias);
                    startEvent.add(lineEvent);
                    this.m_events.add(startEvent);
                    SweepEventEnd endEvent = new SweepEventEnd();
                    endEvent.setMultiEnd(inputList.getDirectPosition(end, new DirectPosition()), -eventOrderBias);
                    endEvent.add(lineEvent.getActiveLine());
                    multiEvent = endEvent;
                } else {
                    SweepEventEnd endEvent;
                    lineEvent = this.newMonotoneSection(inputList, end, start, dir, rlType, isCutter, sourceID, false);
                    if (multiEvent == null) {
                        endEvent = new SweepEventEnd();
                        firstMultiEvent = endEvent;
                        firstMultiEventStart = false;
                    } else {
                        endEvent = (SweepEventEnd)multiEvent;
                    }
                    endEvent.setMultiEnd(inputList.getDirectPosition(start, new DirectPosition()), -eventOrderBias);
                    endEvent.add(lineEvent.getActiveLine());
                    this.m_events.add(endEvent);
                    SweepEventStart startEvent = new SweepEventStart();
                    startEvent.setMultiStart(inputList.getDirectPosition(end, new DirectPosition()), eventOrderBias);
                    startEvent.add(lineEvent);
                    multiEvent = startEvent;
                }
                this.m_expectedRefiringEvents += (double)count;
                start = end;
                dir = 0;
            } while (start != processingEnd);
            if (firstMultiEvent.getTime().equalsXY(multiEvent.getTime())) {
                if (firstMultiEventStart) {
                    ((SweepEventStart)firstMultiEvent).add(((SweepEventStart)multiEvent).remove());
                } else {
                    ((SweepEventEnd)firstMultiEvent).add(((SweepEventEnd)multiEvent).getLine0());
                }
            } else {
                this.m_events.add(multiEvent);
            }
        }
    }

    IDirectPositionList refactorRing(IDirectPositionList dpl, IDirectPositionList outPts, List<IDirectPositionList> outStrands) {
        int prevIdx;
        int i;
        int origSize = dpl.size();
        if (origSize == 1) {
            if (outPts != null) {
                outPts.addAll(dpl);
            }
            return new DirectPositionArray();
        }
        LoopList loop = new LoopList(dpl);
        DirectPosition tmp1 = new DirectPosition();
        DirectPosition tmp2 = new DirectPosition();
        for (i = 1; i < origSize - 1; ++i) {
            prevIdx = loop.prev(i);
            if (!loop.getDirectPosition(prevIdx, tmp1).equalsXY(loop.getDirectPosition(i, tmp2))) continue;
            loop.remove(i);
        }
        for (i = 0; i < origSize - 1; ++i) {
            if (loop.removed(i)) continue;
            int len = 0;
            prevIdx = i;
            int nextIdx = i;
            do {
                nextIdx = loop.next(nextIdx);
            } while (loop.getDirectPosition(prevIdx = loop.prev(prevIdx), tmp1).equalsXY(loop.getDirectPosition(nextIdx, tmp2)) && ++len <= loop.size() / 2);
            if (--len <= 0) continue;
            DirectPositionArray spike = new DirectPositionArray(len + 1);
            prevIdx = i;
            nextIdx = i;
            spike.add(loop.getDirectPosition(nextIdx, tmp1));
            for (int j = 0; j < len; ++j) {
                int oldNextIdx = nextIdx;
                int oldPrevIdx = prevIdx;
                nextIdx = loop.next(nextIdx);
                prevIdx = loop.prev(prevIdx);
                loop.remove(oldNextIdx);
                loop.remove(oldPrevIdx);
                spike.add(loop.getDirectPosition(nextIdx, tmp1));
            }
            if (outStrands == null) continue;
            outStrands.add(spike);
        }
        if (loop.size() == 0) {
            return new DirectPositionArray();
        }
        IDirectPositionList returnList = new DirectPositionArray();
        if (loop.numRemoved() == 0) {
            returnList = dpl;
        } else {
            for (int i2 = 0; i2 < origSize - 1; ++i2) {
                if (loop.removed(i2)) continue;
                returnList.add(loop.getDirectPosition(i2, tmp1));
            }
            returnList.add(returnList.getDirectPosition(0, tmp1));
        }
        Assert.assertCondition(returnList.size() >= 2);
        if (returnList.size() == 2) {
            if (outPts != null) {
                outPts.add(returnList.getDirectPosition(0, tmp1));
            }
            returnList.clear();
        } else if (dpl.size() == 3) {
            if (outStrands != null) {
                DirectPositionArray spike = new DirectPositionArray();
                spike.add(dpl.getDirectPosition(0, tmp1));
                spike.add(dpl.getDirectPosition(1, tmp1));
                outStrands.add(spike);
            }
            returnList.clear();
        }
        return returnList;
    }

    IFeatureGeometry sweep() {
        this.runSweep();
        return this.sweepCompleted();
    }

    void runSweep() {
        int monitorCount = this.m_callbackFrequency;
        while (!this.m_events.isEmpty()) {
            SweepEvent event = this.m_events.poll();
            Assert.assertCondition(PointComparator.INSTANCE.compare(event.getTime(), this.m_now) >= 0);
            this.m_now.set(event.getTime());
            if (event.action(this)) {
                Assert.assertCondition(this.m_expectedRefiringEvents > 0.0);
                this.m_expectedRefiringEvents -= 1.0;
            } else {
                this.m_eventsFinished += 1.0;
            }
            this.m_eventsProcessed += 1.0;
            if (--monitorCount != 0) continue;
            monitorCount = this.m_callbackFrequency;
            if (this.m_monitor == null) continue;
            double workDone = this.m_eventsProcessed;
            double workRemaining = (double)this.m_events.size() * 2.0 + this.m_expectedRefiringEvents;
            this.m_monitor.progress(workDone, workDone + workRemaining);
        }
    }

    int next(IDirectPositionList list, int curPos) {
        int result = curPos + 1;
        if (result >= list.size()) {
            result = 0;
        }
        return result;
    }

    abstract SweepEventControlPoint newMonotoneSection(IDirectPositionList var1, int var2, int var3, int var4, Type var5, CutterType var6, ActiveLineList var7, boolean var8);

    abstract IFeatureGeometry sweepCompleted();

    abstract void swapped(SkipListIterator<ActiveLine> var1, ActiveLine var2);

    abstract void swept(ActiveLine var1);

    abstract void sweptPair(ActiveLine var1, ActiveLine var2);

    abstract void started(ActiveLine var1);

    abstract void startedPair(ActiveLine var1, ActiveLine var2);

    abstract void sweepTo(ActiveLine var1, DirectPosition var2);

    static enum Flag {
        FLAG_POLY(1),
        FLAG_LINEAR(2),
        FLAG_POINT(4);

        private final int m_value;

        private Flag(int value) {
            this.m_value = value;
        }

        public int getValue() {
            return this.m_value;
        }
    }

    static enum Type {
        HoleTop,
        ExteriorBottom,
        Linear,
        Point,
        ExteriorTop,
        HoleBottom;

        private static final Flag[] valueFlag;

        public boolean isRegion() {
            return this != Linear && this != Point;
        }

        public boolean isHole() {
            return this == HoleTop || this == HoleBottom;
        }

        Flag getTypeFlag() {
            return valueFlag[this.ordinal()];
        }

        static {
            valueFlag = new Flag[]{Flag.FLAG_POLY, Flag.FLAG_POLY, Flag.FLAG_LINEAR, Flag.FLAG_POINT, Flag.FLAG_POLY, Flag.FLAG_POLY};
        }
    }
}

