/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.geometry.impl.MultiFeatureGeometry;
import com.mapinfo.midev.geometry.impl.MultiPoint;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.impl.Polygon;
import com.mapinfo.midev.geometry.impl.Ring;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class S2Utilities {
    private S2Utilities() {
    }

    public static boolean isClosed(IDirectPositionList dpl) {
        return dpl.getDirectPosition(0, new DirectPosition()).equalsXY(dpl.getDirectPosition(dpl.size() - 1, new DirectPosition()));
    }

    public static void assertClosed(IDirectPositionList dpl) {
        if (!S2Utilities.isClosed(dpl)) {
            throw new IllegalStateException("Ring is not closed");
        }
    }

    public static IDirectPositionList sort(final IDirectPositionList pts, final Comparator<DirectPosition> comparator) {
        Integer[] ptsindex = new Integer[pts.size()];
        for (int i = 0; i < pts.size(); ++i) {
            ptsindex[i] = i;
        }
        Arrays.sort(ptsindex, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return comparator.compare(pts.getDirectPosition(a, new DirectPosition()), pts.getDirectPosition(b, new DirectPosition()));
            }
        });
        DirectPositionArray oldPts = new DirectPositionArray(pts);
        DirectPosition tmp = new DirectPosition();
        for (int i = 0; i < oldPts.size(); ++i) {
            pts.set(i, oldPts.getDirectPosition(ptsindex[i], tmp));
        }
        return pts;
    }

    public static IFeatureGeometry toMinimalFeatureGeometry(SpatialInfo spatialInfo, List<IGeometry> geomList) {
        ArrayList<Curve> result;
        if (geomList.isEmpty()) {
            return new MultiFeatureGeometry(spatialInfo);
        }
        if (geomList.size() == 1) {
            return GeometryUtilities.convertToFeatureGeometry(geomList.get(0));
        }
        DirectPositionArray pts = new DirectPositionArray();
        ArrayList curveList = new ArrayList();
        ArrayList polygonList = new ArrayList();
        for (IGeometry geom : geomList) {
            switch (geom.getType()) {
                case POINT: {
                    pts.add(((IPoint)geom).getDirectPosition());
                    break;
                }
                case MULTI_POINT: {
                    pts.addAll(((IMultiPoint)geom).getPositions());
                    break;
                }
                case MULTI_CURVE: {
                    curveList.add(S2Utilities.toCanonical((IMultiCurve)geom));
                    break;
                }
                case MULTI_POLYGON: {
                    polygonList.add(S2Utilities.toCanonical((IMultiPolygon)geom));
                    break;
                }
                case MULTI_FEATURE_GEOMETRY: {
                    IMultiFeatureGeometry mfg = (IMultiFeatureGeometry)geom;
                    pts.addAll(mfg.getAllPoints().getPositions());
                    curveList.add(S2Utilities.toCanonical(mfg.getAllCurves()));
                    polygonList.add(S2Utilities.toCanonical(mfg.getAllPolygons()));
                    break;
                }
                case CURVE: {
                    curveList.add(S2Utilities.toCanonical((ICurve)geom));
                    break;
                }
                case POLYGON: {
                    polygonList.add(S2Utilities.toCanonical((IPolygon)geom));
                    break;
                }
                case RECTANGLE: 
                case ROUNDED_RECTANGLE: 
                case ELLIPSE: 
                case LEGACY_TEXT: 
                case LEGACY_ARC: 
                case RING: 
                case LINE_STRING: {
                    throw new UnsupportedOperationException("Unsupported type: " + (Object)((Object)geom.getType()));
                }
            }
        }
        if (curveList.isEmpty() && polygonList.isEmpty()) {
            if (pts.size() == 1) {
                return new Point(spatialInfo, pts.getDirectPosition(0, new DirectPosition()));
            }
            return new MultiPoint(spatialInfo, pts);
        }
        if (pts.isEmpty() && polygonList.isEmpty()) {
            result = new ArrayList<Curve>();
            for (MultiCurve mc : curveList) {
                for (ICurve c : mc) {
                    result.add((Curve)c);
                }
            }
            return new MultiCurve(spatialInfo, result);
        }
        if (pts.isEmpty() && curveList.isEmpty()) {
            result = new ArrayList();
            for (MultiPolygon mp : polygonList) {
                for (IPolygon p : mp) {
                    result.add((Curve)((Object)((Polygon)p)));
                }
            }
            return new MultiPolygon(spatialInfo, result);
        }
        return new MultiFeatureGeometry(spatialInfo, Collections.emptyList(), pts.isEmpty() ? Collections.emptyList() : Collections.singletonList(new MultiPoint(spatialInfo, pts)), curveList.isEmpty() ? Collections.emptyList() : curveList, polygonList.isEmpty() ? Collections.emptyList() : polygonList);
    }

    static IDirectPositionList getAllPoints(IGeometry geom) {
        if (geom instanceof IPoint) {
            return new DirectPositionArray(((IPoint)geom).getDirectPosition());
        }
        if (geom instanceof IMultiPoint) {
            return ((IMultiPoint)geom).getPositions();
        }
        if (geom instanceof IMultiFeatureGeometry) {
            return ((IMultiFeatureGeometry)geom).getAllPoints().getPositions();
        }
        return new DirectPositionArray();
    }

    static IMultiCurve getAllCurves(IGeometry geom) {
        if (geom instanceof ICurveSegment) {
            return S2Utilities.toCanonical((ICurveSegment)geom);
        }
        if (geom instanceof ICurve) {
            return S2Utilities.toCanonical((ICurve)geom);
        }
        if (geom instanceof IMultiCurve) {
            return (IMultiCurve)geom;
        }
        if (geom instanceof IMultiFeatureGeometry) {
            return ((IMultiFeatureGeometry)geom).getAllCurves();
        }
        if (geom instanceof ILegacyArc) {
            return ((ILegacyArc)geom).asMultiCurve();
        }
        return new MultiCurve(geom.getSpatialInfo());
    }

    static IMultiPolygon getAllPolygons(IGeometry geom) {
        if (geom instanceof IRing) {
            return S2Utilities.toCanonical((IRing)geom);
        }
        if (geom instanceof IPolygon) {
            return S2Utilities.toCanonical((IPolygon)geom);
        }
        if (geom instanceof IMultiPolygon) {
            return (IMultiPolygon)geom;
        }
        if (geom instanceof IMultiFeatureGeometry) {
            return ((IMultiFeatureGeometry)geom).getAllPolygons();
        }
        if (geom instanceof IRectangle) {
            return ((IRectangle)geom).asMultiPolygon();
        }
        if (geom instanceof ILegacyEllipse) {
            return ((ILegacyEllipse)geom).asMultiPolygon();
        }
        if (geom instanceof ILegacyRoundedRectangle) {
            return ((ILegacyRoundedRectangle)geom).asMultiPolygon();
        }
        return new MultiPolygon(geom.getSpatialInfo());
    }

    private static MultiCurve toCanonical(ICurveSegment curveSegment) {
        if (curveSegment instanceof CurveSegment) {
            return new MultiCurve(curveSegment.getSpatialInfo(), (CurveSegment)curveSegment);
        }
        return new GeometryFactory(curveSegment.getSpatialInfo()).newMultiCurve(curveSegment);
    }

    private static MultiCurve toCanonical(ICurve curve) {
        if (curve instanceof Curve) {
            return new MultiCurve(curve.getSpatialInfo(), (Curve)curve);
        }
        return new GeometryFactory(curve.getSpatialInfo()).newMultiCurve(curve);
    }

    private static MultiPolygon toCanonical(IRing ring) {
        if (ring instanceof Ring) {
            return new MultiPolygon(ring.getSpatialInfo(), (Ring)ring);
        }
        return new GeometryFactory(ring.getSpatialInfo()).newMultiPolygon(ring);
    }

    private static MultiPolygon toCanonical(IPolygon polygon) {
        if (polygon instanceof Polygon) {
            return new MultiPolygon(polygon.getSpatialInfo(), (Polygon)polygon);
        }
        return new GeometryFactory(polygon.getSpatialInfo()).newMultiPolygon(polygon);
    }

    private static MultiCurve toCanonical(IMultiCurve multiCurve) {
        if (multiCurve instanceof MultiCurve) {
            return (MultiCurve)multiCurve;
        }
        return new GeometryFactory(multiCurve.getSpatialInfo()).newMultiCurve(multiCurve);
    }

    private static MultiPolygon toCanonical(IMultiPolygon multiPolygon) {
        if (multiPolygon instanceof MultiPolygon) {
            return (MultiPolygon)multiPolygon;
        }
        return new GeometryFactory(multiPolygon.getSpatialInfo()).newMultiPolygon(multiPolygon);
    }
}

