/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.operations.s2.SkipListIterator;
import com.mapinfo.midev.geometry.operations.s2.SkipNode;
import java.util.Comparator;
import java.util.Random;

class SkipList<T> {
    private int m_size = 0;
    private int m_maxHeight = 0;
    private final Random m_prng = new Random(1L);
    private final SkipNode<T> m_head = new SkipNode<Object>(this.m_prng, null);
    private final Comparator<T> m_compare;

    public SkipList(Comparator<T> compare) {
        this.m_compare = compare;
    }

    int size() {
        return this.m_size;
    }

    SkipListIterator<T> begin() {
        SkipListIterator<T> result = new SkipListIterator<T>(this.m_head);
        result.next();
        return result;
    }

    SkipListIterator<T> end() {
        return new SkipListIterator((SkipNode)null);
    }

    SkipListIterator<T> rend() {
        return new SkipListIterator<T>(this.m_head);
    }

    SkipListIterator<T> next(SkipListIterator<T> itr) {
        SkipListIterator<T> result = new SkipListIterator<T>(itr);
        result.next();
        return result;
    }

    SkipListIterator<T> prev(SkipListIterator<T> itr) {
        SkipListIterator<T> result = new SkipListIterator<T>(itr);
        result.prev();
        return result;
    }

    SkipListIterator<T> insert(T o) {
        SkipNode<T> newNode = new SkipNode<T>(this.m_prng, o);
        this.addNode(newNode);
        return new SkipListIterator<T>(newNode);
    }

    void clear() {
        this.m_head.clear();
        this.m_maxHeight = 0;
        this.m_size = 0;
    }

    SkipListIterator<T> find(T obj) {
        SkipNode<T> node = this.findInsertPosition(obj);
        if (!node.equals(this.m_head) && obj.equals(node.getDatum())) {
            return new SkipListIterator<T>(node);
        }
        SkipNode<T> ahead = node.getElement(0);
        SkipNode<T> back = node.getBack();
        while (ahead != null || back != null) {
            if (ahead != null) {
                if (obj.equals(ahead.getDatum())) {
                    return new SkipListIterator<T>(ahead);
                }
                ahead = ahead.getElement(0);
            }
            if (back == null) continue;
            if (!back.equals(this.m_head) && obj.equals(back.getDatum())) {
                return new SkipListIterator<T>(back);
            }
            back = back.getBack();
        }
        return this.end();
    }

    SkipListIterator<T> erase(SkipListIterator<T> itr) {
        SkipListIterator<T> itrNext = this.end();
        if (!itr.equals(this.end())) {
            itrNext = new SkipListIterator<T>(this.removeNode(itr.getElement()));
        }
        return itrNext;
    }

    private void addNode(SkipNode<T> newNode) {
        T newObj = newNode.getDatum();
        SkipNode<T> node = this.m_head;
        if (newNode.getLevels() > this.m_maxHeight) {
            if (newNode.getLevels() > this.m_head.getLevels()) {
                SkipNode[] newList = new SkipNode[newNode.getLevels() + 10];
                for (int i = 0; i < this.m_maxHeight; ++i) {
                    newList[i] = this.m_head.getElement(i);
                }
                this.m_head.setForward(newList);
            }
            this.m_maxHeight = newNode.getLevels();
        }
        for (int i = this.m_maxHeight - 1; i >= 0; --i) {
            while (node.getElement(i) != null && this.m_compare.compare(node.getElement(i).getDatum(), newObj) < 0) {
                node = node.getElement(i);
            }
            if (newNode.getLevels() <= i) continue;
            newNode.setElement(i, node.getElement(i));
            node.setElement(i, newNode);
        }
        newNode.setBack(node);
        if (newNode.getElement(0) != null) {
            newNode.getElement(0).setBack(newNode);
        }
        ++this.m_size;
    }

    private SkipNode<T> removeNode(SkipNode<T> doomed) {
        SkipNode node;
        SkipNode<T> retNode = doomed.getElement(0);
        SkipNode[] next = new SkipNode[this.m_maxHeight];
        int level = 0;
        for (node = doomed; node != null; node = node.getElement(level - 1)) {
            while (level < node.getLevels()) {
                next[level] = node;
                ++level;
            }
        }
        node = this.m_head;
        for (int i = this.m_maxHeight - 1; i >= 0; --i) {
            while (node.getElement(i) != null && !node.getElement(i).equals(next[i])) {
                node = node.getElement(i);
            }
            if (doomed.getLevels() <= i) continue;
            node.setElement(i, doomed.getElement(i));
        }
        if (doomed.getElement(0) != null) {
            doomed.getElement(0).setBack(doomed.getBack());
        }
        doomed.setElement(0, null);
        --this.m_size;
        return retNode;
    }

    private SkipNode<T> findInsertPosition(T obj) {
        SkipNode<T> node = this.m_head;
        for (int i = this.m_maxHeight - 1; i >= 0; --i) {
            while (node.getElement(i) != null && this.m_compare.compare(node.getElement(i).getDatum(), obj) < 0) {
                node = node.getElement(i);
            }
        }
        return node;
    }
}

