/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.operations.s2.SkipNode;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;

final class SkipListIterator<T> {
    private SkipNode<T> m_Element;

    public SkipListIterator(SkipNode<T> element) {
        this.m_Element = element;
    }

    public SkipListIterator(SkipListIterator<T> rhs) {
        this.m_Element = rhs.m_Element;
    }

    public SkipNode<T> getElement() {
        return this.m_Element;
    }

    public T get() {
        return this.m_Element.getDatum();
    }

    public void set(T element) {
        this.m_Element.setDatum(element);
    }

    public void next() {
        if (this.m_Element != null) {
            this.m_Element = this.m_Element.getElement(0);
        }
    }

    public void prev() {
        if (this.m_Element != null) {
            this.m_Element = this.m_Element.getBack();
        }
    }

    public SkipListIterator<T> getCopy() {
        return new SkipListIterator<T>(this.m_Element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkipListIterator that = (SkipListIterator)o;
        return !(this.m_Element != null ? !this.m_Element.equals(that.m_Element) : that.m_Element != null);
    }

    public int hashCode() {
        return this.m_Element != null ? this.m_Element.hashCode() : 0;
    }

    public int subtract(SkipListIterator<T> rhs) {
        int count = 0;
        int diff = 0;
        if (!this.m_Element.equals(rhs.m_Element)) {
            SkipNode<T> ahead = rhs.m_Element.getElement(0);
            SkipNode<T> back = rhs.m_Element.getBack();
            diff = Integer.MAX_VALUE;
            while (Integer.MAX_VALUE == diff && (ahead != null || back != null)) {
                ++count;
                if (ahead != null) {
                    if (ahead == this.m_Element) {
                        diff = count;
                    }
                    ahead = ahead.getElement(0);
                }
                if (back == null) continue;
                if (back == this.m_Element) {
                    diff = -count;
                }
                back = back.getBack();
            }
        }
        return diff;
    }

    public boolean lessThan(SkipListIterator<T> rhs) {
        SkipNode<T> thisNode = this.getElement();
        SkipNode<T> rhsNode = rhs.getElement();
        int result = 0;
        int curHeight = 1;
        while (thisNode != rhsNode) {
            int stepsThis = 0;
            while (thisNode != null && thisNode.getLevels() <= curHeight) {
                thisNode = thisNode.getElement(thisNode.getLevels() - 1);
                ++stepsThis;
            }
            int stepsRhs = 0;
            while (rhsNode != null && rhsNode.getLevels() <= curHeight) {
                rhsNode = rhsNode.getElement(rhsNode.getLevels() - 1);
                ++stepsRhs;
            }
            if (stepsThis > stepsRhs) {
                result = -1;
            } else if (stepsThis < stepsRhs) {
                result = 1;
            }
            ++curHeight;
        }
        Assert.assertCondition(result != 0);
        return result < 0;
    }
}

