/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import java.util.Random;

final class SkipNode<T> {
    private T m_datum;
    private SkipNode<T>[] m_forward;
    private SkipNode<T> m_back = null;

    public SkipNode(Random prng, T datum) {
        this.m_datum = datum;
        this.m_forward = new SkipNode[SkipNode.getCount(prng)];
    }

    public T getDatum() {
        return this.m_datum;
    }

    public void setDatum(T datum) {
        this.m_datum = datum;
    }

    public void clear() {
        this.m_datum = null;
        if (this.m_forward[0] != null) {
            this.m_forward[0].clear();
            this.m_forward[0] = null;
        }
    }

    public int getLevels() {
        return this.m_forward.length;
    }

    public SkipNode<T> getElement(int level) {
        return this.m_forward[level];
    }

    public void setElement(int level, SkipNode<T> element) {
        this.m_forward[level] = element;
    }

    public void setForward(SkipNode<T>[] forward) {
        this.m_forward = forward;
    }

    public void setBack(SkipNode<T> back) {
        this.m_back = back;
    }

    public SkipNode<T> getBack() {
        return this.m_back;
    }

    private static int getCount(Random prng) {
        int count = 1;
        while (prng.nextBoolean()) {
            ++count;
        }
        return count;
    }
}

