/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.operations.cartesian.Cartesian;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

final class Strand {
    private Strand m_twin;
    private List<DirectPosition> m_pts = new ArrayList<DirectPosition>();
    private boolean m_reversed;
    private boolean m_finished;
    private int m_typeBits;
    private List<IDirectPositionList> m_containedHoles;

    Strand() {
    }

    public Strand getTwin() {
        return this.m_twin;
    }

    public int size() {
        return this.m_pts.size();
    }

    public boolean Finished() {
        return this.m_finished;
    }

    public void setFinished(boolean finished) {
        this.m_finished = finished;
    }

    public int getTypeFlag() {
        return this.m_typeBits;
    }

    public void setTypeFlag(int value) {
        this.m_typeBits |= value;
        this.m_twin.m_typeBits |= value;
    }

    public DirectPosition get(int index) {
        return this.m_reversed ? this.m_pts.get(this.m_pts.size() - index - 1).getCopy() : this.m_pts.get(index).getCopy();
    }

    public List<IDirectPositionList> containedHoles() {
        return this.m_containedHoles;
    }

    public void containedHoles(List<IDirectPositionList> containedHoles) {
        this.m_containedHoles = containedHoles;
    }

    void pushXYdistinct(DirectPosition c) {
        if (this.m_reversed) {
            if (this.m_pts.size() == 0 || !c.equalsXY(this.m_pts.get(this.m_pts.size() - 1))) {
                this.m_pts.add(c.getCopy());
            }
        } else if (this.m_pts.size() == 0 || !c.equalsXY(this.m_pts.get(0))) {
            this.m_pts.add(0, c.getCopy());
        }
    }

    void push(DirectPosition c) {
        if (this.m_reversed) {
            this.m_pts.add(c.getCopy());
        } else {
            this.m_pts.add(0, c.getCopy());
        }
    }

    static boolean connect(Strand p1, Strand p2) {
        boolean bWouldFormLoop = true;
        if (null != p1 && null != p2 && p1 != p2 && p1 != p2.m_twin) {
            Assert.assertCondition(p1.m_typeBits == p1.m_twin.m_typeBits);
            Assert.assertCondition(p2.m_typeBits == p2.m_twin.m_typeBits);
            int typeBits = p1.m_typeBits | p2.m_typeBits;
            p1.m_twin.mergeHolesFrom(p1);
            p1.m_twin.mergeHolesFrom(p2);
            Strand source = p1;
            Strand dest = p2;
            if (p1.size() > p2.size()) {
                source = p2;
                dest = p1;
            }
            int n = source.size();
            for (int i = 0; i < n; ++i) {
                dest.push(source.get(i));
            }
            dest.m_twin.m_twin = source.m_twin;
            source.m_twin.m_pts = dest.m_pts;
            source.m_twin.m_twin = dest.m_twin;
            source.m_twin.m_reversed = dest.m_reversed;
            dest.m_twin.m_typeBits = typeBits;
            source.m_twin.m_typeBits = typeBits;
            bWouldFormLoop = false;
        }
        return bWouldFormLoop;
    }

    void pop_back() {
        if (this.m_reversed) {
            this.m_pts.remove(this.m_pts.size() - 1);
        } else {
            this.m_pts.remove(0);
        }
    }

    void mergeHolesFrom(Strand from) {
        if (from.m_containedHoles != null && from.m_containedHoles.size() > 0) {
            if (this.m_containedHoles == null) {
                this.m_containedHoles = from.m_containedHoles;
            } else if (from.m_containedHoles.size() < this.m_containedHoles.size()) {
                for (IDirectPositionList list : from.m_containedHoles) {
                    this.m_containedHoles.add(list);
                }
            } else {
                for (IDirectPositionList list : this.m_containedHoles) {
                    from.m_containedHoles.add(list);
                }
                this.m_containedHoles = from.m_containedHoles;
            }
        }
        from.m_containedHoles = null;
    }

    IDirectPositionList asCoordList(double tol) {
        Assert.assertCondition(this.size() != 0);
        DirectPositionArray posList = new DirectPositionArray(this.size());
        if (this.size() == 1) {
            posList.add(this.get(0));
        } else {
            int lastUsable;
            DirectPosition dpPrev = this.get(this.size() - 1);
            for (lastUsable = this.size() - 2; lastUsable > 0 && Cartesian.distanceXY(dpPrev, this.get(lastUsable)) <= tol; --lastUsable) {
            }
            DirectPosition dp = this.get(0);
            posList.add(dp);
            dpPrev = dp;
            for (int i = 1; i <= lastUsable; ++i) {
                dp = this.get(i);
                if (tol >= 0.0 && Cartesian.distanceXY(dpPrev, dp) <= tol && i < this.size() - 1) continue;
                posList.add(dp);
                dpPrev = dp;
            }
            posList.add(this.get(this.size() - 1));
        }
        return posList;
    }

    static Pair<Strand, Strand> newPair() {
        ImmutablePair result = new ImmutablePair((Object)new Strand(), (Object)new Strand());
        ((Strand)result.getLeft()).m_twin = (Strand)result.getRight();
        ((Strand)result.getRight()).m_twin = (Strand)result.getLeft();
        ((Strand)result.getRight()).m_pts = ((Strand)result.getLeft()).m_pts = new ArrayList<DirectPosition>();
        ((Strand)result.getLeft()).m_reversed = true;
        ((Strand)result.getRight()).m_reversed = false;
        return result;
    }
}

