/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.operations.s2;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.operations.s2.ActiveLine;
import com.mapinfo.midev.geometry.operations.s2.ActiveLineList;
import com.mapinfo.midev.geometry.operations.s2.IActiveLineInfo;
import com.mapinfo.midev.geometry.operations.s2.PlaneSweep;
import com.mapinfo.midev.geometry.operations.s2.PointComparator;
import com.mapinfo.midev.geometry.operations.s2.SweepEvent;
import com.mapinfo.midev.geometry.operations.s2.util.Assert;

final class SweepEventControlPoint
extends SweepEvent {
    ActiveLine m_activeLine = null;
    final IDirectPositionList m_posList;
    int m_start;
    final int m_end;
    final int m_dir;

    SweepEventControlPoint(IDirectPositionList list, int start, int end, int dir, IActiveLineInfo info, ActiveLineList sourceID) {
        super(SweepEvent.Type.LINE_PROGRESS_EVENT.getValue());
        this.m_posList = list;
        this.m_start = start;
        this.m_end = end;
        this.m_dir = dir;
        this.m_activeLine = new ActiveLine(info, sourceID, this.m_posList.getDirectPosition(this.m_start, new DirectPosition()), this.m_posList.getDirectPosition(this.next(), new DirectPosition()));
        this.setTime(this.m_posList.getDirectPosition(this.next(), new DirectPosition()));
    }

    public ActiveLine getActiveLine() {
        return this.m_activeLine;
    }

    @Override
    public boolean action(PlaneSweep sweep) {
        boolean keepAlive = false;
        this.m_start = this.next();
        Assert.assertCondition(PointComparator.INSTANCE.compare(this.m_posList.getDirectPosition(this.m_start, new DirectPosition()), this.getTime()) == 0);
        this.m_activeLine.sweepTo(this.m_posList.getDirectPosition(this.m_start, new DirectPosition()));
        if (this.m_start != this.m_end) {
            this.m_activeLine.getPt()[1] = this.m_posList.getDirectPosition(this.next(), new DirectPosition());
            this.m_activeLine.getLongPt()[0] = this.m_activeLine.getPt()[0];
            this.m_activeLine.getLongPt()[1] = this.m_activeLine.getPt()[1];
            this.setTime(this.m_activeLine.getPt()[1]);
            sweep.events().add(this);
            keepAlive = true;
        }
        ActiveLine.verifyOrdering(this.m_activeLine, false);
        return keepAlive;
    }

    private int next() {
        int result = this.m_start;
        if (this.m_start != this.m_end) {
            if (this.m_dir < 0 && ((result += this.m_dir) >= this.m_posList.size() || result < 0)) {
                result = this.m_posList.size() - 1;
            } else if (result == this.m_posList.size()) {
                result = 0;
            }
        }
        return result;
    }
}

