/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.util;

import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.IRectangle;

public final class LegacyGeometryUtilities {
    private LegacyGeometryUtilities() {
    }

    public static IGeometry toNonLegacyGeometry(IGeometry featureGeometry) {
        switch (featureGeometry.getType()) {
            case LEGACY_ARC: {
                return ((ILegacyArc)featureGeometry).asMultiCurve();
            }
            case ELLIPSE: {
                return ((ILegacyEllipse)featureGeometry).asMultiPolygon();
            }
            case ROUNDED_RECTANGLE: {
                return ((ILegacyRoundedRectangle)featureGeometry).asMultiPolygon();
            }
            case RECTANGLE: {
                return ((IRectangle)featureGeometry).asMultiPolygon();
            }
            case LEGACY_TEXT: {
                return ((ILegacyText)featureGeometry).getRectangle().asMultiPolygon();
            }
        }
        return featureGeometry;
    }
}

