/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.util;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.geometry.impl.MultiFeatureGeometry;
import com.mapinfo.midev.geometry.impl.MultiPoint;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.impl.Rectangle;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.impl.XYDirectPositionArray;
import com.mapinfo.midev.geometry.operations.GeometryOperations;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public final class MIFReader {
    private MIFReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IGeometry> read(File mifFile) throws IOException {
        try (LineIterator lineIterator = FileUtils.lineIterator((File)mifFile);){
            List<IGeometry> list = MIFReader.read((Iterator<String>)lineIterator);
            return list;
        }
    }

    public static List<IGeometry> read(Iterator<String> lineIterator) {
        ArrayList<IGeometry> result = new ArrayList<IGeometry>();
        CoordSys coordSys = MIFReader.parseCoordSys(lineIterator);
        SpatialInfo spatialInfo = new SpatialInfo(coordSys);
        MIFReader.moveTo(lineIterator, "Data");
        IGeometry nextGeometry = MIFReader.nextGeometry(spatialInfo, lineIterator);
        while (nextGeometry != null) {
            result.add(nextGeometry);
            nextGeometry = MIFReader.nextGeometry(spatialInfo, lineIterator);
        }
        return result;
    }

    private static CoordSys parseCoordSys(Iterator<String> lineIterator) {
        String line = MIFReader.moveTo(lineIterator, "CoordSys ");
        return CoordSysFactory.getDefaultCoordSysFactory().getCoordSysFromMapBasic(line);
    }

    private static String moveTo(Iterator<String> lineIterator, String startToken) {
        String line = "";
        while (lineIterator.hasNext() && !line.startsWith(startToken)) {
            line = lineIterator.next();
        }
        if (!line.startsWith(startToken)) {
            throw new IllegalStateException("Missing token: " + startToken);
        }
        return line;
    }

    private static IGeometry nextGeometry(SpatialInfo spatialInfo, Iterator<String> lineIterator) {
        while (lineIterator.hasNext()) {
            String line = lineIterator.next().trim().toLowerCase();
            if (line.isEmpty()) continue;
            if (line.startsWith("point")) {
                String[] pointString = line.split(" ");
                return new Point(spatialInfo, new DirectPosition(Double.valueOf(pointString[1]).doubleValue(), Double.valueOf(pointString[2]).doubleValue()));
            }
            if (line.startsWith("multipoint")) {
                int numPoints = Integer.valueOf(line.substring("multipoint".length()).trim());
                IDirectPositionList dpa = MIFReader.parsePoints(lineIterator, numPoints);
                return new MultiPoint(spatialInfo, dpa);
            }
            if (line.startsWith("collection")) continue;
            if (line.startsWith("pline multiple")) {
                int numPline = Integer.valueOf(line.substring("pline multiple".length()).trim());
                ArrayList<Curve> curveList = new ArrayList<Curve>(numPline);
                for (int n = 0; n < numPline; ++n) {
                    int numPoints = Integer.valueOf(lineIterator.next().trim());
                    curveList.add(new Curve(spatialInfo, new LineString(spatialInfo, MIFReader.parsePoints(lineIterator, numPoints))));
                }
                return new MultiCurve(spatialInfo, curveList);
            }
            if (line.startsWith("pline")) {
                int numPoints = Integer.valueOf(line.substring("pline".length()).trim());
                IDirectPositionList dpa = MIFReader.parsePoints(lineIterator, numPoints);
                return new LineString(spatialInfo, dpa);
            }
            if (line.startsWith("line")) {
                String[] lineString = line.split(" ");
                DirectPositionArray dpa = new DirectPositionArray(2);
                dpa.add(Double.valueOf(lineString[1]), Double.valueOf(lineString[2]));
                dpa.add(Double.valueOf(lineString[3]), Double.valueOf(lineString[4]));
                return new LineString(spatialInfo, dpa);
            }
            if (line.startsWith("region")) {
                int numRings = Integer.valueOf(line.substring("region".length()).trim());
                if (numRings < 0) {
                    throw new IllegalArgumentException("Invalid number of rings: " + numRings);
                }
                if (numRings == 0) {
                    return new MultiPolygon(spatialInfo);
                }
                ArrayList<IRing> ringList = new ArrayList<IRing>(numRings);
                for (int n = 0; n < numRings; ++n) {
                    ringList.add(MIFReader.parseRing(spatialInfo, lineIterator));
                }
                return GeometryOperations.newMultiPolygon(ringList);
            }
            if (line.startsWith("rect")) {
                String[] lineString = line.split(" ");
                return new Rectangle(spatialInfo, new DirectPosition(Double.valueOf(lineString[1]).doubleValue(), Double.valueOf(lineString[2]).doubleValue()), new DirectPosition(Double.valueOf(lineString[3]).doubleValue(), Double.valueOf(lineString[4]).doubleValue()));
            }
            if (line.startsWith("none")) {
                return new MultiFeatureGeometry(spatialInfo);
            }
            if (line.trim().startsWith("pen") || line.trim().startsWith("brush") || line.trim().startsWith("center") || line.trim().startsWith("symbol") || line.trim().startsWith("font") || line.trim().startsWith("angle") || line.trim().startsWith("justify") || line.trim().startsWith("spacing") || line.trim().startsWith("label line")) continue;
            throw new UnsupportedOperationException("Geometry not supported: " + line.split(" ")[0]);
        }
        return null;
    }

    private static IDirectPositionList parsePoints(Iterator<String> lineIterator, int numPoints) {
        XYDirectPositionArray dpa = new XYDirectPositionArray(numPoints);
        for (int n = 0; n < numPoints; ++n) {
            String line = lineIterator.next();
            String[] pt = line.split(" ");
            dpa.add(Double.parseDouble(pt[0]), Double.parseDouble(pt[1]));
        }
        return dpa;
    }

    private static Ring parseRing(SpatialInfo spatialInfo, Iterator<String> lineIterator) {
        int numPoints = Integer.valueOf(lineIterator.next().trim());
        IDirectPositionList pts = MIFReader.parsePoints(lineIterator, numPoints);
        return new Ring(spatialInfo, new LineString(spatialInfo, pts));
    }
}

