/*
 * Decompiled with CFR 0.152.
 */
package com.pb.spectrum.autosuggest;

import com.pb.spectrum.gav.data.DictionaryInfo;
import com.pb.spectrum.gav.data.DictionaryManagerException;
import com.pb.spectrum.gav.data.DictionaryPath;
import com.pb.spectrum.gav.data.TypeAheadException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;

public class TypeAheadDictionaryManager {
    public static final String DICTIONARY_COUNT = "DICTIONARY_COUNT";
    public static final String DICTIONARY_PATH_PREFIX = "DICTIONARY_PATH";
    public static final String DICTIONARY_PATH_NAME_PREFIX = "DICTIONARY_PATH_NAME";
    public static final String DICTIONARY_DESC_TXT_FILE = "dictionarydesc.txt";
    public static final String DICTIONARY_DESC_PROPERTIES_FILE = "dictionarydesc.properties";
    public static final String CONFIGURATION_FILENAME_KEY = "configuration.filename";
    public static final String G1_SERVER_MODULES_DIR = "g1.server.modules.dir";
    private static final String DICTIONARY_DESC_PROP_DESCRIPTION = "description";
    private static final String DICTIONARY_DEFAULT_COUTNRY_CODE = "DICTIONARY_COUNTRY_CODE";
    private DictionaryInfo[] dictionaryInfos;

    public TypeAheadDictionaryManager(Properties props) throws DictionaryManagerException, TypeAheadException {
        this.load(props);
    }

    public synchronized DictionaryInfo[] getDictionaryInfos() {
        return this.dictionaryInfos;
    }

    public synchronized DictionaryInfo[] updateDictionaryInfos(DictionaryPath[] dictionaryPaths) throws DictionaryManagerException, TypeAheadException {
        this.dictionaryInfos = new DictionaryInfo[dictionaryPaths.length];
        int index = 1;
        for (DictionaryPath dictionaryPath : dictionaryPaths) {
            String dictionaryType = this.readDictionaryType(dictionaryPath.getPath());
            this.dictionaryInfos[index - 1] = new DictionaryInfo(index, dictionaryPath.getName(), dictionaryType, dictionaryPath.getPath());
            ++index;
        }
        return this.getDictionaryInfos();
    }

    public synchronized DictionaryInfo getDictionaryInfo(String name) {
        assert (name != null);
        DictionaryInfo theDictionaryInfo = null;
        for (DictionaryInfo dictionaryInfo : this.dictionaryInfos) {
            if (!name.equals(dictionaryInfo.getName())) continue;
            theDictionaryInfo = dictionaryInfo;
            break;
        }
        return theDictionaryInfo;
    }

    private void load(Properties properties) throws DictionaryManagerException, TypeAheadException {
        if (properties != null) {
            int dictionaryCount = this.readPropertyAsInt(DICTIONARY_COUNT, properties);
            this.dictionaryInfos = new DictionaryInfo[dictionaryCount];
            for (int i = 1; i <= dictionaryCount; ++i) {
                DictionaryInfo dictionaryInfo;
                String path = this.readPropertyAsString(DICTIONARY_PATH_PREFIX + i, properties);
                String type = this.readDictionaryType(path);
                String name = properties.getProperty(DICTIONARY_PATH_NAME_PREFIX + i);
                if (name == null) {
                    name = type;
                }
                String defaultCoutnryCode = properties.getProperty(DICTIONARY_DEFAULT_COUTNRY_CODE);
                this.dictionaryInfos[i - 1] = dictionaryInfo = new DictionaryInfo(i, name, type, path, defaultCoutnryCode);
            }
        } else {
            throw new DictionaryManagerException("LOAD_FROM_PROPERTYFILE_EXCEPTION_CODE", "Unable to load data sets from properties file.");
        }
    }

    private void store() throws DictionaryManagerException {
        String configurationFilename = this.getConfigurationFilename();
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(configurationFilename)));
            Enumeration<?> enumPropertyNames = properties.propertyNames();
            while (enumPropertyNames.hasMoreElements()) {
                DictionaryInfo[] propertyName = (DictionaryInfo[])enumPropertyNames.nextElement();
                if (!propertyName.startsWith(DICTIONARY_PATH_PREFIX) && !propertyName.startsWith(DICTIONARY_PATH_NAME_PREFIX)) continue;
                properties.remove(propertyName);
            }
            properties.setProperty(DICTIONARY_COUNT, String.valueOf(this.dictionaryInfos.length));
            for (DictionaryInfo dictionaryInfo : this.dictionaryInfos) {
                properties.setProperty(DICTIONARY_PATH_PREFIX + dictionaryInfo.getIndex(), dictionaryInfo.getPath());
                properties.setProperty(DICTIONARY_PATH_NAME_PREFIX + dictionaryInfo.getIndex(), dictionaryInfo.getName());
            }
            FileOutputStream outputStream = new FileOutputStream(configurationFilename);
            properties.store(outputStream, "");
            outputStream.close();
        }
        catch (IOException e) {
            throw new DictionaryManagerException("Unable to persist datasource properties", (Throwable)e);
        }
    }

    private String readPropertyAsString(String name, Properties properties) throws DictionaryManagerException {
        String value = properties.getProperty(name);
        if (value == null) {
            throw new DictionaryManagerException("Missing property: " + name);
        }
        return value;
    }

    private int readPropertyAsInt(String name, Properties properties) throws DictionaryManagerException {
        String valueStr = this.readPropertyAsString(name, properties);
        return Integer.valueOf(valueStr);
    }

    private String readDictionaryType(String dictionaryPath) throws DictionaryManagerException {
        String dictionaryType = null;
        File path = new File(dictionaryPath);
        if (!path.exists()) {
            throw new DictionaryManagerException("Path does not exist: " + dictionaryPath);
        }
        File dictionaryDescTxtFile = new File(path.getAbsolutePath() + "/" + DICTIONARY_DESC_TXT_FILE);
        File dictionaryDescPropFile = new File(path.getAbsolutePath() + "/" + DICTIONARY_DESC_PROPERTIES_FILE);
        if (dictionaryDescTxtFile.exists()) {
            dictionaryType = this.readFromTxtFile(dictionaryDescTxtFile);
        } else if (dictionaryDescPropFile.exists()) {
            dictionaryType = this.readFromPropertiesFile(dictionaryDescPropFile);
        }
        if (dictionaryType == null) {
            dictionaryType = "User dictionary: no description";
        }
        return dictionaryType;
    }

    private String readFromTxtFile(File dictionaryDescFile) throws DictionaryManagerException {
        StringBuilder builder = new StringBuilder();
        FileReader fileReader = null;
        try {
            int count;
            fileReader = new FileReader(dictionaryDescFile);
            char[] buffer = new char[256];
            while ((count = fileReader.read(buffer)) > 0) {
                builder.append(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new DictionaryManagerException("Unable to read dictionary file: " + dictionaryDescFile.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return builder.toString().trim();
    }

    private String readFromPropertiesFile(File dictionaryDescFile) throws DictionaryManagerException {
        String d = null;
        InputStreamReader fileReader = null;
        try {
            Properties p = new Properties();
            fileReader = new FileReader(dictionaryDescFile);
            p.load(fileReader);
            d = p.getProperty(DICTIONARY_DESC_PROP_DESCRIPTION);
        }
        catch (IOException e) {
            throw new DictionaryManagerException("Unable to read dictionary file: " + dictionaryDescFile.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return d;
    }

    private String getConfigurationFilename() {
        String g1ServerModulesDir = System.getProperty(G1_SERVER_MODULES_DIR);
        String configurationFilename = System.getProperty(CONFIGURATION_FILENAME_KEY);
        return g1ServerModulesDir + "/" + configurationFilename;
    }
}

