/*
 * Decompiled with CFR 0.152.
 */
package com.pb.spectrum.autosuggest.api;

import com.mapinfo.mapmarker.autosuggest.api.AutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.IAutoSuggestConstraints;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidate;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedCandidateRange;
import com.mapinfo.mapmarker.autosuggest.api.ISuggestedRangeUnit;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.DictionarySearchOrder;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.pb.addressing.api.PBFnlDatabase;
import com.pb.addressing.util.ValidationUtils;
import com.pb.spectrum.autosuggest.api.iTypeAheadConverter;
import com.pb.spectrum.gav.data.DictionaryInfo;
import com.pb.spectrum.gav.data.TypeAheadException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DefaultTypeAheadConverter
implements iTypeAheadConverter {
    public static final String ADDRESS_LINE_1 = "AddressLine1";
    public static final String FORMATTED_ADDRESS = "FormattedAddress";
    public static final String FIRM_NAME = "FirmName";
    public static final String LOCALITY = "Locality";
    public static final String COUNTY = "County";
    public static final String CITY = "City";
    public static final String STATE_PROVINCE = "StateProvince";
    public static final String INPUT_POSTAL = "PostCode";
    public static final String POSTAL_CODE = "PostalCode";
    public static final String LAST_LINE = "LastLine";
    public static final String INPUT_COUNTRY = "Country";
    public static final String COUNTRY = "Country";
    public static final String RANGES = "Ranges";
    public static final String RANGE_COUNT = "RangeCount";
    public static final String RANGE = "Range";
    public static final String UNITS_INFO = "UnitsInfo";
    public static final String UNITS_COUNT = "UnitCount";
    public static final String UNIT_INFO = "UnitInfo";
    public static final String FORMATTED_RANGE_ADDRESS = "FormattedRangeAddress";
    public static final String FORMATTED_UNIT_ADDRESS = "FormattedUnitAddress";
    public static final String CITY_NAME_MATCH = "City.Match";
    public static final String PREFERRED_CITY = "US.PreferredCity";
    public static final String STREETNAME = "US.StreetName";
    public static final String HOUSENUMBERLOW = "US.RangeNumberLow";
    public static final String HOUSENUMBERHIGH = "US.RangeNumberHigh";
    public static final String preDir = "US.PreDir";
    public static final String posDir = "US.PostDir";
    public static final String suffix = "US.Suffix";
    public static final String carrRte = "US.CarrierRoute";
    public static final String eob = "US.EOB";
    public static final String zip4Low = "US.ZIP4Low";
    public static final String zip4Hi = "US.ZIP4High";
    public static final String alias = "US.Alias";
    public static final String alternate = "US.Alternate";
    public static final String unit = "US.Unit";
    public static final String GEOCODE_TYPE = "GeocodeLevel";
    public static final String STREET_OFFSET = "OffsetFromStreet";
    public static final String CORNER_OFFSET = "OffsetFromCorner";
    public static final String OFFSET_UNITS = "OffsetUnits";
    public static final String MAX_CANDIDATES = "MaxCandidates";
    public static final String DATABASE_PREFERENCE = "DatabasePreference";
    public static final String DATABASE_SEARCH_ORDER = "DatabaseSearchOrder";
    public static final String COORDINATE_SYSTEM = "CoordinateSystem";
    public static final String CLOSE_MATCHES_ONLY = "CloseMatchesOnly";
    public static final String KEEP_MULTIMATCH = "KeepMultimatch";
    public static final String AUTOSUGGEST_STREET_ADDRESS = "GEOCOMPLETEADDRESS";
    public static final String AUTOSUGGEST_POI = "GEOCOMPLETEPOI";
    public static final String AUTOSUGGEST_ALL = "GEOCOMPLETEALL";
    public static final String AUTOSUGGEST_CATEGORY = "GEOCOMPLETECATEGORY";
    public static final String FIND_NEAREST_POI = "FINDNEARESTPOI";
    public static final String ORIGIN_LATITUDE = "OriginLatitude";
    public static final String ORIGIN_LONGITUDE = "OriginLongitude";
    public static final String NAME_OF_CANDIDATE = "Name";
    public static final String FORMATTED_STRING = "FormattedString";
    public static final String TYPE = "Type";
    public static final String DISTANCE = "Distance";
    public static final String SCORE = "Score";
    public static final String CHARACTERS_MATCHED = "CharactersMatched";
    public static final String CANDIDATE_DISTANCE_UNIT = "DistanceUnit";
    public static final Map<String, Integer> geocodeLevels = new HashMap<String, Integer>();
    public static final String YES = "Y";
    public static final String NO = "N";
    private static final String SPACE = " ";
    private static final String COMMA = ",";
    private static final String HYPHEN = "-";
    private static final String COUNTRY_USA = "USA";
    private static char[] DIGITS_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private String countryCode;
    private IDictionarySearchOrder dictionarySearchOrder;
    private Map<String, Integer> dictionaryNameToIndexMap;

    @Override
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Override
    public void configureDictionaries(DictionaryInfo[] dictionaryInfos, IDictionarySearchOrder dictionarySearchOrder) {
        assert (dictionaryInfos != null) : "DictionaryInfos cannot be null";
        this.dictionarySearchOrder = dictionarySearchOrder;
        this.dictionaryNameToIndexMap = new HashMap<String, Integer>();
        for (DictionaryInfo dictionaryInfo : dictionaryInfos) {
            this.dictionaryNameToIndexMap.put(dictionaryInfo.getName(), dictionaryInfo.getIndex());
        }
    }

    protected String getCountryCode() {
        assert (this.countryCode != null) : "CountryCode cannot be null";
        return this.countryCode;
    }

    @Override
    public IAutoSuggestConstraints convertOptions(Map options) throws TypeAheadException {
        return new AutoSuggestConstraints();
    }

    @Override
    public Address convertInput(Map<String, String> input) throws TypeAheadException {
        AddressImpl address = new AddressImpl();
        address.setMainAddress(input.get(ADDRESS_LINE_1));
        address.setAreaName3(input.get(CITY));
        address.setAreaName1(input.get(STATE_PROVINCE));
        address.setPostCode1(input.get(INPUT_POSTAL));
        if (!DefaultTypeAheadConverter.isEmpty(input.get("Country"))) {
            address.setCountry(input.get("Country").toUpperCase());
        } else {
            address.setCountry(this.getCountryCode());
        }
        return address;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    protected IDictionarySearchOrder createDictionarySearchOrder(String searchOrderStr) {
        int i;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (searchOrderStr != null) {
            String[] dictionaryNames = searchOrderStr.split(Pattern.quote(COMMA));
            ArrayList<String> dictionariesNotFound = null;
            for (String dictionaryName : dictionaryNames) {
                if ("".equals(dictionaryName)) continue;
                Integer index = this.dictionaryNameToIndexMap.get(dictionaryName);
                if (index == null) {
                    if (dictionariesNotFound == null) {
                        dictionariesNotFound = new ArrayList<String>();
                    }
                    dictionariesNotFound.add(dictionaryName);
                }
                indices.add(index);
            }
            if (dictionariesNotFound != null) {
                throw new IllegalArgumentException("No configuration found for database" + (dictionariesNotFound.size() == 1 ? "" : "s") + ": " + dictionariesNotFound);
            }
        }
        DictionarySearchOrder dictionarySearchOrder = new DictionarySearchOrder(this.dictionarySearchOrder.getDictionaryCount());
        for (i = 1; i <= dictionarySearchOrder.getDictionaryCount(); ++i) {
            dictionarySearchOrder.addDictionary(i, false, this.dictionarySearchOrder.getDictionaryDescription(i), this.dictionarySearchOrder.getSearchOrderForDictionary(i), this.dictionarySearchOrder.isUserDictionary(i));
        }
        i = 1;
        if (searchOrderStr == null || "".equals(searchOrderStr)) {
            for (int index = 1; index <= dictionarySearchOrder.getDictionaryCount(); ++index) {
                dictionarySearchOrder.setDictionaryAvailableForSearch(index, true);
            }
        } else {
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                dictionarySearchOrder.setSearchOrderForDictionary(index, i);
                dictionarySearchOrder.setDictionaryAvailableForSearch(index, true);
                ++i;
            }
        }
        return dictionarySearchOrder;
    }

    @Override
    public HashMap<String, Object> convertAutoSuggestOutput(ISuggestedCandidate candidateAddress, String countryCode) {
        return this.convertOutputWithoutAddtionalField(candidateAddress);
    }

    public HashMap<String, Object> convertOutputWithoutAddtionalField(ISuggestedCandidate candidateAddress) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        this.prepareStandardFieldOutput(candidateAddress, output);
        this.setOutputRangesConstraints(candidateAddress, output);
        return output;
    }

    private void setOutputRangesConstraints(ISuggestedCandidate candidateAddress, HashMap<String, Object> output) {
        int numberOfCandidateRanges = candidateAddress.getRangeCount();
        if (numberOfCandidateRanges > 0) {
            this.convertCandidateRanges(candidateAddress, output);
        }
    }

    private void convertCandidateRanges(ISuggestedCandidate candidateAddress, HashMap<String, Object> output) {
        int numberOfCandidateRanges = candidateAddress.getRangeCount();
        ArrayList<HashMap> rangeList = new ArrayList<HashMap>(numberOfCandidateRanges);
        int actualRangeCounter = 0;
        for (int i = 0; i < numberOfCandidateRanges; ++i) {
            if (candidateAddress.getSuggestedRange(i).getRangeString().equals("")) continue;
            rangeList.add(this.convertRangeToMap(candidateAddress, candidateAddress.getSuggestedRange(i)));
            ++actualRangeCounter;
        }
        output.put(ADDRESS_LINE_1, candidateAddress.getFormattedStreetAddress());
        output.put(RANGE_COUNT, String.valueOf(actualRangeCounter));
        output.put(RANGES, rangeList);
    }

    private HashMap convertRangeToMap(ISuggestedCandidate candidateAddress, ISuggestedCandidateRange suggestedCandidateRange) {
        HashMap<String, Object> rangeMap = new HashMap<String, Object>();
        if (suggestedCandidateRange != null) {
            String highHouse;
            String lowHouse;
            String convertedRangeValue = suggestedCandidateRange.getFrom() != null && suggestedCandidateRange.getTo() != null ? (!(lowHouse = suggestedCandidateRange.getFrom()).equals(highHouse = suggestedCandidateRange.getTo()) ? lowHouse + HYPHEN + highHouse : lowHouse) : suggestedCandidateRange.getRangeString();
            rangeMap.put(RANGE, convertedRangeValue);
            int numberOfRangeUnitsReturned = suggestedCandidateRange.getUnitCount();
            ArrayList<HashMap> candidateRangeUnits = new ArrayList<HashMap>(numberOfRangeUnitsReturned);
            for (int j = 0; j < numberOfRangeUnitsReturned; ++j) {
                candidateRangeUnits.add(this.convertCandidateRangeUnit(convertedRangeValue, candidateAddress, suggestedCandidateRange, suggestedCandidateRange.getUnitAt(j)));
            }
            if (candidateAddress.getRangeCount() > 0 && numberOfRangeUnitsReturned <= 0) {
                String formattedRangeAddress = this.buildformattedUnitAddress(convertedRangeValue, candidateAddress, suggestedCandidateRange, null);
                rangeMap.put(FORMATTED_RANGE_ADDRESS, formattedRangeAddress);
            }
            rangeMap.put(UNITS_COUNT, String.valueOf(numberOfRangeUnitsReturned));
            rangeMap.put(UNITS_INFO, candidateRangeUnits);
        }
        return rangeMap;
    }

    private HashMap convertCandidateRangeUnit(String convertedRangeValue, ISuggestedCandidate candidateAddress, ISuggestedCandidateRange suggestedCandidateRange, ISuggestedRangeUnit candidateRangeUnit) {
        HashMap<String, String> rangeUnitMap = new HashMap<String, String>();
        if (candidateRangeUnit != null) {
            rangeUnitMap.put(UNIT_INFO, candidateRangeUnit.getUnitString());
        }
        if (suggestedCandidateRange.getUnitCount() > 0) {
            String formattedUnitAddress = this.buildformattedUnitAddress(convertedRangeValue, candidateAddress, suggestedCandidateRange, candidateRangeUnit);
            rangeUnitMap.put(FORMATTED_UNIT_ADDRESS, formattedUnitAddress);
        }
        return rangeUnitMap;
    }

    private String buildformattedUnitAddress(String convertedRangeValue, ISuggestedCandidate candidateAddress, ISuggestedCandidateRange suggestedCandidateRange, ISuggestedRangeUnit candidateRangeUnit) {
        String unitInfo = "";
        String unitNum = "";
        String unitDesc = "";
        if (candidateRangeUnit != null) {
            unitInfo = candidateRangeUnit.getUnitString();
            unitNum = candidateRangeUnit.getAdditionalFields() != null ? (String)candidateRangeUnit.getAdditionalFields().get("unitnumber") : "";
            unitDesc = candidateRangeUnit.getAdditionalFields() != null ? (String)candidateRangeUnit.getAdditionalFields().get("unitdescription") : "";
        }
        String rangePlaceName = suggestedCandidateRange.getAdditionalFields() != null ? (String)suggestedCandidateRange.getAdditionalFields().get("range_place_name") : "";
        String addressPlaceName = candidateAddress.getName();
        String mainAddressLine = StringUtils.trimToEmpty((String)candidateAddress.getFormattedStreetAddress());
        String addressLastLine = candidateAddress.getFormattedLocationAddress();
        String country = ValidationUtils.getISO3Country((String)candidateAddress.getCountry());
        String lowHouse = suggestedCandidateRange.getFrom();
        String highHouse = suggestedCandidateRange.getTo();
        String addressNumber = candidateAddress.getAddressNumber();
        return this.buildformattedUnitAddress(convertedRangeValue, unitInfo, rangePlaceName, addressPlaceName, mainAddressLine, addressLastLine, country, lowHouse, highHouse, addressNumber, unitNum, unitDesc);
    }

    private String buildformattedUnitAddress(String convertedRangeValue, String unitInfo, String rangePlaceName, String addressPlaceName, String mainAddressLine, String addressLastLine, String country, String lowHouse, String highHouse, String addressNumber, String unitNum, String unitDesc) {
        StringBuilder formatedUnitAddress = new StringBuilder();
        if (COUNTRY_USA.equalsIgnoreCase(country)) {
            unitDesc = StringUtils.trimToEmpty((String)unitDesc);
            unitNum = StringUtils.trimToEmpty((String)unitNum);
            boolean isValid = DefaultTypeAheadConverter.isValidUnitInfo(unitNum, unitDesc);
            if (StringUtils.isNotBlank((CharSequence)rangePlaceName) && !rangePlaceName.equalsIgnoreCase(addressPlaceName)) {
                formatedUnitAddress.append(rangePlaceName).append(COMMA).append(SPACE);
            }
            if (StringUtils.isNotBlank((CharSequence)addressPlaceName)) {
                formatedUnitAddress.append(addressPlaceName).append(COMMA).append(SPACE);
            }
            String formatedUnitInfo = DefaultTypeAheadConverter.buildUnitInfo(unitDesc, unitNum);
            if (isValid && StringUtils.isNotBlank((CharSequence)formatedUnitInfo)) {
                formatedUnitAddress.append(formatedUnitInfo).append(COMMA).append(SPACE);
            }
            if (StringUtils.isNotBlank((CharSequence)lowHouse)) {
                if (!lowHouse.equals(addressNumber) || !mainAddressLine.startsWith(addressNumber)) {
                    formatedUnitAddress.append(lowHouse.trim());
                    formatedUnitAddress.append(SPACE).append(mainAddressLine).append(COMMA).append(SPACE);
                } else if (StringUtils.isNotBlank((CharSequence)mainAddressLine)) {
                    formatedUnitAddress.append(mainAddressLine).append(COMMA).append(SPACE);
                }
            } else if (StringUtils.isNotBlank((CharSequence)mainAddressLine)) {
                formatedUnitAddress.append(mainAddressLine).append(COMMA).append(SPACE);
            }
            if (!isValid && StringUtils.isNotBlank((CharSequence)formatedUnitInfo)) {
                formatedUnitAddress.append(formatedUnitInfo).append(COMMA).append(SPACE);
            }
            if (StringUtils.isNotBlank((CharSequence)addressLastLine)) {
                formatedUnitAddress.append(addressLastLine).append(COMMA).append(SPACE);
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)unitInfo)) {
                formatedUnitAddress.append(unitInfo).append(COMMA).append(SPACE);
            }
            if (StringUtils.isNotBlank((CharSequence)rangePlaceName) && !rangePlaceName.equalsIgnoreCase(addressPlaceName)) {
                formatedUnitAddress.append(rangePlaceName).append(COMMA).append(SPACE);
            }
            if (StringUtils.isNotBlank((CharSequence)addressPlaceName)) {
                formatedUnitAddress.append(addressPlaceName).append(COMMA).append(SPACE);
            }
            if (StringUtils.isNotBlank((CharSequence)convertedRangeValue)) {
                if (!convertedRangeValue.equals(addressNumber) || !mainAddressLine.startsWith(addressNumber)) {
                    formatedUnitAddress.append(convertedRangeValue.trim());
                    formatedUnitAddress.append(COMMA).append(SPACE).append(mainAddressLine).append(COMMA).append(SPACE);
                } else if (StringUtils.isNotBlank((CharSequence)mainAddressLine)) {
                    formatedUnitAddress.append(mainAddressLine).append(COMMA).append(SPACE);
                }
            } else if (StringUtils.isNotBlank((CharSequence)mainAddressLine)) {
                formatedUnitAddress.append(mainAddressLine).append(COMMA).append(SPACE);
            }
            if (StringUtils.isNotBlank((CharSequence)addressLastLine)) {
                formatedUnitAddress.append(addressLastLine).append(COMMA).append(SPACE);
            }
        }
        int lastIndx = formatedUnitAddress.lastIndexOf(", ");
        if (lastIndx != -1 && formatedUnitAddress.toString().endsWith(", ")) {
            formatedUnitAddress = formatedUnitAddress.replace(lastIndx, formatedUnitAddress.length(), "");
        }
        return formatedUnitAddress.toString().trim();
    }

    private static boolean isValidUnitInfo(String unitNum, String unitDesc) {
        return !"#".equalsIgnoreCase(unitDesc) || !StringUtils.containsAny((CharSequence)unitNum, (char[])DIGITS_ARRAY);
    }

    private static String buildUnitInfo(String unitDescription, String unitNumber) {
        StringBuilder builder = new StringBuilder();
        boolean descPresent = false;
        if (StringUtils.isNotBlank((CharSequence)unitDescription)) {
            builder.append(unitDescription);
            descPresent = true;
        }
        if (descPresent) {
            builder.append(SPACE);
        }
        if (StringUtils.isNotBlank((CharSequence)unitNumber)) {
            builder.append(unitNumber);
        }
        return builder.toString();
    }

    private void prepareStandardFieldOutput(ISuggestedCandidate candidateAddress, HashMap<String, Object> output) {
        output.put(ADDRESS_LINE_1, candidateAddress.getFormattedStreetAddress());
        output.put(FORMATTED_ADDRESS, candidateAddress.getFormattedString());
        output.put(FIRM_NAME, candidateAddress.getName());
        output.put(LAST_LINE, candidateAddress.getFormattedLocationAddress());
        output.put(STATE_PROVINCE, candidateAddress.getAreaName1());
        output.put(COUNTY, candidateAddress.getAreaName2());
        output.put(CITY, candidateAddress.getAreaName3());
        output.put(LOCALITY, candidateAddress.getAreaName4());
        output.put("Country", ValidationUtils.getFullCountryName((String)candidateAddress.getCountry()));
        output.put(POSTAL_CODE, candidateAddress.getPostCode());
        output.put(TYPE, String.valueOf(candidateAddress.getType()));
        Map matchMap = candidateAddress.getMatchedFields();
        for (String key : matchMap.keySet()) {
            if (key.equalsIgnoreCase("AreaName3")) {
                output.put(CITY_NAME_MATCH, "True");
            }
            output.put(key + ".Match", "True");
        }
    }

    @Override
    public HashMap<String, Object> prepareUSFieldOutput(PBFnlDatabase record, int opts) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        output.put("Country", "UNITED STATES");
        if (!record.streetName.isEmpty()) {
            output.put(STREETNAME, record.streetName);
        }
        if (!record.rangeLow.isEmpty()) {
            output.put(HOUSENUMBERLOW, record.rangeLow);
        }
        if (!record.rangeHi.isEmpty() && !record.rangeHi.equals(record.rangeLow)) {
            output.put(HOUSENUMBERHIGH, record.rangeHi);
        }
        if (!record.firm.isEmpty()) {
            output.put(FIRM_NAME, record.firm);
        }
        if (!record.stateAbbreviation.isEmpty()) {
            output.put(STATE_PROVINCE, record.stateAbbreviation);
        }
        if (!record.countyName.isEmpty()) {
            output.put(COUNTY, record.countyName);
        }
        if (!record.cityName.isEmpty()) {
            output.put(CITY, record.cityName);
        }
        if (!record.preferredCity.isEmpty()) {
            output.put(PREFERRED_CITY, record.preferredCity);
        }
        if (!record.urbname.isEmpty()) {
            output.put(LOCALITY, record.urbname);
        }
        if (!record.zipcode.isEmpty()) {
            if (!record.firm.isEmpty() && !record.firmzip4.isEmpty()) {
                output.put(POSTAL_CODE, record.zipcode + HYPHEN + record.firmzip4);
            } else {
                output.put(POSTAL_CODE, record.zipcode);
            }
        }
        if (record.mailingInd == 1) {
            output.put(TYPE, "MAILING");
        } else if (record.mailingInd == 2) {
            output.put(TYPE, "NON-MAILING");
        }
        if (!record.preDir.isEmpty()) {
            output.put(preDir, record.preDir);
        }
        if (!record.posDir.isEmpty()) {
            output.put(posDir, record.posDir);
        }
        if (!record.suffix.isEmpty()) {
            output.put(suffix, record.suffix);
        }
        if (!record.carrRte.isEmpty()) {
            output.put(carrRte, record.carrRte);
        }
        if (!record.eob.isEmpty()) {
            output.put(eob, record.eob);
        }
        if (!record.zip4Low.isEmpty()) {
            output.put(zip4Low, record.zip4Low);
        }
        if (!record.zip4Hi.isEmpty() && !record.zip4Hi.equals(record.zip4Low)) {
            output.put(zip4Hi, record.zip4Hi);
        }
        if (!record.alias.isEmpty()) {
            output.put(alias, record.alias);
        }
        if (!record.alternate.isEmpty()) {
            output.put(alternate, record.alternate);
        }
        if (!record.unit.isEmpty()) {
            output.put(unit, record.unit);
        }
        return output;
    }

    static {
        geocodeLevels.put(AUTOSUGGEST_STREET_ADDRESS, 124);
        geocodeLevels.put(AUTOSUGGEST_POI, 3);
        geocodeLevels.put(AUTOSUGGEST_ALL, 65535);
        geocodeLevels.put(AUTOSUGGEST_CATEGORY, 2);
        geocodeLevels.put(FIND_NEAREST_POI, 3);
    }
}

