/*
 * Decompiled with CFR 0.152.
 */
package com.pb.spectrum.gav;

import com.pb.addressing.util.ValidationUtils;
import com.pb.spectrum.autosuggest.api.TypeAheadEngine;
import com.pb.spectrum.gav.CountryDataMappingCreator;
import com.pb.spectrum.gav.GavSystemProperties;
import com.pb.spectrum.gav.address.InternationalEngine;
import com.pb.spectrum.gav.address.TypeAhead;
import com.pb.spectrum.gav.address.USEngine;
import com.pb.spectrum.gav.data.AddressConfigurationOptions;
import com.pb.spectrum.gav.data.DictionaryDataSet;
import com.pb.spectrum.gav.data.DictionaryInfo;
import com.pb.spectrum.gav.data.DictionaryPath;
import com.pb.spectrum.gav.data.DictionaryResource;
import com.pb.spectrum.gav.data.GAVException;
import com.pb.spectrum.gav.data.GavResource;
import com.pb.spectrum.gav.data.SpdInfo;
import com.pb.spectrum.gav.data.TypeAheadException;
import com.pb.spectrum.gav.engine.GavEngine;
import com.pb.spectrum.gav.spd.SpdUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteAddressGavEngineWrapper
implements InternationalEngine,
TypeAhead,
USEngine {
    private static Log log = LogFactory.getLog(RemoteAddressGavEngineWrapper.class);
    private String databaseName;
    private CountryDataMappingCreator mappingCreator = null;
    private GavEngine gavEngine;
    private TypeAheadEngine typeAheadEngine;
    private HashMap<String, List<String>> countryDictionaryMap;
    private HashMap<String, String> usDictionaryMap;
    private boolean sdk;
    private final GavResource gavResource;
    private final GavSystemProperties gavSystemProperties;
    private DictionaryResource dictionaryResource;
    private List<String> dictionaryPathLib;

    public RemoteAddressGavEngineWrapper(GavResource gavResource, GavSystemProperties gavSystemProperties) {
        this.gavResource = gavResource;
        this.gavSystemProperties = gavSystemProperties;
    }

    public RemoteAddressGavEngineWrapper(GavResource gavResource, GavSystemProperties gavSystemProperties, DictionaryResource dictionaryResource) {
        this.gavResource = gavResource;
        this.gavSystemProperties = gavSystemProperties;
        this.dictionaryResource = dictionaryResource;
    }

    public HashMap<String, Object> cleanup(boolean b) throws GAVException {
        return this.gavEngine.cleanup(b);
    }

    public ArrayList<Map<String, Object>> validateAddress(HashMap<String, String> inputAddress, HashMap<String, String> optionAddress) throws GAVException {
        ArrayList response = null;
        response = this.gavEngine.validateAddress(inputAddress, optionAddress);
        return response;
    }

    public ArrayList<Map<String, Object>> dbLookup(HashMap<String, String> optionsMap, HashMap<String, String> inputAddress) throws GAVException {
        ArrayList response = null;
        response = this.gavEngine.dbLookup(optionsMap, inputAddress);
        return response;
    }

    public void setPreferences(AddressConfigurationOptions optionAddress) throws GAVException {
        this.gavEngine.setPreferences(optionAddress);
    }

    public Map<String, Set<String>> getVersion() throws GAVException {
        Map versionMap = this.gavEngine.getVersion();
        if (this.typeAheadEngine != null && this.typeAheadEngine.getTypeheadVersionInfo() != null) {
            versionMap.putAll(this.typeAheadEngine.getTypeheadVersionInfo());
        }
        return versionMap;
    }

    public void initialize() {
        this.mappingCreator = null;
        String fileSeparator = System.getProperty("file.separator");
        if (this.gavResource.getDatabaseName() != null) {
            this.databaseName = this.gavResource.getDatabaseName();
        }
        ArrayList gavSPDProperty = this.gavResource.getbuildGAVProp();
        try {
            this.mappingCreator = this.createCountryToDictionaryMapping(gavSPDProperty);
        }
        catch (IOException ioException) {
            log.error((Object)("Error during createCountryToDictionaryMapping : " + ioException.getLocalizedMessage()));
        }
        catch (GAVException gavException) {
            throw new RuntimeException(gavException);
        }
        System.setProperty("config.location", this.gavSystemProperties.getConfigLocation() + fileSeparator);
        try {
            this.countryDictionaryMap = this.mappingCreator.getCountryDictionaryMap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.gavEngine = new GavEngine(this.countryDictionaryMap);
        try {
            if (this.dictionaryResource != null && SpdUtils.isGTAAvailable()) {
                this.typeAheadEngine = new TypeAheadEngine(this.dictionaryResource, gavSPDProperty);
            }
        }
        catch (TypeAheadException e) {
            e.printStackTrace();
        }
    }

    private CountryDataMappingCreator createCountryToDictionaryMapping(ArrayList<SpdInfo> buildGAVProp) throws IOException, GAVException {
        CountryDataMappingCreator mappingCreator = new CountryDataMappingCreator();
        for (SpdInfo spdInfo : buildGAVProp) {
            String path = spdInfo.getSpdPath();
            String selectedGAVCountryList = spdInfo.getCountryCode();
            String spdQualifierName = spdInfo.getQualifierName();
            mappingCreator.scanRootDir(new File(path), selectedGAVCountryList, spdQualifierName);
        }
        return mappingCreator;
    }

    public HashMap<String, List<String>> getCountryLicenseList() {
        return this.gavEngine.getCountryLicenseList();
    }

    public HashMap<String, Date> getGAMExpirationInfo() {
        return this.gavEngine.getGAMExpirationInfo();
    }

    public void setSdk(boolean sdk) {
        this.sdk = sdk;
    }

    public ArrayList<HashMap<String, Object>> suggest(HashMap options, HashMap input) throws TypeAheadException {
        String countryISOCode = ValidationUtils.getISO3Country((String)((String)input.get("Country")));
        input.put("Country", countryISOCode);
        return this.typeAheadEngine.suggest(options, input);
    }

    public void setDictionaryPathLib(List<String> dictionaryPathLib) {
        this.dictionaryPathLib = dictionaryPathLib;
    }

    public DictionaryInfo[] updateDictionaryInfos(DictionaryPath[] dictionaryPaths) throws TypeAheadException {
        return null;
    }

    public HashMap<String, List<String>> getDataLicenseCodes() throws TypeAheadException {
        if (this.typeAheadEngine == null) {
            throw new TypeAheadException("TypeAhead engine not initialized.");
        }
        return this.typeAheadEngine.getDataLicenseCodes();
    }

    public DictionaryDataSet[] getDictionaryInformation() throws TypeAheadException {
        if (this.typeAheadEngine == null) {
            throw new TypeAheadException("TypeAhead engine not initialized.");
        }
        return this.typeAheadEngine.getDictionaryInformation();
    }

    public ArrayList<String> getGAVConfiguredCountries() {
        return this.gavEngine.getGAVConfiguredCountries();
    }

    public ArrayList<String> getGTAConfiguredCountries() throws TypeAheadException {
        if (this.typeAheadEngine != null) {
            return this.typeAheadEngine.getGTAConfiguredCountries();
        }
        return null;
    }

    public String getValidCountry(String inputCountry, boolean flag) {
        return this.gavEngine.getValidCountry(inputCountry, flag);
    }
}

