/*
 * Decompiled with CFR 0.152.
 */
package com.pb.addressing.api;

import com.mapinfo.geocode.CountrySupport;
import com.mapinfo.geocode.Geocoder;
import com.mapinfo.geocode.GeocodingException;
import com.mapinfo.geocode.api.CapabilitiesResponse;
import com.mapinfo.geocode.api.Dictionary;
import com.mapinfo.geocode.api.Response;
import com.mapinfo.mapmarker.common.dp.descriptor.DataDescriptorProvider;
import com.mapinfo.mapmarker.common.dp.descriptor.MetaData;
import com.pb.addressing.CandidateCase;
import com.pb.addressing.ExceptionCode;
import com.pb.addressing.ValidateAddress;
import com.pb.addressing.ValidationException;
import com.pb.addressing.adapter.AddressAdapter;
import com.pb.addressing.api.AddrScanJNI;
import com.pb.addressing.api.Address;
import com.pb.addressing.api.AddressingAPI;
import com.pb.addressing.api.PBFnlAPI;
import com.pb.addressing.api.PBFnlAddrScan;
import com.pb.addressing.api.PBFnlAddressData;
import com.pb.addressing.api.PBFnlCandidate;
import com.pb.addressing.api.PBFnlDatabase;
import com.pb.addressing.api.Preferences;
import com.pb.addressing.api.ResponseAPI;
import com.pb.addressing.api.ValidationAPI;
import com.pb.addressing.api.ValidationLevel;
import com.pb.addressing.api.ValidationPreferences;
import com.pb.addressing.api.ValidationResponse;
import com.pb.geocoding.config.ConfigCountry;
import com.pb.geocoding.config.ConfigurationModel;
import com.pb.geocoding.config.DataSet;
import com.pb.geocoding.config.JsonConfigurationImpl;
import com.pb.geocoding.config.api.GeocodingConfiguration;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class AddressValidator
implements ValidationAPI,
AddressingAPI {
    private AddrScanJNI scanjni;
    private PBFnlAPI pbfnljni;
    private Geocoder geocoder;
    private HashMap<String, List<String>> countryLicenseMap;
    private HashMap<String, String> usVersioInfoMap;
    private String usDictionaryPath;
    private static final String US = "US";
    private static final String EXPIRATION_DATE_FORMAT_PATTERN = "MM-dd-yyyy";
    private static final String GAM_US_DOMESTIC_DB_EXPIRATION = "US Domestic Database";
    private static final String GAM_US_CASS_ENGINE_EXPIRATION = "US CASS Engine";
    private static final String US_DOMESTIC_FILE = "dpv.db";
    private static final String US_NON_DOMESTIC_FILE = "city.dir";
    private static final String DOM_KEY = "UDD";
    private static final String NON_DOM_KEY = "UND";
    private static final String key = "1A22440ED3A39F98";
    private static final String initVector = "DDF15FDC5176015B";

    public AddressValidator() throws ValidationException {
        try {
            this.geocoder = new Geocoder();
        }
        catch (GeocodingException e) {
            throw new ValidationException("Error creating/instantiating validation engine", ExceptionCode.GLOBAL_ADDRESSING_FATAL_EXCEPTION, e);
        }
    }

    public AddressValidator(Map<String, List<String>> dataDictionaryMap) throws ValidationException {
        if (dataDictionaryMap.size() == 1 && dataDictionaryMap.containsKey(US)) {
            this.initializeUSEngine(dataDictionaryMap);
        } else if (!dataDictionaryMap.containsKey(US)) {
            this.initializeIntlEngine(dataDictionaryMap);
        } else {
            this.initializeUSEngine(dataDictionaryMap);
            this.initializeIntlEngine(dataDictionaryMap);
        }
    }

    private void initializeIntlEngine(Map<String, List<String>> dataDictionaryMap) throws ValidationException {
        try {
            GeocodingConfiguration config = this.configureCountryDB(dataDictionaryMap);
            HashMap<String, String> configurationMap = new HashMap<String, String>();
            configurationMap.put("config.location", "");
            configurationMap.put("res.location", "");
            config.setConfig(configurationMap);
            this.geocoder = new Geocoder(config);
        }
        catch (GeocodingException e) {
            throw new ValidationException("Error creating/instantiating validation engine", ExceptionCode.GLOBAL_ADDRESSING_FATAL_EXCEPTION, e);
        }
    }

    private void initializeUSEngine(Map<String, List<String>> dataDictionaryMap) {
        this.scanjni = new AddrScanJNI();
        this.pbfnljni = new PBFnlAPI();
        this.usDictionaryPath = dataDictionaryMap.get(US).get(0);
    }

    @Override
    public ResponseAPI validate(Address address, ValidationLevel level, Preferences preferences) throws ValidationException {
        if (address == null) {
            throw new ValidationException("Null address provided", ExceptionCode.REQUIRED_PARAMETER_MISSING);
        }
        try {
            preferences = preferences == null ? new ValidationPreferences() : preferences;
            ValidationLevel validationLevel = level = level == null ? ValidationLevel.ADDRESS : level;
            if (this.pbfnljni != null && this.isUSAteritory(address.getCountry())) {
                this.initFinalistEngine(preferences, this.usDictionaryPath);
                return this.finalistCoder(address, preferences);
            }
            if (this.geocoder == null) {
                throw new ValidationException("Error Validating Address", ExceptionCode.GLOBAL_ADDRESSING_EXCEPTION, new Throwable("Either country was not provided, or data for input country is not available."));
            }
            Response geocodeResponse = this.geocoder.geocode(AddressAdapter.convertFromValidationLevel(level), AddressAdapter.convertFromValidateAddress(address), AddressAdapter.convertFromValidationPreferences(preferences));
            CapabilitiesResponse capabilitiesResponse = this.getCapabilities();
            ValidationResponse responseAPI = new ValidationResponse(geocodeResponse, capabilitiesResponse, preferences, address);
            return responseAPI;
        }
        catch (GeocodingException e) {
            throw new ValidationException("Error Validating Address", ExceptionCode.GLOBAL_ADDRESSING_EXCEPTION, e);
        }
    }

    @Override
    public List<String> getConfiguredCountries() throws ValidationException {
        ArrayList<String> countries = new ArrayList<String>();
        try {
            if (this.geocoder != null) {
                countries = this.geocoder.getCapabilities().getSupportedCountries();
            }
            if (this.pbfnljni != null) {
                countries.add("USA");
            }
        }
        catch (GeocodingException e) {
            throw new ValidationException("Error retrieving supported countries list", ExceptionCode.GLOBAL_ADDRESSING_EXCEPTION, e);
        }
        return countries;
    }

    public CapabilitiesResponse getCapabilities() throws ValidationException {
        CapabilitiesResponse capabilitiesResponse = null;
        try {
            capabilitiesResponse = this.geocoder.getCapabilities();
        }
        catch (GeocodingException e) {
            throw new ValidationException("Error getting capabilities of engine", ExceptionCode.GLOBAL_ADDRESSING_EXCEPTION, e);
        }
        return capabilitiesResponse;
    }

    @Override
    public Map<String, Set<String>> getVersionInformation() throws ValidationException {
        HashMap<String, Set<String>> versionMap = new HashMap<String, Set<String>>(){

            @Override
            public Set<String> get(Object key) {
                HashSet set = (HashSet)super.get(key);
                if (set == null) {
                    set = new HashSet();
                    this.put((String)key, set);
                }
                return set;
            }
        };
        try {
            if (this.geocoder != null) {
                List dictionaries = this.geocoder.getConfiguredDictionaries();
                for (Dictionary dictionary : dictionaries) {
                    Set countrySupportInfos = dictionary.getCountrySupportInformation();
                    if (countrySupportInfos.size() <= 0) continue;
                    for (CountrySupport countrySupport : countrySupportInfos) {
                        Set suppCountry = countrySupport.getSupportedCountries();
                        for (String country : suppCountry) {
                            if (dictionary.getSource().contains("XW")) {
                                HashSet<String> worldDicVersion = new HashSet<String>();
                                worldDicVersion.add(dictionary.getSource() + "_" + dictionary.getVintage());
                                versionMap.put("World", worldDicVersion);
                                continue;
                            }
                            if (((Set)versionMap.get("" + country)).contains(dictionary.getSource().toUpperCase() + "_" + dictionary.getVintage())) continue;
                            ((Set)versionMap.get("" + country)).add(dictionary.getSource().toUpperCase() + "_" + dictionary.getVintage());
                        }
                    }
                }
            }
            if (this.pbfnljni != null) {
                HashMap<String, String> usVersionInfoMap = this.pbfnljni.getInfo(this.usDictionaryPath);
                String usDomMonthInfo = "";
                String usNonDomMonthInfo = "";
                HashSet<String> usDomMonthSet = new HashSet<String>();
                HashSet<String> usNonDomMonthSet = new HashSet<String>();
                if (usVersionInfoMap.get("DPVDBVintage") != null) {
                    usDomMonthInfo = (String)usVersionInfoMap.get("ZIP4DBVintage");
                    usDomMonthSet.add(usDomMonthInfo);
                }
                if (usVersionInfoMap.get("ZIP4DBVintage") != null) {
                    usNonDomMonthInfo = (String)usVersionInfoMap.get("ZIP4DBVintage");
                    usNonDomMonthSet.add(usNonDomMonthInfo);
                }
                if (this.usDictionaryPath != null && AddressValidator.isValidDataDirectory(new File(this.usDictionaryPath), US_DOMESTIC_FILE)) {
                    versionMap.put("USA DOMESTIC", usDomMonthSet);
                } else {
                    versionMap.put("USA NON-DOMESTIC", usNonDomMonthSet);
                }
            }
        }
        catch (GeocodingException e) {
            throw new ValidationException("Error getting version information", ExceptionCode.GLOBAL_ADDRESSING_EXCEPTION, e.getCause());
        }
        return versionMap;
    }

    public HashMap<String, Date> getExpirationInfo() throws ValidationException {
        HashMap<String, Date> expirationInfoMap = new HashMap<String, Date>();
        if (this.pbfnljni != null) {
            HashMap<String, String> usVersionInfoMap = this.pbfnljni.getInfo(this.usDictionaryPath);
            String usDomDBExpInfo = "99-99-9999";
            String cassEngineExpireDate = "99-99-9999";
            if (usVersionInfoMap.get("ZIP4DBExpire") != null || usVersionInfoMap.get("ZIP4DBExpire") != "") {
                usDomDBExpInfo = (String)usVersionInfoMap.get("ZIP4DBExpire");
            }
            if (usVersionInfoMap.get("EngineExpireDate") != null || usVersionInfoMap.get("EngineExpireDate") != "") {
                cassEngineExpireDate = (String)usVersionInfoMap.get("EngineExpireDate");
            }
            try {
                if (usDomDBExpInfo.equals("XX-XX-XXXX")) {
                    usDomDBExpInfo = "99-99-9999";
                }
                if (cassEngineExpireDate.equals("XX-XX-XXXX")) {
                    cassEngineExpireDate = "99-99-9999";
                }
                expirationInfoMap.put(GAM_US_DOMESTIC_DB_EXPIRATION, new SimpleDateFormat(EXPIRATION_DATE_FORMAT_PATTERN).parse(usDomDBExpInfo));
                expirationInfoMap.put(GAM_US_CASS_ENGINE_EXPIRATION, new SimpleDateFormat(EXPIRATION_DATE_FORMAT_PATTERN).parse(cassEngineExpireDate));
            }
            catch (ParseException e) {
                throw new ValidationException("Error getting version information", ExceptionCode.GLOBAL_ADDRESSING_EXCEPTION, e.getCause());
            }
        }
        return expirationInfoMap;
    }

    public HashMap<String, List<String>> getLicenseMap() throws ValidationException, IOException {
        if (this.usDictionaryPath != null) {
            this.initUSLicenseList();
        }
        if (this.geocoder != null) {
            this.countryLicenseMap = new HashMap();
            DataDescriptorProvider provider = DataDescriptorProvider.getInstance();
            List metaDatas = provider.getMetaData();
            for (MetaData metaData : metaDatas) {
                String country = (String)metaData.getCountries().get(0);
                ArrayList<String> productCodeList = new ArrayList<String>();
                String encProductCodeString = metaData.getProductCode();
                if (encProductCodeString == null || encProductCodeString.length() == 0) {
                    String sName = "";
                    int index = metaData.getLocation().toString().lastIndexOf(92);
                    if (index == -1) {
                        index = metaData.getLocation().toString().lastIndexOf(47);
                    }
                    sName = metaData.getLocation().toString().substring(index + 1);
                    throw new ValidationException("Error creating license map for " + sName);
                }
                if (StringUtils.isEmpty((String)encProductCodeString)) continue;
                String decProductCodeString = AddressValidator.decrypt(encProductCodeString);
                List<String> updatedproductCode = null;
                if (this.countryLicenseMap.containsKey(country) && !this.countryLicenseMap.get(country).contains(decProductCodeString)) {
                    updatedproductCode = this.countryLicenseMap.get(country);
                    updatedproductCode.add(decProductCodeString);
                } else {
                    productCodeList.add(decProductCodeString);
                }
                if (this.countryLicenseMap.containsKey(country) && updatedproductCode != null) {
                    this.countryLicenseMap.put(country, updatedproductCode);
                    continue;
                }
                this.countryLicenseMap.put(country, productCodeList);
            }
        }
        return this.countryLicenseMap;
    }

    private Map<String, List<String>> initUSLicenseList() {
        ArrayList<String> usaLicenseInfo = new ArrayList<String>();
        if (AddressValidator.isValidDataDirectory(new File(this.usDictionaryPath), US_NON_DOMESTIC_FILE) && AddressValidator.isValidDataDirectory(new File(this.usDictionaryPath), US_DOMESTIC_FILE)) {
            usaLicenseInfo.add(DOM_KEY);
        }
        if (!usaLicenseInfo.contains(DOM_KEY) && AddressValidator.isValidDataDirectory(new File(this.usDictionaryPath), US_NON_DOMESTIC_FILE) && !AddressValidator.isValidDataDirectory(new File(this.usDictionaryPath), US_DOMESTIC_FILE)) {
            usaLicenseInfo.add(NON_DOM_KEY);
        }
        this.countryLicenseMap = new HashMap();
        this.countryLicenseMap.put("USA", usaLicenseInfo);
        return this.countryLicenseMap;
    }

    private static String encrypt(String value) {
        try {
            IvParameterSpec iv = new IvParameterSpec(initVector.getBytes("UTF-8"));
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(1, (Key)skeySpec, iv);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String decrypt(String encrypted) {
        try {
            IvParameterSpec iv = new IvParameterSpec(initVector.getBytes("UTF-8"));
            SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(2, (Key)skeySpec, iv);
            byte[] original = cipher.doFinal(Base64.decodeBase64((String)encrypted));
            return new String(original);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private GeocodingConfiguration configureCountryDB(Map<String, List<String>> countryPropertiesMap) {
        Set<String> keys = countryPropertiesMap.keySet();
        ArrayList<ConfigCountry> countries = new ArrayList<ConfigCountry>();
        for (String key : keys) {
            ConfigCountry country = new ConfigCountry();
            country.setCountry(key);
            country.setDataSets(this.getconfiguredDataSets(countryPropertiesMap.get(key)));
            countries.add(country);
        }
        ConfigurationModel model = new ConfigurationModel();
        model.setCountries(countries);
        JsonConfigurationImpl dataConfig = new JsonConfigurationImpl(model);
        return dataConfig;
    }

    private List<DataSet> getconfiguredDataSets(List<String> dictionaries) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        for (String path : dictionaries) {
            DataSet data = new DataSet();
            data.setPath(path);
            dataSets.add(data);
        }
        return dataSets;
    }

    public static void main(String[] args) throws ValidationException {
        HashMap<String, List<String>> countrydictionaryMap = new HashMap<String, List<String>>();
        ArrayList<String> inddictionary = new ArrayList<String>();
        inddictionary.add("F:\\CDBFiles\\spd\\IND-EGM-TOMTOM-STREET-EN-IN1\\");
        ArrayList<String> fradictionary = new ArrayList<String>();
        fradictionary.add("F:\\FRA-GAV-TOMTOM-STREET-FR-FR1\\");
        countrydictionaryMap.put("IND", inddictionary);
        countrydictionaryMap.put("FRA", fradictionary);
        ArrayList<String> GBRdictionary = new ArrayList<String>();
        GBRdictionary.add("F:\\SGI-data\\GBR\\AB\\");
        countrydictionaryMap.put("GBR", GBRdictionary);
        AddressValidator validator = new AddressValidator(countrydictionaryMap);
        ValidationPreferences prfs = new ValidationPreferences();
        prfs.setReturnCountrySpecificFields(true);
        prfs.setReturnPasedInputAddress(true);
        prfs.setCasing(CandidateCase.MIXED);
        prfs.setReturnPrecisionCode(false);
        prfs.setReturnInputAddress(false);
        prfs.setMaxReturnedCandidates(1);
        prfs.setPreferPOBoxOverStreet(false);
        ResponseAPI responsemap = validator.validate(AddressValidator.getGBRAddress(), ValidationLevel.ADDRESS, prfs);
        System.out.println("MultiMatchCount=== " + responsemap.getMultimatchCount());
        System.out.println("Candidates=== " + responsemap.getCandidates());
        System.out.println("Inputaddress=== " + responsemap.getInputAddress());
        System.out.println("ParsedInput=== " + responsemap.getParsedInput());
        System.out.println(" Country specific fields =====" + responsemap.getCandidates().get(0).getCountrySpecificFields());
    }

    public static Address getGBRAddress() {
        ValidateAddress address = new ValidateAddress();
        address.setAddressLine1("Prime minister and lord of the treasury , 10 Downing Street London sw1a2aa");
        address.setCountry("GBR");
        return address;
    }

    public static Address getFraAddress() {
        ValidateAddress address = new ValidateAddress();
        address.setAddressLine1("25 rue Alexandre B\u00ef\u00bf\u00bdrard BP 20121 AMBERIEU EN BUGEY 01500 ");
        address.setCountry("FRA");
        return address;
    }

    public static Address getIndAddress() {
        ValidateAddress address = new ValidateAddress();
        address.setAddressLine1("c-445 vikaspuri new delhi 110018");
        address.setCountry("IND");
        return address;
    }

    private void initFinalistEngine(Preferences preferences, String pathFinalistSPD) throws ValidationException {
        String s = this.pbfnljni.initFnlEngine(preferences, pathFinalistSPD);
        if (s.length() != 0) {
            throw new ValidationException("US Initialization Failed: " + s, ExceptionCode.GLOBAL_ADDRESSING_EXCEPTION);
        }
    }

    public HashMap<String, Object> cleanup(boolean b) throws ValidationException {
        HashMap<String, Object> stringObjectHashMap = new HashMap<String, Object>();
        if (this.pbfnljni != null) {
            stringObjectHashMap = this.pbfnljni.deinitEngine(b);
        }
        return stringObjectHashMap;
    }

    private int fillDataBlocks(Map<String, String> data, int counter, String dataBlock) {
        int myCounter = counter;
        String s = data.get("AddressBlock" + counter);
        while (s != null && s.length() != 0) {
            s = data.get("AddressBlock" + ++counter);
        }
        if (dataBlock != null && dataBlock.length() > 0) {
            data.put("AddressBlock" + counter, dataBlock);
            return counter + 1;
        }
        return counter;
    }

    public ResponseAPI finalistCoder(Address address, Preferences preferences) throws ValidationException {
        HashMap<String, String> data = new HashMap<String, String>();
        ValidateAddress validateAddress = new ValidateAddress(address);
        boolean scanActive = false;
        boolean skipASLL = false;
        PBFnlAddressData fnl = new PBFnlAddressData();
        if (validateAddress.getAddressLine3().length() > 0) {
            scanActive = true;
        }
        if (validateAddress.getAddressLine4().length() > 0) {
            scanActive = true;
        }
        if (validateAddress.getAddressLine5().length() > 0) {
            scanActive = true;
        }
        if (validateAddress.getAddressLine6().length() > 0) {
            scanActive = true;
        }
        if (validateAddress.getLastLine().length() == 0 && validateAddress.getCity().length() == 0 && validateAddress.getCitySubdivision().length() == 0 && validateAddress.getStateProvince().length() == 0 && validateAddress.getPostalCode().length() == 0) {
            scanActive = true;
        } else {
            skipASLL = true;
        }
        if (scanActive) {
            PBFnlAddrScan addrScan = new PBFnlAddrScan();
            String s = "A";
            addrScan.setRtnOpt(preferences.getReturnLine1() + preferences.getReturnLine2() + preferences.getSpecialOption());
            addrScan.setRtnOrder(preferences.getReturnLineOrder());
            addrScan.setNoMergeSecPMB(preferences.getSkipMerge());
            if (preferences.getPreventPound().equals("Y")) {
                s = s + "#";
            }
            if (preferences.getPreventPeriod().equals("Y")) {
                s = s + "P";
            }
            if (preferences.getPreventDangling().equals("Y")) {
                s = s + "D";
            }
            if (preferences.getSkipMerge().equals("Y")) {
                addrScan.setNoMergeSecPMB("S");
            }
            if (preferences.getSkipFirm().equals("Y")) {
                addrScan.setSkipFirm("S");
            }
            if (preferences.getSkipURB().equals("Y")) {
                addrScan.setSkipUrb("S");
            }
            if (preferences.getSkipCityState().equals("Y")) {
                addrScan.setSkipCSZ("S");
            }
            addrScan.setInput(1, address.getAddressLine1());
            addrScan.setInput(2, validateAddress.getAddressLine2());
            addrScan.setInput(3, validateAddress.getAddressLine3());
            addrScan.setInput(4, validateAddress.getAddressLine4());
            addrScan.setInput(5, validateAddress.getAddressLine5());
            addrScan.setInput(6, validateAddress.getAddressLine6());
            addrScan.setAddrTypes(s);
            if (validateAddress.getFirmName().length() > 0) {
                addrScan.setSkipFirm("S");
            }
            if (validateAddress.getCitySubdivision().length() > 0) {
                addrScan.setSkipUrb("S");
            }
            if (skipASLL) {
                addrScan.setSkipCSZ("S");
            }
            this.scanjni.FNLaddrScan(addrScan);
            int counter = 1;
            for (int i = 0; i < addrScan.getUnusedLines().length(); ++i) {
                String workString;
                s = addrScan.getUnusedLines().substring(i, i + 1);
                if (s.equals(" ") || (workString = addrScan.getInput(Integer.parseInt(s))).length() <= 0) continue;
                counter = this.fillDataBlocks(data, counter, workString);
            }
            fnl.cFirm = validateAddress.getFirmName().length() > 0 ? this.setFnlContent(address.getFirmName()) : addrScan.getFirm();
            fnl.cAddress1 = addrScan.getLabel1();
            fnl.cAddress2 = addrScan.getLabel2();
            if (skipASLL) {
                fnl.cCity = this.setFnlContent(address.getLastLine());
                if (fnl.cCity.length() == 0) {
                    fnl.cCity = this.setFnlContent(address.getCity());
                }
                fnl.cState = this.setFnlContent(address.getStateProvince());
                fnl.cZip = address.getPostalCode();
                fnl.cZip4 = "";
            } else {
                fnl.cCity = addrScan.getLastline();
                if (addrScan.getAddrZip4().length() > 4) {
                    fnl.cZip = addrScan.getAddrZip4().substring(0, 5);
                    if (addrScan.getAddrZip4().length() > 6) {
                        fnl.cZip4 = addrScan.getAddrZip4().substring(6);
                    }
                }
            }
            fnl.cUrb = validateAddress.getCitySubdivision().length() > 0 ? this.setFnlContent(address.getCitySubdivision()) : addrScan.getURB();
        } else {
            String workString;
            fnl.cFirm = this.setFnlContent(address.getFirmName());
            fnl.cAddress1 = this.setFnlContent(address.getAddressLine1());
            fnl.cAddress2 = this.setFnlContent(address.getAddressLine2());
            fnl.cUrb = this.setFnlContent(address.getCitySubdivision());
            fnl.cCity = this.setFnlContent(address.getLastLine());
            if (fnl.cCity.length() == 0) {
                fnl.cCity = this.setFnlContent(address.getCity());
            }
            fnl.cState = this.setFnlContent(address.getStateProvince());
            fnl.cZip = workString = address.getPostalCode();
            fnl.cZip4 = "";
            if (workString != null) {
                if (workString.length() < 6) {
                    fnl.cZip = this.setFnlContent(workString);
                } else if (workString.length() == 9) {
                    fnl.cZip = this.setFnlContent(workString.substring(0, 5));
                    fnl.cZip4 = this.setFnlContent(workString.substring(5, 9));
                } else if (workString.length() == 10) {
                    fnl.cZip = this.setFnlContent(workString.substring(0, 5));
                    fnl.cZip4 = this.setFnlContent(workString.substring(6, 10));
                }
            }
            if (address.getPostalCode2().length() != 0) {
                fnl.cZip4 = this.setFnlContent(address.getPostalCode2());
            }
            fnl.cInputAddressType = " ";
        }
        if (this.pbfnljni.getActive()) {
            address.setAddressLine1(fnl.cAddress1);
            address.setAddressLine2(fnl.cAddress2);
            address.setCity(fnl.cCity);
            address.setStateProvince(fnl.cState);
            address.setPostalCode(fnl.cZip);
            address.setPostalCode2(fnl.cZip4);
            String s = this.pbfnljni.codeAddress(fnl);
            if (s.length() != 0) {
                throw new ValidationException("US Processing Failed: " + s, ExceptionCode.GLOBAL_ADDRESSING_EXCEPTION);
            }
            return new ValidationResponse(null, null, preferences, address, fnl, data);
        }
        return new ValidationResponse(null, null, null, address, fnl, data);
    }

    private String setFnlContent(String data) {
        return data == null ? "" : data;
    }

    private static boolean isValidDataDirectory(File file, String fileName) {
        File file1 = new File(file.getAbsolutePath() + "/" + fileName);
        boolean isthere = false;
        if (file1.exists()) {
            isthere = true;
        }
        return isthere;
    }

    private boolean isUSAteritory(String country) {
        String[] list = new String[]{"USA", "ASM", "FSM", "GUM", "MNP", "PLW", "PRI", "RMI", "UNITED STATES VIRGIN ISLANDS", "VIR"};
        for (int i = 0; i < list.length; ++i) {
            if (!country.equalsIgnoreCase(list[i])) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Map<String, Object>> getCandidate(HashMap<String, String> optionsMap, HashMap<String, String> addrMap) throws ValidationException {
        ArrayList<Map<String, Object>> resultList = null;
        if (this.pbfnljni != null) {
            PBFnlAddressData db = new PBFnlAddressData();
            PBFnlCandidate[] records = this.pbfnljni.getCandidate(db);
            resultList = this.getCandidateList(records);
        }
        return resultList;
    }

    private ArrayList<Map<String, Object>> getCandidateList(PBFnlCandidate[] records) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (records == null) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.clear();
            data.put("Status", "N");
            data.put("Status.Code", "No match found");
            data.put("Status.Description", "No results found");
            resultList.add(data);
            return resultList;
        }
        int n = 0;
        PBFnlCandidate[] pBFnlCandidateArray = records;
        int n2 = pBFnlCandidateArray.length;
        if (n < n2) {
            PBFnlCandidate record = pBFnlCandidateArray[n];
            HashMap<String, String> data = new HashMap<String, String>();
            data.clear();
            data.put("Street", record.streetName);
            resultList.add(data);
            return resultList;
        }
        return resultList;
    }

    public ArrayList<Map<String, Object>> dbLookup(HashMap<String, String> optionsMap, HashMap<String, String> addrMap) throws ValidationException {
        ArrayList<Map<String, Object>> resultList = null;
        if (this.pbfnljni != null) {
            PBFnlDatabase db = new PBFnlDatabase();
            db.lastline = addrMap.get("LastLine").toUpperCase();
            db.streetName = addrMap.get("StreetName").toUpperCase();
            db.rangeLow = addrMap.get("HouseNumber").toUpperCase();
            db.aptNumber = addrMap.get("ApartmentNumber").toUpperCase();
            db.setMaxCandidates(Integer.parseInt(optionsMap.get("MaxCandidates")));
            db.setJniOpts("com/pb/addressing/api/PBFnlDatabase");
            this.initFinalistEngine(null, this.usDictionaryPath);
            PBFnlDatabase[] dbRecords = this.pbfnljni.databaseLookup(db);
            resultList = this.getResultList(dbRecords, db.opts);
        }
        return resultList;
    }

    private ArrayList<Map<String, Object>> getResultList(PBFnlDatabase[] dbRecords, int opts) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (dbRecords == null) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.clear();
            data.put("Status", "N");
            data.put("Status.Code", "No match found");
            data.put("Status.Description", "No results found");
            resultList.add(data);
            return resultList;
        }
        block7: for (PBFnlDatabase record : dbRecords) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.clear();
            switch (opts) {
                case 0: {
                    data.put("City", record.cityName);
                    data.put("State", record.stateAbbreviation);
                    data.put("ZIP", record.zipcode);
                    if (!record.preferredCity.isEmpty()) {
                        data.put("PreferredCity", record.preferredCity);
                    } else {
                        data.put("PreferredCity", "");
                    }
                    if (record.mailingInd == 1) {
                        data.put("MailingIndicator", "MAILING");
                    } else if (record.mailingInd == 2) {
                        data.put("MailingIndicator", "NON-MAILING");
                    } else {
                        data.put("MailingIndicator", "UNKNOWN");
                    }
                    resultList.add(data);
                    continue block7;
                }
                case 1: {
                    data.put("City", record.cityName);
                    data.put("State", record.stateAbbreviation);
                    data.put("ZIP", record.zipcode);
                    resultList.add(data);
                    continue block7;
                }
                case 2: 
                case 6: {
                    data.put("Street", record.streetName);
                    resultList.add(data);
                    continue block7;
                }
                case 3: 
                case 7: {
                    data.put("Street", record.streetName);
                    data.put("RangeLow", record.rangeLow);
                    data.put("RangeHigh", record.rangeHi);
                    if (!record.preDir.isEmpty()) {
                        data.put("PreDirectional", record.preDir);
                    } else {
                        data.put("PreDirectional", "");
                    }
                    if (!record.posDir.isEmpty()) {
                        data.put("PostDirectional", record.posDir);
                    } else {
                        data.put("PostDirectional", "");
                    }
                    if (!record.suffix.isEmpty()) {
                        data.put("Suffix", record.suffix);
                    } else {
                        data.put("Suffix", "");
                    }
                    data.put("CRRT", record.carrRte);
                    data.put("EOB", record.eob);
                    data.put("ZIP4Low", record.zip4Low);
                    data.put("ZIP4High", record.zip4Hi);
                    data.put("ZIP", record.zipcode);
                    if (!record.urbname.isEmpty()) {
                        data.put("CitySubdivision", record.urbname);
                    } else {
                        data.put("CitySubdivision", "");
                    }
                    if (!record.alternate.isEmpty()) {
                        data.put("Alternate", record.alternate);
                    } else {
                        data.put("Alternate", "");
                    }
                    if (record.lSecRangeCnt > 0) {
                        data.put("Secondaries", "Y");
                    } else {
                        data.put("Secondaries", "");
                    }
                    if (record.lFirmCnt > 0) {
                        data.put("Firm", record.firm);
                        data.put("FirmPlus4", record.firmzip4);
                    } else {
                        data.put("Firm", "");
                        data.put("FirmPlus4", "");
                    }
                    if (!record.alias.isEmpty()) {
                        data.put("Alias", "Y");
                    } else {
                        data.put("Alias", "");
                    }
                    if (!record.multipleP4.isEmpty()) {
                        data.put("MultipleZIPP4", "Y");
                    } else {
                        data.put("MultipleZIPP4", "");
                    }
                    resultList.add(data);
                    continue block7;
                }
                case 4: 
                case 8: {
                    data.put("RangeLow", record.rangeLow);
                    data.put("RangeHigh", record.rangeHi);
                    data.put("Unit", record.unit);
                    data.put("CRRT", record.carrRte);
                    data.put("EOB", record.eob);
                    data.put("ZIP4Low", record.zip4Low);
                    data.put("ZIP4High", record.zip4Hi);
                    if (record.lFirmCnt > 0) {
                        data.put("Firm", record.firm);
                        data.put("FirmPlus4", record.firmzip4);
                    } else {
                        data.put("Firm", record.firm);
                        data.put("FirmPlus4", record.firmzip4);
                    }
                    if (!record.multipleP4.isEmpty()) {
                        data.put("MultipleZIPP4", "Y");
                    } else {
                        data.put("MultipleZIPP4", "");
                    }
                    resultList.add(data);
                }
            }
        }
        return resultList;
    }
}

