/*
 * Decompiled with CFR 0.152.
 */
package com.pb.addressing.api;

import java.io.Serializable;

public class PBFnlDatabase
implements Serializable {
    public int POB_MODE = 0;
    public int STREET_MODE = 1;
    public int RR_MODE = 2;
    public int mode;
    public int opts;
    public String lastline;
    public int LLCount;
    public String streetName;
    public String preferredCity;
    public int mailingInd;
    public int zipType;
    public String zipcode;
    public String cityName;
    public String stateAbbreviation;
    public String countyName;
    public String rangeLow;
    public String rangeHi;
    public String preDir;
    public String posDir;
    public String suffix;
    public String carrRte;
    public String eob;
    public String zip4Low;
    public String zip4Hi;
    public int lSecRangeCnt;
    public String alias;
    public String urbname;
    public String alternate;
    public String unit;
    public String multipleP4;
    public int lFirmCnt;
    public String firm;
    public String firmzip4;
    public String javaObjPath;
    public String aptNumber;

    public PBFnlDatabase() {
        this.init();
    }

    public void init() {
        this.javaObjPath = "PBFnlDatabase";
        this.mode = 1;
        this.LLCount = 100;
        this.preferredCity = new String("");
        this.mailingInd = 32;
        this.zipType = 3;
        this.zipcode = new String("");
        this.cityName = new String("");
        this.countyName = new String("");
        this.stateAbbreviation = new String("");
        this.streetName = new String("");
        this.rangeLow = new String("");
        this.rangeHi = new String("");
        this.preDir = new String("");
        this.posDir = new String("");
        this.suffix = new String("");
        this.carrRte = new String("");
        this.eob = new String("");
        this.zip4Low = new String("");
        this.zip4Hi = new String("");
        this.unit = new String("");
        this.urbname = new String("");
        this.alternate = new String("");
        this.alias = new String("");
        this.multipleP4 = new String("");
        this.firm = new String("");
        this.firmzip4 = new String("");
        this.lastline = new String("");
        this.aptNumber = new String("");
    }

    private boolean isNumeric(String s) {
        return s != null && s.matches("[-+]?\\d*\\.?\\d+");
    }

    public void setMaxCandidates(int maxCandidates) {
        this.LLCount = maxCandidates;
    }

    public int setJniOpts(String path) {
        this.javaObjPath = path;
        this.opts = -1;
        int lastLinelen = this.lastline.length();
        if (lastLinelen > 0 && lastLinelen <= 5 && this.isNumeric(this.lastline)) {
            this.cityName = "";
            this.stateAbbreviation = "";
        } else {
            this.cityName = this.lastline.replace(',', ' ');
            String lastWord = this.lastline.substring(this.cityName.lastIndexOf(" ") + 1);
            if (lastWord.length() != this.cityName.length() && lastWord.length() == 2) {
                this.stateAbbreviation = lastWord;
                this.cityName = this.cityName.substring(0, this.lastline.length() - 3);
                this.cityName = this.cityName.trim();
            }
            this.lastline = "";
        }
        if (lastLinelen > 0 && this.streetName.length() == 0 && this.rangeLow.length() == 0) {
            if (lastLinelen <= 4 && this.isNumeric(this.lastline)) {
                this.opts = 1;
            } else {
                this.opts = 0;
                if (this.cityName.length() != 0 || this.stateAbbreviation.length() != 0) {
                    this.lastline = this.cityName + " " + this.stateAbbreviation;
                    this.lastline.trim();
                }
            }
        } else if (lastLinelen > 0 && this.streetName.length() != 0 && this.rangeLow.length() == 0) {
            this.opts = lastLinelen == 5 && this.isNumeric(this.lastline) ? 2 : 6;
            if (this.streetName.equals("*")) {
                this.streetName = "";
            }
        } else if (lastLinelen > 0 && this.streetName.length() != 0 && this.rangeLow.length() != 0 && this.aptNumber.length() == 0) {
            this.opts = lastLinelen == 5 && this.isNumeric(this.lastline) ? 3 : 7;
            this.mode = this.whichMode(this.streetName);
            if (this.rangeLow.equals("*")) {
                this.rangeLow = "";
            }
        } else if (lastLinelen > 0 && this.streetName.length() != 0 && this.rangeLow.length() != 0 && this.aptNumber.length() != 0) {
            this.opts = lastLinelen == 5 && this.isNumeric(this.lastline) ? 4 : 8;
            if (this.aptNumber.equals("*")) {
                this.aptNumber = "";
            }
        } else {
            this.opts = 0;
        }
        return this.opts;
    }

    private int whichMode(String streetName) {
        if (streetName.compareTo("PO BOX") == 0) {
            return this.POB_MODE;
        }
        String[] a = streetName.split(" ");
        if (a.length == 2 && (a[0].compareTo("RR") == 0 || a[0].compareTo("HC") == 0)) {
            return this.RR_MODE;
        }
        return this.STREET_MODE;
    }

    public void dumpData(PBFnlDatabase[] records) {
        if (records != null) {
            for (PBFnlDatabase record : records) {
                System.out.println("");
                System.out.println("record.opts:              " + record.opts);
                System.out.println("record.lastline:          " + record.lastline);
                System.out.println("record.LLCount:           " + record.LLCount);
                System.out.println("record.streetName:        " + record.streetName);
                System.out.println("record.preferredCity:     " + record.preferredCity);
                System.out.println("record.mailingInd:        " + record.mailingInd);
                System.out.println("record.zipType:           " + record.zipType);
                System.out.println("record.zipcode:           " + record.zipcode);
                System.out.println("record.cityName:          " + record.cityName);
                System.out.println("record.stateAbbreviation: " + record.stateAbbreviation);
                System.out.println("record.countyName:        " + record.countyName);
                System.out.println("record.rangeLow:          " + record.rangeLow);
                System.out.println("record.rangeHi:           " + record.rangeHi);
                System.out.println("record.preDir:            " + record.preDir);
                System.out.println("record.posDir:            " + record.posDir);
                System.out.println("record.suffix:            " + record.suffix);
                System.out.println("record.carrRte:           " + record.carrRte);
                System.out.println("record.eob:               " + record.eob);
                System.out.println("record.zip4Low:           " + record.zip4Low);
                System.out.println("record.zip4Low:           " + record.zip4Low);
                System.out.println("record.lSecRangeCnt:      " + record.lSecRangeCnt);
                System.out.println("record.alias:             " + record.alias);
                System.out.println("record.urbname:           " + record.urbname);
                System.out.println("record.alternate:         " + record.alternate);
                System.out.println("record.unit:              " + record.unit);
                System.out.println("record.multipleP4:        " + record.multipleP4);
                System.out.println("record.lFirmCnt:          " + record.lFirmCnt);
                System.out.println("record.firm:              " + record.firm);
                System.out.println("record.firmzip4:          " + record.firmzip4);
            }
        }
    }
}

