/*
 * Decompiled with CFR 0.152.
 */
package com.pb.addressing.api;

import com.mapinfo.geocode.api.Candidate;
import com.mapinfo.geocode.api.CapabilitiesResponse;
import com.mapinfo.geocode.api.Response;
import com.pb.addressing.CandidateCase;
import com.pb.addressing.ValidationException;
import com.pb.addressing.api.Address;
import com.pb.addressing.api.PBFnlAddressData;
import com.pb.addressing.api.Preferences;
import com.pb.addressing.api.ResponseAPI;
import com.pb.addressing.api.ValidatedCandidate;
import com.pb.addressing.util.ValidationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ValidationResponse
implements ResponseAPI {
    public static final String ADDRESSLINE1_INPUT = "AddressLine1.Input";
    public static final String ADDRESSLINE2_INPUT = "AddressLine2.Input";
    public static final String CITY_INPUT = "City.Input";
    public static final String CITYSUBDIVISION_INPUT = "CitySubdivision.Input";
    public static final String STATEPROVINCE_INPUT = "StateProvince.Input";
    public static final String STATEPROVINCESUBDIVISION_INPUT = "StateProvinceSubdivision.Input";
    public static final String POSTALCODE_INPUT = "PostalCode.Input";
    public static final String COUNTRY_INPUT = "Country.Input";
    public static final String FIRMNAME_INPUT = "FirmName.Input";
    public static final String PARSEDHOUSENUMBER_INPUT = "ParsedHouseNumber.Input";
    public static final String PARSEDADDRESSLINE1_INPUT = "ParsedAddressLine1.Input";
    public static final String PARSEDPRESTREETTYPE_INPUT = "ParsedPreStreetType.Input";
    public static final String PARSEDPOSTSTREETTYPE_INPUT = "ParsedPostStreetType.Input";
    public static final String PARSEDAPARTMENTLABEL_INPUT = "ParsedApartmentLabel.Input";
    public static final String PARSEDAPARTMENTNUMBER_INPUT = "ParsedApartmentNumber.Input";
    public static final String PARSEDPLACENAME_INPUT = "ParsedPlaceName.Input";
    public static final String PARSEDPOSTCODEADDON_INPUT = "ParsedPostCodeAddOn.Input";
    public static final String PARSEDSTATEPROVINCE_INPUT = "ParsedStateProvince.Input";
    public static final String PARSEDSTATEPROVINCESUBDIVISION_INPUT = "ParsedStateProvinceSubdivision.Input";
    public static final String PARSEDCITY_INPUT = "ParsedCity.Input";
    public static final String PARSEDPOSTCODEBASE_INPUT = "ParsedPostCodeBase.Input";
    public static final String PARSEDCITYSUBDIVISION_INPUT = "ParsedCitySubDivision.Input";
    public static final String PARSEDCOUNTRY_INPUT = "ParsedCountry.Input";
    public static final String DUALADDRESSPARSED_INPUT = "DualAddressParsed.Input";
    public static final String DUAL_ADDRESS_PARSED_STREET = "DualAddressParsedStreet";
    public static final String DUAL_ADDRESS_PARSED_POBOX = "DualAddressParsedPOBox";
    public static final String PARSED_FORMATTEDINPUTSTREET = "FormattedInputStreet";
    public static final String ADDITIONALINPUTDATA = "AdditionalInputData";
    Response georesponse;
    List<ValidatedCandidate> validatedCandidatelist;
    CapabilitiesResponse capabilitiesResponse;
    Preferences preferences;
    Address address;
    int fnlCount = 0;

    public ValidationResponse(Response georesponse, CapabilitiesResponse capabilitiesResponse, Preferences preferences, Address address, PBFnlAddressData fnl, Map<String, String> data) throws ValidationException {
        this.georesponse = georesponse;
        this.capabilitiesResponse = capabilitiesResponse;
        this.preferences = preferences;
        ArrayList<ValidatedCandidate> candidatelist = new ArrayList<ValidatedCandidate>();
        candidatelist.add(new ValidatedCandidate(preferences, fnl, data));
        this.address = address;
        this.validatedCandidatelist = candidatelist;
        this.fnlCount = 1;
    }

    public ValidationResponse(Response georesponse, CapabilitiesResponse capabilitiesResponse, Preferences preferences, Address address) throws ValidationException {
        this.georesponse = georesponse;
        this.capabilitiesResponse = capabilitiesResponse;
        this.preferences = preferences;
        this.address = address;
        this.fnlCount = 0;
        this.validatedCandidatelist = this.populateCandidateList(georesponse, preferences, address, capabilitiesResponse);
    }

    @Override
    public List<ValidatedCandidate> getCandidates() {
        return this.validatedCandidatelist;
    }

    @Override
    public int getMultimatchCount() {
        if (this.georesponse == null && this.fnlCount == 1) {
            return this.fnlCount;
        }
        return this.georesponse.getCandidates() == null ? 0 : this.georesponse.getCandidates().size();
    }

    private Map<String, String> getInputAddress(Address address) {
        HashMap<String, String> candidatemap = new HashMap<String, String>();
        candidatemap.put(ADDRESSLINE1_INPUT, address.getAddressLine1());
        candidatemap.put(ADDRESSLINE2_INPUT, address.getAddressLine2());
        candidatemap.put(CITY_INPUT, address.getCity());
        candidatemap.put(CITYSUBDIVISION_INPUT, address.getCitySubdivision());
        candidatemap.put(STATEPROVINCE_INPUT, address.getStateProvince());
        candidatemap.put(STATEPROVINCESUBDIVISION_INPUT, address.getStateProvinceSubdivision());
        candidatemap.put(POSTALCODE_INPUT, address.getPostalCode());
        candidatemap.put(COUNTRY_INPUT, address.getCountry());
        candidatemap.put(FIRMNAME_INPUT, address.getFirmName());
        ValidationUtils.removeEmptyValues(candidatemap);
        return candidatemap;
    }

    private List<ValidatedCandidate> populateCandidateList(Response georesponse, Preferences preferences, Address address, CapabilitiesResponse capabilitiesResponse) throws ValidationException {
        ArrayList<ValidatedCandidate> candidatelist = null;
        if (georesponse != null) {
            Iterator it = georesponse.getCandidates().iterator();
            candidatelist = new ArrayList<ValidatedCandidate>();
            while (it.hasNext()) {
                Candidate type = (Candidate)it.next();
                candidatelist.add(new ValidatedCandidate(type, georesponse, capabilitiesResponse, preferences, address));
            }
        }
        return candidatelist;
    }

    @Override
    public Map<String, String> getParsedInput() {
        Map<String, String> parsedinputmap = new HashMap<String, String>();
        if (this.preferences != null && this.preferences.isReturnParsedInputAddress()) {
            parsedinputmap = this.getParsedInputMap();
            ValidationUtils.convertToPreferedCase(parsedinputmap, (CandidateCase)this.preferences.getCandidateCasing(), ValidationUtils.getISO3Country(this.address.getCountry()));
        }
        return parsedinputmap;
    }

    private Map<String, String> getParsedInputMap() {
        HashMap<String, String> parsedinputmap = new HashMap<String, String>();
        if (this.georesponse != null) {
            parsedinputmap.put(PARSEDHOUSENUMBER_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_ADDRESS_NUMBER"));
            parsedinputmap.put(PARSEDADDRESSLINE1_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_STREET_NAME"));
            parsedinputmap.put(PARSEDPRESTREETTYPE_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_STREET_PRE_TYPE"));
            parsedinputmap.put(PARSEDPOSTSTREETTYPE_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_STREET_POST_TYPE"));
            parsedinputmap.put(PARSEDAPARTMENTLABEL_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_UNIT_TYPE"));
            parsedinputmap.put(PARSEDAPARTMENTNUMBER_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_UNIT_VALUE"));
            parsedinputmap.put(PARSEDPLACENAME_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_PLACE_NAME"));
            parsedinputmap.put(PARSEDPOSTCODEADDON_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_POST_CODE_2"));
            parsedinputmap.put(PARSEDSTATEPROVINCE_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_AREA_NAME_1"));
            parsedinputmap.put(PARSEDSTATEPROVINCESUBDIVISION_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_AREA_NAME_2"));
            parsedinputmap.put(PARSEDCITY_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_AREA_NAME_3"));
            parsedinputmap.put(PARSEDPOSTCODEBASE_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_POST_CODE_1"));
            parsedinputmap.put(PARSEDCITYSUBDIVISION_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_AREA_NAME_4"));
            parsedinputmap.put(PARSEDCOUNTRY_INPUT, this.georesponse.getCustomFieldValue("PARSED_INPUT_COUNTRY"));
            String dualinput = this.isStringEmpty(this.georesponse.getCustomFieldValue(DUAL_ADDRESS_PARSED_STREET)) ? this.georesponse.getCustomFieldValue(DUAL_ADDRESS_PARSED_POBOX) : this.georesponse.getCustomFieldValue(DUAL_ADDRESS_PARSED_STREET);
            parsedinputmap.put(DUALADDRESSPARSED_INPUT, dualinput);
            parsedinputmap.put(PARSED_FORMATTEDINPUTSTREET, this.georesponse.getCustomFieldValue(PARSED_FORMATTEDINPUTSTREET));
            parsedinputmap.put(ADDITIONALINPUTDATA, this.georesponse.getCustomFieldValue("PARSED_INPUT_GENERIC_FIELD_1"));
            ValidationUtils.removeEmptyValues(parsedinputmap);
        }
        return parsedinputmap;
    }

    @Override
    public Map<String, String> getInputAddress() {
        Map<String, String> candidatemap = new HashMap<String, String>();
        if (this.preferences != null && this.preferences.isReturnInputAddress()) {
            candidatemap = this.getInputAddress(this.address);
            ValidationUtils.convertToPreferedCase(candidatemap, (CandidateCase)this.preferences.getCandidateCasing(), ValidationUtils.getISO3Country(this.address.getCountry()));
        }
        return candidatemap;
    }

    private boolean isStringEmpty(Object value) {
        return null == value || !(value instanceof String) || value instanceof String && ("".equals(value) || ((String)value).isEmpty());
    }
}

