/*
 * Decompiled with CFR 0.152.
 */
package com.pb.addressing.confidence;

import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.Candidate;
import com.mapinfo.geocode.api.CapabilitiesResponse;
import com.mapinfo.geocode.api.FieldsMatching;
import com.pb.addressing.api.Preferences;
import com.pb.addressing.confidence.Confidence;
import com.pb.addressing.confidence.ConfidenceContext;
import java.util.Map;

public abstract class AbstractConfidence
implements Confidence {
    private static final String[] confidenceStrings = new String[101];
    protected ConfidenceContext confidenceContext = new ConfidenceContext();

    private static String getConfidenceString(int confidence) {
        if (confidence >= 0 && confidence <= 100) {
            return confidenceStrings[confidence];
        }
        return "Invalid confidence: " + confidence;
    }

    @Override
    public String getConfidence(Map<String, String> parsedInputAddressMap, Candidate candidate, Preferences preferences, CapabilitiesResponse capabilitiesResponse) {
        float fConfidence = this.getConfidenceValue(parsedInputAddressMap, candidate, preferences, capabilitiesResponse);
        int iConfidence = (int)(fConfidence * 100.0f);
        String sConfidence = AbstractConfidence.getConfidenceString(iConfidence);
        return sConfidence;
    }

    private float getConfidenceValue(Map<String, String> parsedInputAddressMap, Candidate candidate, Preferences preferences, CapabilitiesResponse capabilitiesResponse) {
        float fConfidence = 0.0f;
        float fProration = 1.0f;
        for (int field = 0; field < 7; ++field) {
            float weight = this.confidenceContext.getWeight(field);
            float factor = this.getFactor(field, candidate.getPrecisionCode(), candidate.getMatchedFields(), parsedInputAddressMap, candidate.getAddress(), preferences, capabilitiesResponse);
            if (factor < 0.0f) {
                fProration -= weight;
                continue;
            }
            fConfidence += weight * factor;
        }
        if (fProration < 1.0f) {
            fConfidence = -1.0E-7f < fProration && fProration < 1.0E-7f ? 1.0f : (fConfidence /= fProration);
        }
        return fConfidence;
    }

    protected abstract float getFactor(int var1, String var2, FieldsMatching var3, Map<String, String> var4, Address var5, Preferences var6, CapabilitiesResponse var7);

    static {
        for (int i = 0; i <= 100; ++i) {
            AbstractConfidence.confidenceStrings[i] = Integer.toString(i);
        }
    }
}

