/*
 * Decompiled with CFR 0.152.
 */
package com.pb.addressing.confidence;

import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.CapabilitiesResponse;
import com.mapinfo.geocode.api.FieldsMatching;
import com.mapinfo.geocode.api.Operation;
import com.mapinfo.geocode.api.SupportLevelDescriptor;
import com.pb.addressing.api.Preferences;
import com.pb.addressing.confidence.AbstractConfidence;
import com.pb.addressing.confidence.ConfidenceFieldStatus;
import com.pb.addressing.confidence.CountryFieldNoSupported;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ValidationConfidence
extends AbstractConfidence {
    boolean supportLevelFlag = false;

    @Override
    protected float getFactor(int field, String precisionCode, FieldsMatching fieldsMatchingMap, Map<String, String> parsedInputAddressMap, Address address, Preferences preferences, CapabilitiesResponse capabilitiesResponse) {
        int outcome = 3;
        Integer supportedLevel = 0;
        if (capabilitiesResponse != null && !capabilitiesResponse.getSupportedOperations().isEmpty()) {
            supportedLevel = ((SupportLevelDescriptor)((Operation)capabilitiesResponse.getSupportedOperations().get(0)).getLevelsOfSupport().get(0)).getSupportedDataLevel();
        }
        if (fieldsMatchingMap != null) {
            ConfidenceFieldStatus confidenceFieldStatus = new ConfidenceFieldStatus();
            switch (field) {
                case 0: {
                    if (parsedInputAddressMap.size() == 0) break;
                    if (CountryFieldNoSupported.isFieldNotSupported(address.getCountry(), 0)) {
                        outcome = -1;
                        break;
                    }
                    outcome = confidenceFieldStatus.getStateStatus(fieldsMatchingMap, parsedInputAddressMap, address);
                    break;
                }
                case 1: {
                    outcome = confidenceFieldStatus.getCountyStatus(fieldsMatchingMap, parsedInputAddressMap, address);
                    break;
                }
                case 2: {
                    outcome = confidenceFieldStatus.getCityStatus(precisionCode, fieldsMatchingMap, parsedInputAddressMap, address);
                    break;
                }
                case 3: {
                    if (address == null) break;
                    if (CountryFieldNoSupported.isFieldNotSupported(address.getCountry(), 3)) {
                        outcome = -1;
                        break;
                    }
                    outcome = confidenceFieldStatus.getPostalCodeStatus(precisionCode, fieldsMatchingMap, parsedInputAddressMap, address);
                    break;
                }
                case 4: {
                    if (supportedLevel != null && supportedLevel <= 4) {
                        this.supportLevelFlag = true;
                    }
                    outcome = confidenceFieldStatus.getStreetNameStatus(precisionCode, fieldsMatchingMap, parsedInputAddressMap, address);
                    break;
                }
                case 5: {
                    if (this.supportLevelFlag) {
                        outcome = -1;
                        break;
                    }
                    outcome = confidenceFieldStatus.getHouseNumberStatus(precisionCode, fieldsMatchingMap, parsedInputAddressMap, address);
                    break;
                }
                case 6: {
                    if (this.supportLevelFlag || StringUtils.isEmpty((String)address.getUnitValue()) || address.getUnitValue() == null) {
                        outcome = -1;
                        break;
                    }
                    outcome = confidenceFieldStatus.getApartmentNumberStatus(parsedInputAddressMap, address);
                    break;
                }
                default: {
                    outcome = 3;
                }
            }
        }
        return this.confidenceContext.getFactor(field, outcome);
    }
}

