/*
 * Decompiled with CFR 0.152.
 */
package com.pb.addressing.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mapinfo.geocode.util.ConfigurationManager;
import com.mapinfo.geocode.util.GeocodeUtils;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.pb.addressing.CandidateCase;
import com.pb.addressing.api.ValidatedCandidate;
import com.pb.addressing.util.CasingUtility;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ValidationUtils {
    public static Multimap<String, Integer> countrySpecificFieldMultiMap;
    private static Map<String, Locale> countryLocaleMap;

    private ValidationUtils() {
    }

    public static void appendNewline(StringBuilder stringBuilder) {
        GeocodeUtils.appendNewline((StringBuilder)stringBuilder);
    }

    public static void appendNonNullValues(StringBuilder stringbuilder, String label, String value) {
        GeocodeUtils.appendNonNullValues((StringBuilder)stringbuilder, (String)label, (String)value);
    }

    public static boolean canParseDouble(String arg0) {
        return GeocodeUtils.canParseDouble((String)arg0);
    }

    public static boolean canParseInt(String arg0) {
        return GeocodeUtils.canParseInt((String)arg0);
    }

    public static boolean canParseLong(String arg0) {
        return GeocodeUtils.canParseLong((String)arg0);
    }

    public static <K, V> HashMap<K, V> castHashMap(HashMap<?, ?> map, Class<K> kClass, Class<V> vClass) {
        return GeocodeUtils.castHashMap(map, kClass, vClass);
    }

    public static String getCountryName(String arg0) {
        return GeocodeUtils.getCountryName((String)arg0);
    }

    public static String getISO3Country(String arg0) {
        return GeocodeUtils.getISO3Country((String)arg0);
    }

    public static boolean isClass(String arg0) {
        return GeocodeUtils.isClass((String)arg0);
    }

    public static void orderByDictionaryType(String arg0, Properties arg1) {
        GeocodeUtils.orderByDictionaryType((String)arg0, (Properties)arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareFieldNotSupportedMap() {
        countrySpecificFieldMultiMap = ArrayListMultimap.create();
        Multimap<String, Integer> multimap = countrySpecificFieldMultiMap;
        synchronized (multimap) {
            InputStream in = ValidationUtils.class.getClass().getResourceAsStream("/noSupportedField.csv");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (line == null || line.contains("noSupportedField")) continue;
                    String[] splitLine = line.split(",");
                    if (splitLine.length > 1 && splitLine[0].trim().length() == 3 && splitLine[1].trim().length() == 1) {
                        countrySpecificFieldMultiMap.put((Object)splitLine[0].trim(), (Object)Integer.parseInt(splitLine[1].trim()));
                        continue;
                    }
                    throw new IOException("Invalid country entry at  : noSupportedField.csv");
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("File : noSupportedField.csv not found.");
            }
            catch (IOException e) {
                throw new RuntimeException("Not able to read File : noSupportedField.csv");
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Not able to close File : noSupportedField.csv");
                }
            }
        }
    }

    public static Locale getLocale(String country) {
        Locale locale;
        if (countryLocaleMap.isEmpty()) {
            ValidationUtils.createCountryLocaleMap();
            locale = countryLocaleMap.get(country);
        } else {
            locale = countryLocaleMap.get(country);
        }
        return locale;
    }

    private static Map<String, Locale> createCountryLocaleMap() {
        String[] isoCountries;
        for (String isoCountry : isoCountries = Locale.getISOCountries()) {
            Locale locale = new Locale("", isoCountry);
            if (locale == null) continue;
            countryLocaleMap.put(locale.getISO3Country(), locale);
        }
        countryLocaleMap.put("XWG", Locale.ENGLISH);
        return countryLocaleMap;
    }

    public static String getFullCountryName(String country) {
        if (country == null || country.length() == 0) {
            return country;
        }
        ISO3166 iso = ISO3166.findCountryByISO3((String)country);
        if (iso != null) {
            return iso.getDisplayCountry();
        }
        iso = ISO3166.findCountryByName((String)country);
        if (iso != null) {
            return iso.getDisplayCountry();
        }
        if (country.length() == 2 && (iso = ISO3166.findCountryByISO2((String)country)) != null) {
            return iso.getDisplayCountry();
        }
        if ((country = ConfigurationManager.getISO3CountryFromDatabase((String)country)).length() == 3 && (iso = ISO3166.findCountryByISO3((String)country)) != null) {
            return iso.getDisplayCountry();
        }
        return country;
    }

    public static void removeEmptyValues(Map<String, ?> keyvaluemap) {
        Iterator<String> keys = keyvaluemap.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            Object value = keyvaluemap.get(key);
            if (!ValidationUtils.isStringEmpty(value)) continue;
            keys.remove();
        }
    }

    private static boolean isStringEmpty(Object value) {
        return null == value || !(value instanceof String) || value instanceof String && ("".equals(value) || ((String)value).isEmpty());
    }

    public static void convertToPreferedCase(Map<String, String> candidatemap, CandidateCase casing, String country) {
        Locale locale = ValidationUtils.getLocale(country);
        if (null != casing && locale != null) {
            switch (casing) {
                case LOWER: {
                    ValidationUtils.convertToLowerCase(candidatemap, locale);
                    break;
                }
                case MIXED: {
                    ValidationUtils.convertToMixedCase(candidatemap, locale);
                    break;
                }
                default: {
                    ValidationUtils.convertToUpper(candidatemap, locale);
                }
            }
        }
    }

    private static void convertToLowerCase(Map<String, String> candidatemap, Locale locale) {
        Set<String> keys = candidatemap.keySet();
        for (String key : keys) {
            String fieldValue = candidatemap.get(key);
            if (ValidationUtils.isStringEmpty(fieldValue)) continue;
            fieldValue = ValidationUtils.doesKeyValueNeedToBeUpperCased(key, fieldValue) ? fieldValue.toUpperCase(locale) : fieldValue.toLowerCase(locale);
            candidatemap.put(key, fieldValue);
        }
    }

    private static boolean doesKeyValueNeedToBeUpperCased(String key, String value) {
        boolean breturn = false;
        if (ValidatedCandidate.CANDIDATE_ITEMS_ALWAYS_UPPER.contains(key) || value.length() <= 3) {
            breturn = true;
        }
        return breturn;
    }

    private static void convertToMixedCase(Map<String, String> candidatemap, Locale locale) {
        Set<String> keys = candidatemap.keySet();
        for (String key : keys) {
            String fieldValue = candidatemap.get(key);
            if (ValidationUtils.isStringEmpty(fieldValue)) continue;
            fieldValue = ValidationUtils.doesKeyValueNeedToBeUpperCased(key, fieldValue) ? fieldValue.toUpperCase(locale) : CasingUtility.getTitleCase(fieldValue, locale);
            candidatemap.put(key, fieldValue);
        }
    }

    private static void convertToUpper(Map<String, String> candidatemap, Locale locale) {
        Set<String> keys = candidatemap.keySet();
        for (String key : keys) {
            String fieldValue = candidatemap.get(key);
            if (ValidationUtils.isStringEmpty(fieldValue)) continue;
            fieldValue = fieldValue.toUpperCase(locale);
            candidatemap.put(key, fieldValue);
        }
    }

    static {
        countryLocaleMap = new HashMap<String, Locale>();
    }
}

