/*
 * Decompiled with CFR 0.152.
 */
package com.pb.addressing.adapter;

import com.mapinfo.geocode.GeocodeAddress;
import com.mapinfo.geocode.GeocodeMatchFields;
import com.mapinfo.geocode.ReturnFields;
import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.FieldsMatching;
import com.mapinfo.geocode.api.GeocodeType;
import com.mapinfo.geocode.api.MatchMode;
import com.mapinfo.geocode.api.ReturnFieldsDescriptor;
import com.mapinfo.geocode.api.StandardMatchMode;
import com.mapinfo.geocode.util.DefaultPreferencesProvider;
import com.pb.addressing.api.MatchFields;
import com.pb.addressing.api.Preferences;
import com.pb.addressing.api.ValidationLevel;
import com.pb.addressing.api.ValidationMatchFields;

public class AddressAdapter {
    public static Address convertFromValidateAddress(com.pb.addressing.api.Address vAddress) {
        GeocodeAddress geoAddress = new GeocodeAddress();
        if (vAddress != null) {
            geoAddress.setAddressLastLine(vAddress.getLastLine());
            geoAddress.setAreaName1(vAddress.getStateProvince());
            geoAddress.setAreaName2(vAddress.getStateProvinceSubdivision());
            geoAddress.setAreaName3(vAddress.getCity());
            geoAddress.setAreaName4(vAddress.getCitySubdivision());
            geoAddress.setCountry(vAddress.getCountry());
            if (vAddress.getAddressLine2() != null) {
                geoAddress.setMainAddressLine(vAddress.getAddressLine1() + " " + vAddress.getAddressLine2());
            } else {
                geoAddress.setMainAddressLine(vAddress.getAddressLine1());
            }
            geoAddress.setPlaceName(vAddress.getFirmName());
            geoAddress.setPostCode1(vAddress.getPostalCode());
        }
        return geoAddress;
    }

    public static GeocodeType convertFromValidationLevel(ValidationLevel level) {
        GeocodeType gtype = GeocodeType.ADDRESS;
        if (null != level) {
            switch (level) {
                case GEOGRAPHIC: {
                    gtype = GeocodeType.GEOGRAPHIC;
                    break;
                }
                case POSTAL: {
                    gtype = GeocodeType.POSTAL;
                    break;
                }
                default: {
                    gtype = GeocodeType.ADDRESS;
                }
            }
        }
        return gtype;
    }

    public static MatchMode convertToGeoMatchMode(com.pb.addressing.api.MatchMode mode) {
        if (null != mode) {
            switch ((com.pb.addressing.api.StandardMatchMode)mode) {
                case EXACT: {
                    return StandardMatchMode.EXACT;
                }
                case RELAXED: {
                    return StandardMatchMode.RELAXED;
                }
                case CUSTOM: {
                    return StandardMatchMode.CUSTOM;
                }
            }
            return StandardMatchMode.RELAXED;
        }
        return StandardMatchMode.RELAXED;
    }

    public static com.pb.addressing.api.MatchMode convertFromGeoMatchMode(MatchMode mode) {
        if (null != mode) {
            switch ((StandardMatchMode)mode) {
                case EXACT: {
                    return com.pb.addressing.api.StandardMatchMode.EXACT;
                }
                case RELAXED: {
                    return com.pb.addressing.api.StandardMatchMode.RELAXED;
                }
                case CUSTOM: {
                    return com.pb.addressing.api.StandardMatchMode.CUSTOM;
                }
            }
            return com.pb.addressing.api.StandardMatchMode.RELAXED;
        }
        return com.pb.addressing.api.StandardMatchMode.RELAXED;
    }

    public static MatchFields convertFromGeoFieldsMatching(FieldsMatching geofldsMatching) {
        ValidationMatchFields fldsMatching = new ValidationMatchFields();
        fldsMatching.setMatchOnHouseNumber(geofldsMatching.isMatchOnAddressNumber());
        fldsMatching.setMatchOnAllStreetFields(geofldsMatching.isMatchOnAllStreetFields());
        fldsMatching.setMatchOnStateProvince(geofldsMatching.isMatchOnAreaName1());
        fldsMatching.setMatchOnStateProvinceSubdivision(geofldsMatching.isMatchOnAreaName2());
        fldsMatching.setMatchOnCity(geofldsMatching.isMatchOnAreaName3());
        fldsMatching.setMatchOnCitySubdivision(geofldsMatching.isMatchOnAreaName4());
        fldsMatching.setMatchOnFirmName(geofldsMatching.isMatchOnPlaceName());
        fldsMatching.setMatchOnPostalCode(geofldsMatching.isMatchOnPostCode1());
        fldsMatching.setMatchOnPostalCode2(geofldsMatching.isMatchOnPostCode2());
        fldsMatching.setMatchOnStreetDirectional(geofldsMatching.isMatchOnStreetDirectional());
        fldsMatching.setMatchOnStreetType(geofldsMatching.isMatchOnStreetType());
        fldsMatching.setMatchOnStreetName(geofldsMatching.isMatchOnStreetName());
        return fldsMatching;
    }

    public static FieldsMatching convertToGeoFieldsMatching(MatchFields fldsMatching) {
        GeocodeMatchFields geofldsMatching = new GeocodeMatchFields();
        geofldsMatching.setMatchOnAddressNumber(fldsMatching.isMatchOnHouseNumber());
        geofldsMatching.setMatchOnAllStreetFields(fldsMatching.isMatchOnAllStreetFields());
        geofldsMatching.setMatchOnAreaName1(fldsMatching.isMatchOnStateProvince());
        geofldsMatching.setMatchOnAreaName2(fldsMatching.isMatchOnStateProvinceSubdivision());
        geofldsMatching.setMatchOnAreaName3(fldsMatching.isMatchOnCity());
        geofldsMatching.setMatchOnAreaName4(fldsMatching.isMatchOnCitySubdivision());
        geofldsMatching.setMatchOnPlaceName(fldsMatching.isMatchOnFirmName());
        geofldsMatching.setMatchOnPostCode1(fldsMatching.isMatchOnPostalCode());
        geofldsMatching.setMatchOnPostCode2(fldsMatching.isMatchOnPostalCode2());
        geofldsMatching.setMatchOnStreetDirectional(fldsMatching.isMatchOnStreetDirectional());
        geofldsMatching.setMatchOnStreetType(fldsMatching.isMatchOnStreetType());
        geofldsMatching.setMatchOnStreetName(fldsMatching.isMatchOnStreetName());
        return geofldsMatching;
    }

    public static com.mapinfo.geocode.api.Preferences convertFromValidationPreferences(Preferences vPreferences) {
        com.mapinfo.geocode.api.Preferences geoPrefs = DefaultPreferencesProvider.getInstance().getDefaultPreferences();
        if (vPreferences != null) {
            geoPrefs.setMaxReturnedCandidates(vPreferences.getMaxReturnedCandidates());
            geoPrefs.setClientLocale(vPreferences.getClientLocale());
            geoPrefs.addCustomPreference("PREFER_POBOX_OVER_STREET", Boolean.toString(vPreferences.isPreferPOBoxOverStreet()));
            geoPrefs.addCustomPreference("RETURN_PARSED_INPUT", Boolean.toString(true));
            geoPrefs.addCustomPreference("FALLBACK_TO_WORLD", Boolean.toString(vPreferences.isFallBackToWorld()));
            geoPrefs.addCustomPreference("KEY_POSTAL_CODE_OVERRIDE", Boolean.toString(vPreferences.isPreferPostCodeOverCity()));
            geoPrefs.setFallbackToGeographic(vPreferences.isFallbackToGeographic());
            geoPrefs.setFallbackToPostal(vPreferences.isFallbackToPostal());
            geoPrefs.setMatchMode(AddressAdapter.convertToGeoMatchMode(vPreferences.getMatchMode()));
            geoPrefs.setMaxReturnedCandidates(vPreferences.getMaxReturnedCandidates());
            geoPrefs.setMustMatchFields(AddressAdapter.convertToGeoFieldsMatching(vPreferences.getMustMatchFields()));
            geoPrefs.setMaxReturnedRangeUnits(vPreferences.getMaxReturnedRangeUnits());
            geoPrefs.setPreferredDictionaryOrder(vPreferences.getPreferredDictionaryOrder());
            ReturnFields returnfields = new ReturnFields();
            returnfields.setReturnAllCustomFields(vPreferences.isReturnCountrySpecificFields());
            returnfields.setReturnStreetAddressFields(true);
            returnfields.setReturnMatchDescriptor(true);
            returnfields.setReturnUnitInformation(vPreferences.isReturnUnitInfo());
            geoPrefs.setReturnFieldsDescriptor((ReturnFieldsDescriptor)returnfields);
        }
        return geoPrefs;
    }
}

