/*
 * Decompiled with CFR 0.152.
 */
package com.pb.addressing.api;

import com.pb.addressing.api.PBFnl3553Data;
import com.pb.addressing.api.PBFnlAddressData;
import com.pb.addressing.api.PBFnlCandidate;
import com.pb.addressing.api.PBFnlDatabase;
import com.pb.addressing.api.PBFnlSetupData;
import com.pb.addressing.api.Preferences;
import java.util.HashMap;

public class PBFnlAPI {
    private int mode = 0;
    private boolean isFNLActive = false;
    private PBFnlSetupData setupObj = null;

    private native int FNLstartEngine(PBFnlSetupData var1);

    private native int FNLstopEngine(PBFnl3553Data var1, int var2);

    private native int FNLcode(PBFnlAddressData var1);

    private native PBFnlDatabase[] fnlDBLookup(PBFnlDatabase var1);

    public native PBFnlCandidate[] fnlGetCandidate(PBFnlAddressData var1);

    public PBFnlDatabase[] databaseLookup(PBFnlDatabase db) {
        return this.fnlDBLookup(db);
    }

    public PBFnlCandidate[] getCandidate(PBFnlAddressData d) {
        return this.fnlGetCandidate(d);
    }

    public String codeAddress(PBFnlAddressData fnl) {
        if (this.FNLcode(fnl) != -1) {
            return "";
        }
        return fnl.cMessageCode;
    }

    public boolean getActive() {
        return this.isFNLActive;
    }

    public HashMap<String, String> getInfo(String spdPath) {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        this.initFnlEngine(null, spdPath);
        this.setupObj.setOptionsOut(infoMap);
        this.deinitEngine(false);
        return infoMap;
    }

    public HashMap<String, String> getInfo(Preferences preferences, String spdPath) {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        this.initFnlEngine(preferences, spdPath);
        this.setupObj.setOptionsOut(infoMap);
        this.deinitEngine(false);
        return infoMap;
    }

    public String initFnlEngine(Preferences preferences, String path) {
        if (this.isFNLActive) {
            return "";
        }
        this.setupObj = preferences != null ? new PBFnlSetupData(preferences, path) : new PBFnlSetupData(1, path);
        if (this.FNLstartEngine(this.setupObj) == -1) {
            return this.setupObj.cMessageCode;
        }
        this.isFNLActive = true;
        this.mode = this.setupObj.initMode;
        return "";
    }

    public HashMap<String, Object> deinitEngine(boolean b) {
        if (this.isFNLActive) {
            this.isFNLActive = false;
            if (b) {
                PBFnl3553Data rpt = new PBFnl3553Data();
                this.FNLstopEngine(rpt, this.mode);
                return rpt.get3553();
            }
            this.FNLstopEngine(null, this.mode);
        }
        return null;
    }

    public PBFnlAPI() {
        String libPath = "";
        String osName = "";
        try {
            libPath = System.getProperty("res.location.us");
            osName = System.getProperty("os.name").toLowerCase();
            if (osName.indexOf("win") >= 0) {
                if (libPath.indexOf("win64") == -1) {
                    libPath = libPath + "/win64";
                }
                System.load(libPath + "/DPVDll.dll");
                System.load(libPath + "/LACSF.dll");
                System.load(libPath + "/pbelot.dll");
                System.load(libPath + "/SteLinkf.dll");
                System.load(libPath + "/RDIf.dll");
                System.load(libPath + "/pbfn.dll");
                System.load(libPath + "/pbFnlJni.dll");
            } else {
                if (osName.indexOf("aix") >= 0) {
                    if (libPath.indexOf("aix64") == -1) {
                        libPath = libPath + "/aix64";
                    }
                } else if (osName.indexOf("hp") >= 0) {
                    if (libPath.indexOf("hpit64") == -1) {
                        libPath = libPath + "/hpit64";
                    }
                } else if (osName.indexOf("sunos") >= 0) {
                    if (libPath.indexOf("solaris64") == -1) {
                        libPath = libPath + "/solaris64";
                    }
                } else if (libPath.indexOf("linux64") == -1) {
                    libPath = libPath + "/linux64";
                }
                System.load(libPath + "/libpbfn.so");
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("ERROR: Native library failed to load.\nERROR: " + e.getMessage());
            System.out.println("ERROR: libPath: " + libPath);
            System.out.println("ERROR: osName: " + osName);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            System.out.println("ERROR: Native library failed to load.\nERROR: " + e.getMessage());
            System.out.println("ERROR: libPath: " + libPath);
            System.out.println("ERROR: osName: " + osName);
            throw new RuntimeException(e);
        }
    }
}

