/*
 * Decompiled with CFR 0.152.
 */
package com.pb.addressing.api;

import com.mapinfo.geocode.api.Candidate;
import com.mapinfo.geocode.api.CapabilitiesResponse;
import com.mapinfo.geocode.api.Response;
import com.mapinfo.mapmarker.CandidateAddress;
import com.pb.addressing.CandidateCase;
import com.pb.addressing.ExceptionCode;
import com.pb.addressing.ValidationException;
import com.pb.addressing.api.Address;
import com.pb.addressing.api.MatchFields;
import com.pb.addressing.api.PBFnlAddressData;
import com.pb.addressing.api.Preferences;
import com.pb.addressing.api.ValidationMatchFields;
import com.pb.addressing.confidence.ValidationConfidence;
import com.pb.addressing.util.CasingUtility;
import com.pb.addressing.util.ValidationUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ValidatedCandidate {
    public static final String TOTAL_POSSIBLE_CANDIDATES = "TOTAL_POSSIBLE_CANDIDATES";
    public static final String MATCHED_FIELDS = "MATCHED_FIELDS";
    public static final String COUNTRY_SPECIFIC_FIELDS = "COUNTRY_SPECIFIC_FIELDS";
    public static final String INPUT_ADDRESS = "INPUT_ADDRESS";
    public static final String ADDRESSLINE1 = "AddressLine1";
    public static final String ADDRESSLINE2 = "AddressLine2";
    public static final String ADDRESSLINE1_INPUT = "AddressLine1.Input";
    public static final String ADDRESSLINE2_INPUT = "AddressLine2.Input";
    public static final String ADDRESSBLOCK1 = "AddressBlock1";
    public static final String ADDRESSBLOCK2 = "AddressBlock2";
    public static final String ADDRESSBLOCK3 = "AddressBlock3";
    public static final String ADDRESSBLOCK4 = "AddressBlock4";
    public static final String ADDRESSBLOCK5 = "AddressBlock5";
    public static final String CITY = "City";
    public static final String CITYSUBDIVISION = "CitySubdivision";
    public static final String STATEPROVINCE = "StateProvince";
    public static final String STATEPROVINCESUBDIVISION = "StateProvinceSubdivision";
    public static final String POSTALCODE = "PostalCode";
    public static final String COUNTRY = "Country";
    public static final String PRECISIONCODE = "PrecisionCode";
    public static final String VENDORCODE = "VendorCode";
    public static final String FIRMNAME = "FirmName";
    public static final String POSTALCODE_ADDON = "PostalCode.AddOn";
    public static final String PROCESSEDBY = "ProcessedBy";
    public static final String MATCHSCORE = "MatchScore";
    public static final String MULTIMATCHCOUNT = "MultimatchCount";
    public static final String HOUSENUMBER = "HouseNumber";
    public static final String STREETNAME = "StreetName";
    public static final String APARTMENTLABEL = "ApartmentLabel";
    public static final String APARTMENTNUMBER = "ApartmentNumber";
    public static final String STREETTYPE = "StreetType";
    public static final String CONFIDENCE = "Confidence";
    public static final String BUILDING = "Building";
    public static final String POBOX = "POBox";
    public static final String PRINCIPALITY = "Principality";
    public static final String LEADINGDIRECTIONAL = "LeadingDirectional";
    public static final String TRAILINGDIRECTIONAL = "TrailingDirectional";
    public static final String GLOBALADDRESSVALIDATION = "GAM";
    public static final String SOURCE_DICTIONARY = "SourceDictionary";
    public static final String PLACENAME = "PlaceName";
    public static final String AUS_PARCEL_ID = "AUS.Parcel.ID";
    public static final String AUS_PID = "AUS.PID";
    public static final String AUS_PRINCIPAL_PID = "AUS.Principal.Pid";
    public static final String AUS_ADDRESS_CLASS = "AUS.Address.Class";
    public static final String AUS_SA1 = "AUS.SA1";
    public static final String AUS_LEVEL_NUMBER = "AUS.Level.Number";
    public static final String GBR_DEPENDENTSTREET_NAME = "GBR.DependentStreet.Name";
    public static final String GBR_DOUBLEDEPENDENT_LOCALITY = "GBR.DoubleDependent.Locality";
    public static final String GBR_HISTORIC_POSTCODE = "GBR.Historic.Postcode";
    public static final String GBR_ALIASED_LOCALITY = "GBR.Aliased.Locality";
    public static final String GBR_OSAPR = "GBR.OSAPR";
    public static final String GBR_UPRN = "GBR.UPRN";
    public static final String GBR_RPC = "GBR.RPC";
    public static final String CAN_CENSUS_CD = "CAN.Census.CD";
    public static final String CAN_CENSUS_CMA = "CAN.Census.CMA";
    public static final String CAN_CENSUS_CSD = "CAN.Census.CSD";
    public static final String CAN_CENSUS_CT = "CAN.Census.CT";
    public static final String CAN_CENSUS_DA = "CAN.Census.DA";
    public static final String CAN_FORMATTEDSTREET_RANGE = "CAN.FormattedStreet.Range";
    public static final String IRL_EIRCODE = "IRL.Eircode";
    public static final String ITA_HISTORICAL_POSTCODE = "ITA.Historical.Postcode";
    public static final String NZL_ALIASED_SUBURB = "NZL.Aliased.SUBURB";
    public static final String IND_EXTENDEDRESULTCODE = "IND.ExtendedResultCode";
    public static final String IND_ISRURAL = "IND.IsRural";
    public static final String IND_SUBLOCALITY = "IND.SubLocality";
    public static final String IND_POICATEGORY = "IND.POICategory";
    public static final String JPN_BANCHI = "JPN.BANCHI";
    public static final String JPN_CHOMOKO = "JPN.CHOMOKO";
    public static final String JPN_CHOOAZA = "JPN.CHOOAZA";
    public static final String JPN_GO = "JPN.GO";
    public static final String JPN_JUSHOCODE = "JPN.JUSHOCODE";
    public static final String PARSEDPOSTCODEBASE_INPUT = "ParsedPostCodeBase.Input";
    public static final String POSTALCODE_INPUT = "PostalCode.Input";
    public static final List<String> CANDIDATE_ITEMS_ALWAYS_UPPER = new ArrayList<String>(Arrays.asList("ProcessedBy", "PrecisionCode", "IRL.Eircode", "PostalCode", "PostalCode.Input", "PostalCode.AddOn", "ParsedPostCodeBase.Input"));
    private static final String PRE_DIRECTIONAL = "PRE_DIRECTIONAL";
    private static final String POST_DIRECTIONAL = "POST_DIRECTIONAL";
    private static final String STREET_DATA_TYPE = "StreetDataType";
    private static final String THOROUGHFARE_TYPE = "THOROUGHFARE_TYPE";
    private static final String INPUT_MATCH_SCORE = "INPUT_MATCH_SCORE";
    private static final String COUNTY = "County";
    private static final String CITYSUBDIVISION_MATCHED = "CitySubdivision.Matched";
    private static final String STATEPROVINCE_MATCHED = "StateProvince.Matched";
    private static final String STREETNAME_MATCHED = "StreetName.Matched";
    private static final String STREETTYPE_MATCHED = "StreetType.Matched";
    private static final String FIRMNAME_MATCHED = "Firmname.Matched";
    private static final String HOUSENUMBER_MATCHED = "Housenumber.Matched";
    private static final String POSTALCODE_MATCHED = "Postalcode.Matched";
    private static final String CITY_MATCHED = "City.Matched";
    Map<String, String> candidatemap;
    Map<String, String> countryspecificfieldsMap = new HashMap<String, String>();
    MatchFields matchedFields = null;

    public ValidatedCandidate() {
    }

    ValidatedCandidate(Preferences opts, PBFnlAddressData fnl, Map<String, String> data) {
        this.candidatemap = new HashMap<String, String>();
        this.candidatemap.putAll(this.getFnlReturnData(fnl, opts, data));
    }

    ValidatedCandidate(Candidate candidate, Response georesponse, CapabilitiesResponse capabilitiesResponse, Preferences preferences, Address address) throws ValidationException {
        if (georesponse == null || preferences == null || capabilitiesResponse == null || address == null) {
            throw new ValidationException("Null candidate passed to constructor", ExceptionCode.REQUIRED_PARAMETER_MISSING);
        }
        this.candidatemap = new HashMap<String, String>();
        this.candidatemap.putAll(this.getCandidatemap(candidate, preferences));
        String confidence = this.calculateConfidence(candidate, preferences, georesponse, capabilitiesResponse);
        this.candidatemap.put(CONFIDENCE, confidence);
    }

    public Map<String, String> getCandidateMap() {
        return this.candidatemap;
    }

    private Map<String, String> getCandidatemap(Candidate candidate, Preferences preferences) {
        HashMap<String, String> candidatemap = new HashMap<String, String>();
        String formattedStreetAddress = candidate.getFormattedStreetAddress();
        if (formattedStreetAddress != null) {
            if (candidate.getPlaceName() != null && !StringUtils.containsIgnoreCase((String)formattedStreetAddress, (String)candidate.getPlaceName())) {
                String regex;
                Pattern regexPattern;
                Matcher regexMatcher;
                candidatemap.put(ADDRESSLINE1, candidate.getPlaceName().concat(", " + formattedStreetAddress));
                candidatemap.put(ADDRESSBLOCK1, candidate.getPlaceName().concat(", " + formattedStreetAddress));
                if (ValidationUtils.getISO3Country(candidate.getCountry()).equalsIgnoreCase("JPN") && (regexMatcher = (regexPattern = Pattern.compile(regex = "[\u3040-\u30ff\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\uff66-\uff9f]")).matcher(candidate.getPlaceName())).find()) {
                    candidatemap.put(ADDRESSLINE1, formattedStreetAddress.concat(" " + candidate.getPlaceName()));
                    candidatemap.put(ADDRESSBLOCK1, formattedStreetAddress.concat(" " + candidate.getPlaceName()));
                }
            } else {
                candidatemap.put(ADDRESSLINE1, formattedStreetAddress);
                candidatemap.put(ADDRESSBLOCK1, formattedStreetAddress);
            }
        }
        candidatemap.put(ADDRESSBLOCK2, candidate.getFormattedLocationAddress());
        candidatemap.put(CITY, candidate.getAreaName3());
        candidatemap.put(CITYSUBDIVISION, candidate.getAreaName4());
        candidatemap.put(STATEPROVINCE, candidate.getAreaName1());
        candidatemap.put(STATEPROVINCESUBDIVISION, candidate.getAreaName2());
        candidatemap.put(POSTALCODE, candidate.getPostCode1());
        candidatemap.put(COUNTY, candidate.getAreaName2());
        candidatemap.put(COUNTRY, ValidationUtils.getFullCountryName(candidate.getCountry()));
        this.handlePrecisionCodeandHousenumber(candidate, preferences, candidatemap);
        candidatemap.put(STREETNAME, candidate.getStreetName());
        candidatemap.put(APARTMENTLABEL, candidate.getUnitType());
        candidatemap.put(APARTMENTNUMBER, candidate.getUnitValue());
        candidatemap.put(BUILDING, candidate.getPlaceName());
        candidatemap.put(PRINCIPALITY, candidate.getAreaName1());
        candidatemap.put(PLACENAME, candidate.getPlaceName());
        candidatemap.put(FIRMNAME, candidate.getPlaceName());
        candidatemap.put(POSTALCODE_ADDON, candidate.getPostCode2());
        candidatemap.put(PROCESSEDBY, GLOBALADDRESSVALIDATION);
        candidatemap.put(SOURCE_DICTIONARY, candidate.getSourceDictionary());
        candidatemap.put(VENDORCODE, (String)candidate.getAddress().getCustomFields().get(STREET_DATA_TYPE));
        candidatemap.put(MATCHSCORE, (String)candidate.getAddress().getCustomFields().get(INPUT_MATCH_SCORE));
        candidatemap.put(STREETTYPE, (String)candidate.getAddress().getCustomFields().get(THOROUGHFARE_TYPE));
        candidatemap.put(LEADINGDIRECTIONAL, (String)candidate.getAddress().getCustomFields().get(PRE_DIRECTIONAL));
        candidatemap.put(TRAILINGDIRECTIONAL, (String)candidate.getAddress().getCustomFields().get(POST_DIRECTIONAL));
        ValidationUtils.convertToPreferedCase(candidatemap, (CandidateCase)preferences.getCandidateCasing(), candidate.getCountry());
        this.applyUpperCasingRules(candidatemap);
        candidatemap.putAll(this.getMatchFieldsMap(candidate, preferences));
        candidatemap.putAll(this.getCountrySpecificFields(candidate, preferences));
        ValidationUtils.removeEmptyValues(candidatemap);
        return candidatemap;
    }

    private void handlePrecisionCodeandHousenumber(Candidate candidate, Preferences preferences, Map<String, String> candidatemap) {
        if (preferences.isReturnPrecisionCode()) {
            candidatemap.put(PRECISIONCODE, candidate.getPrecisionCode());
        }
        if (null != candidate.getPrecisionCode() && !candidate.getPrecisionCode().toLowerCase().startsWith("s4") && candidate.getAddressNumber() != null) {
            candidatemap.put(HOUSENUMBER, candidate.getAddressNumber());
        }
    }

    private void applyUpperCasingRules(Map<String, String> candidatemap) {
        this.applyUpperCasingRules(candidatemap, POSTALCODE, ADDRESSBLOCK2);
        this.applyUpperCasingRules(candidatemap, STATEPROVINCE, ADDRESSBLOCK2);
    }

    private void applyUpperCasingRules(Map<String, String> candidatemap, String fieldtosearch, String searchinfield) {
        int indx;
        String searchinvalue = candidatemap.get(searchinfield);
        String valuetosearch = candidatemap.get(fieldtosearch);
        if (valuetosearch != null && searchinvalue != null && (indx = searchinvalue.toLowerCase().indexOf(valuetosearch.toLowerCase())) >= 0) {
            searchinvalue = searchinvalue.substring(0, indx) + valuetosearch + searchinvalue.substring(indx + valuetosearch.length());
            candidatemap.put(searchinfield, searchinvalue);
        }
    }

    private String calculateConfidence(Candidate candidate, Preferences preferences, Response response, CapabilitiesResponse capabilitiesResponse) {
        Map<String, String> parsedInputAddressMap = this.getParsedInput(response);
        ValidationConfidence validationConfidence = new ValidationConfidence();
        String confidence = validationConfidence.getConfidence(parsedInputAddressMap, candidate, preferences, capabilitiesResponse);
        return confidence;
    }

    public Map<String, String> getCountrySpecificFields() {
        return this.countryspecificfieldsMap;
    }

    private Map<String, String> getCountrySpecificFields(Candidate candidate, Preferences preferences) {
        if (preferences.isReturnCountrySpecificFields()) {
            if (candidate.getCountry().toLowerCase().equalsIgnoreCase("aus")) {
                this.countryspecificfieldsMap.put(AUS_PARCEL_ID, candidate.getCustomFieldValue("GNAF_PARCEL_ID"));
                this.countryspecificfieldsMap.put(AUS_PID, candidate.getCustomFieldValue("GNAF_PID"));
                this.countryspecificfieldsMap.put(AUS_PRINCIPAL_PID, candidate.getCustomFieldValue("GNAF_PRINCIPAL_PID"));
                this.countryspecificfieldsMap.put(AUS_ADDRESS_CLASS, candidate.getCustomFieldValue("GNAF_ADDRESS_CLASS"));
                this.countryspecificfieldsMap.put(AUS_SA1, candidate.getCustomFieldValue("GNAF_SA1"));
                this.countryspecificfieldsMap.put(AUS_LEVEL_NUMBER, candidate.getCustomFieldValue("LEVEL_NUMBER"));
            }
            if (candidate.getCountry().toLowerCase().equalsIgnoreCase("gbr")) {
                this.countryspecificfieldsMap.put(GBR_DEPENDENTSTREET_NAME, candidate.getCustomFieldValue("DEPENDENT_STREET_NAME"));
                this.countryspecificfieldsMap.put(GBR_DOUBLEDEPENDENT_LOCALITY, candidate.getCustomFieldValue("DEPENDENT_LOCALITY"));
                this.countryspecificfieldsMap.put(GBR_DOUBLEDEPENDENT_LOCALITY, candidate.getCustomFieldValue("DOUBLE_DEPENDENT_LOCALITY"));
                this.countryspecificfieldsMap.put(GBR_HISTORIC_POSTCODE, candidate.getCustomFieldValue("HISTORIC_POSTCODE"));
                this.countryspecificfieldsMap.put(GBR_ALIASED_LOCALITY, candidate.getCustomFieldValue("ALIASED_LOCALITY"));
                this.countryspecificfieldsMap.put(GBR_OSAPR, candidate.getCustomFieldValue("OSAPR"));
                this.countryspecificfieldsMap.put(GBR_UPRN, candidate.getCustomFieldValue("UPRN"));
                this.countryspecificfieldsMap.put(GBR_RPC, candidate.getCustomFieldValue("RPC"));
            }
            if (candidate.getCountry().toLowerCase().equalsIgnoreCase("ind")) {
                this.countryspecificfieldsMap.put(IND_POICATEGORY, candidate.getCustomFieldValue("POI_CATEGORY"));
                this.countryspecificfieldsMap.put(IND_SUBLOCALITY, candidate.getCustomFieldValue("SUB_LOCALITY"));
                this.countryspecificfieldsMap.put(IND_ISRURAL, candidate.getCustomFieldValue("ISRURAL"));
                this.countryspecificfieldsMap.put(IND_EXTENDEDRESULTCODE, candidate.getCustomFieldValue("EXTENDED_RESULT_CODE"));
            }
            if (candidate.getCountry().toLowerCase().equalsIgnoreCase("can")) {
                this.countryspecificfieldsMap.put(CAN_CENSUS_CD, candidate.getCustomFieldValue("CENSUS_CD"));
                this.countryspecificfieldsMap.put(CAN_CENSUS_CMA, candidate.getCustomFieldValue("CENSUS_CMA"));
                this.countryspecificfieldsMap.put(CAN_CENSUS_CSD, candidate.getCustomFieldValue("CENSUS_CSD"));
                this.countryspecificfieldsMap.put(CAN_CENSUS_CT, candidate.getCustomFieldValue("CENSUS_CT"));
                this.countryspecificfieldsMap.put(CAN_CENSUS_DA, candidate.getCustomFieldValue("CENSUS_DA"));
                this.countryspecificfieldsMap.put(CAN_FORMATTEDSTREET_RANGE, candidate.getCustomFieldValue("FORMATTED_STREET_RANGE"));
            }
            if (candidate.getCountry().toLowerCase().equalsIgnoreCase("jpn")) {
                this.countryspecificfieldsMap.put(JPN_BANCHI, candidate.getCustomFieldValue("BANCHI"));
                this.countryspecificfieldsMap.put(JPN_CHOMOKO, candidate.getCustomFieldValue("CHOMOKO"));
                this.countryspecificfieldsMap.put(JPN_CHOOAZA, candidate.getCustomFieldValue("CHOOAZA"));
                this.countryspecificfieldsMap.put(JPN_GO, candidate.getCustomFieldValue("GO"));
                this.countryspecificfieldsMap.put(JPN_JUSHOCODE, candidate.getCustomFieldValue("JUSHO_CODE"));
            }
            if (candidate.getCountry().toLowerCase().equalsIgnoreCase("irl")) {
                this.countryspecificfieldsMap.put(IRL_EIRCODE, candidate.getCustomFieldValue("EIR_CODE"));
            }
            if (candidate.getCountry().toLowerCase().equalsIgnoreCase("ita")) {
                this.countryspecificfieldsMap.put(ITA_HISTORICAL_POSTCODE, candidate.getCustomFieldValue("HISTORICALPOSTCODE"));
            }
            if (candidate.getCountry().toLowerCase().equalsIgnoreCase("nzl")) {
                this.countryspecificfieldsMap.put(NZL_ALIASED_SUBURB, candidate.getCustomFieldValue("ALIASED_SUBURB"));
            }
            ValidationUtils.convertToPreferedCase(this.countryspecificfieldsMap, (CandidateCase)preferences.getCandidateCasing(), candidate.getCountry());
        }
        ValidationUtils.removeEmptyValues(this.countryspecificfieldsMap);
        return this.countryspecificfieldsMap;
    }

    public String getPrincipality() {
        return this.candidatemap.get(PRINCIPALITY);
    }

    public String getBuilding() {
        return this.candidatemap.get(BUILDING);
    }

    public String getProcessedBy() {
        return this.candidatemap.get(PROCESSEDBY);
    }

    public String getPostalcodeAddOn() {
        return this.candidatemap.get(POSTALCODE_ADDON);
    }

    public String getMatchScore() {
        return this.candidatemap.get(MATCHSCORE);
    }

    public String getVendorCode() {
        return this.candidatemap.get(VENDORCODE);
    }

    public String getStreetType() {
        return this.candidatemap.get(STREETTYPE);
    }

    public String getLeadingDirectional() {
        return this.candidatemap.get(LEADINGDIRECTIONAL);
    }

    public String getTrailingDirectional() {
        return this.candidatemap.get(TRAILINGDIRECTIONAL);
    }

    public String getPlaceName() {
        return this.candidatemap.get(PLACENAME);
    }

    public String getAddressBlock1() {
        return this.candidatemap.get(ADDRESSBLOCK1);
    }

    public String getLastLine() {
        return this.candidatemap.get(ADDRESSBLOCK2);
    }

    public String getFirmName() {
        return this.candidatemap.get(FIRMNAME);
    }

    public String getStateProvince() {
        return this.candidatemap.get(STATEPROVINCE);
    }

    public String getStateProvinceSubdivision() {
        return this.candidatemap.get(STATEPROVINCESUBDIVISION);
    }

    public String getCity() {
        return this.candidatemap.get(CITY);
    }

    public String getCitySubdivision() {
        return this.candidatemap.get(CITYSUBDIVISION);
    }

    public String getPostalCode() {
        return this.candidatemap.get(POSTALCODE);
    }

    public String getPostalCode2() {
        return this.candidatemap.get(POSTALCODE_ADDON);
    }

    public String getCountry() {
        return this.candidatemap.get(COUNTRY);
    }

    public String getHouseNumber() {
        return this.candidatemap.get(HOUSENUMBER);
    }

    public String getStreetName() {
        return this.candidatemap.get(STREETNAME);
    }

    public String getApartmentLabel() {
        return this.candidatemap.get(APARTMENTLABEL);
    }

    public String getApartmentNumber() {
        return this.candidatemap.get(APARTMENTNUMBER);
    }

    public String getConfidenceScore() {
        return this.candidatemap.get(CONFIDENCE);
    }

    public String getPrecisionCode() {
        return this.candidatemap.get(PRECISIONCODE);
    }

    public String getSourceDictionary() {
        return this.candidatemap.get(SOURCE_DICTIONARY);
    }

    private Map<String, String> getParsedInput(Response response) {
        HashMap<String, String> parsedinputmap = new HashMap<String, String>();
        parsedinputmap.put("ParsedHouseNumber.Input", response.getCustomFieldValue("PARSED_INPUT_ADDRESS_NUMBER"));
        parsedinputmap.put("ParsedAddressLine1.Input", response.getCustomFieldValue("PARSED_INPUT_STREET_NAME"));
        parsedinputmap.put("ParsedPreStreetType.Input", response.getCustomFieldValue("PARSED_INPUT_STREET_PRE_TYPE"));
        parsedinputmap.put("ParsedPostStreetType.Input", response.getCustomFieldValue("PARSED_INPUT_STREET_POST_TYPE"));
        parsedinputmap.put("ParsedApartmentLabel.Input", response.getCustomFieldValue("PARSED_INPUT_UNIT_TYPE"));
        parsedinputmap.put("ParsedApartmentNumber.Input", response.getCustomFieldValue("PARSED_INPUT_UNIT_VALUE"));
        parsedinputmap.put("ParsedPlaceName.Input", response.getCustomFieldValue("PARSED_INPUT_PLACE_NAME"));
        parsedinputmap.put("ParsedPostCodeAddOn.Input", response.getCustomFieldValue("PARSED_INPUT_POST_CODE_2"));
        parsedinputmap.put("ParsedStateProvince.Input", response.getCustomFieldValue("PARSED_INPUT_AREA_NAME_1"));
        parsedinputmap.put("ParsedStateProvinceSubdivision.Input", response.getCustomFieldValue("PARSED_INPUT_AREA_NAME_2"));
        parsedinputmap.put("ParsedCity.Input", response.getCustomFieldValue("PARSED_INPUT_AREA_NAME_3"));
        parsedinputmap.put(PARSEDPOSTCODEBASE_INPUT, response.getCustomFieldValue("PARSED_INPUT_POST_CODE_1"));
        parsedinputmap.put("ParsedCitySubDivision.Input", response.getCustomFieldValue("PARSED_INPUT_AREA_NAME_4"));
        parsedinputmap.put("ParsedCountry.Input", response.getCustomFieldValue("PARSED_INPUT_COUNTRY"));
        String dualinput = this.isStringEmpty(response.getCustomFieldValue("DualAddressParsedStreet")) ? response.getCustomFieldValue("DualAddressParsedPOBox") : response.getCustomFieldValue("DualAddressParsedStreet");
        parsedinputmap.put("DualAddressParsed.Input", dualinput);
        parsedinputmap.put("FormattedInputStreet", response.getCustomFieldValue("FormattedInputStreet"));
        parsedinputmap.put("AdditionalInputData", response.getCustomFieldValue("PARSED_INPUT_GENERIC_FIELD_1"));
        ValidationUtils.removeEmptyValues(parsedinputmap);
        return parsedinputmap;
    }

    private boolean isStringEmpty(Object value) {
        return null == value || !(value instanceof String) || value instanceof String && ("".equals(value) || ((String)value).isEmpty());
    }

    private String getPostCode_City_StateProvince_In_UpperCase(CandidateAddress candidateAt, String casingValue, Locale locale, String casing) {
        if (!this.isStringEmpty(candidateAt.getPostCode1()) && casingValue.toUpperCase().contains(candidateAt.getPostCode1())) {
            casingValue = casing.equals("Mixed") ? casingValue.replaceAll(CasingUtility.getTitleCase(candidateAt.getPostCode1(), locale), candidateAt.getPostCode1().toUpperCase()) : casingValue.replaceAll(candidateAt.getPostCode1().toLowerCase(), candidateAt.getPostCode1().toUpperCase());
            if (!this.isStringEmpty(candidateAt.getPostCode2()) && casingValue.toUpperCase().contains(candidateAt.getPostCode2())) {
                casingValue = casingValue.replaceAll(candidateAt.getPostCode2().toLowerCase(), candidateAt.getPostCode2().toUpperCase());
            }
        }
        if (!this.isStringEmpty(candidateAt.getAreaName1()) && casingValue.toUpperCase().contains(candidateAt.getAreaName1()) && candidateAt.getAreaName1().length() <= 3) {
            casingValue = casing.equals("Mixed") ? casingValue.replaceAll(CasingUtility.getTitleCase(candidateAt.getAreaName1(), locale), candidateAt.getAreaName1().toUpperCase()) : casingValue.replaceAll(candidateAt.getAreaName1().toLowerCase(), candidateAt.getAreaName1().toUpperCase());
        }
        if (!this.isStringEmpty(candidateAt.getAreaName3()) && casingValue.toUpperCase().contains(candidateAt.getAreaName3()) && candidateAt.getAreaName3().length() <= 3) {
            casingValue = casing.equals("Mixed") ? casingValue.replaceAll(CasingUtility.getTitleCase(candidateAt.getAreaName3(), locale), candidateAt.getAreaName3().toUpperCase()) : casingValue.replaceAll(candidateAt.getAreaName3().toLowerCase(), candidateAt.getAreaName3().toUpperCase());
        }
        return casingValue;
    }

    public MatchFields getMatchFields() {
        return this.matchedFields;
    }

    private Map<String, String> getMatchFieldsMap(Candidate candidate, Preferences preferences) {
        this.matchedFields = new ValidationMatchFields();
        this.matchedFields.setMatchOnAllStreetFields(candidate.getMatchedFields().isMatchOnAllStreetFields());
        this.matchedFields.setMatchOnCity(candidate.getMatchedFields().isMatchOnAreaName3());
        this.matchedFields.setMatchOnCitySubdivision(candidate.getMatchedFields().isMatchOnAreaName4());
        this.matchedFields.setMatchOnFirmName(candidate.getMatchedFields().isMatchOnPlaceName());
        if (null != candidate.getPrecisionCode() && !candidate.getPrecisionCode().toLowerCase().startsWith("s4")) {
            this.matchedFields.setMatchOnHouseNumber(candidate.getMatchedFields().isMatchOnAddressNumber());
        }
        this.matchedFields.setMatchOnInputFields(candidate.getMatchedFields().isMatchOnInputFields());
        this.matchedFields.setMatchOnPostalCode(candidate.getMatchedFields().isMatchOnPostCode1());
        this.matchedFields.setMatchOnPostalCode2(candidate.getMatchedFields().isMatchOnPostCode2());
        this.matchedFields.setMatchOnStateProvince(candidate.getMatchedFields().isMatchOnAreaName1());
        this.matchedFields.setMatchOnStateProvinceSubdivision(candidate.getMatchedFields().isMatchOnAreaName2());
        this.matchedFields.setMatchOnStreetDirectional(candidate.getMatchedFields().isMatchOnStreetDirectional());
        this.matchedFields.setMatchOnStreetName(candidate.getMatchedFields().isMatchOnStreetName());
        this.matchedFields.setMatchOnStreetType(candidate.getMatchedFields().isMatchOnStreetType());
        return this.matchedFields.asMap();
    }

    public String toString() {
        return this.candidatemap.toString();
    }

    private void fmtCASSAddressLine(Map<String, String> data, PBFnlAddressData rtnData) {
        String workbuf = "";
        boolean unit_added = false;
        int addressLoc = 0;
        int unitLoc = 0;
        int pmLoc = 0;
        data.put("USA.CASSAddressLine1", "");
        data.put("USA.CASSAddressLine2", "");
        try {
            addressLoc = Integer.parseInt(rtnData.cAddressLoc, 16);
        }
        catch (NumberFormatException nfe) {
            addressLoc = 0;
        }
        if (addressLoc == 0) {
            workbuf = rtnData.cAddress1.length() != 0 ? rtnData.cAddress1 : rtnData.cAddress2;
        } else if ((addressLoc & 1) == 1 || (addressLoc & 3) == 3 || (addressLoc & 4) == 4 || (addressLoc & 0x80) == 128) {
            workbuf = rtnData.cAddress1;
        } else if ((addressLoc & 2) == 2 || (addressLoc & 8) == 8) {
            workbuf = rtnData.cAddress2;
        }
        if (rtnData.cUnit1.length() != 0) {
            workbuf = workbuf + " " + rtnData.cUnit1;
            unit_added = true;
        }
        if (rtnData.cUnit2.length() != 0) {
            workbuf = workbuf + " " + rtnData.cUnit2;
            unit_added = true;
        }
        if (rtnData.cPMBUnit.length() != 0) {
            try {
                unitLoc = Integer.parseInt(rtnData.cUnitLoc, 16);
            }
            catch (NumberFormatException nfe) {
                unitLoc = 0;
            }
            try {
                pmLoc = Integer.parseInt(rtnData.cPMLoc, 16);
            }
            catch (NumberFormatException nfe) {
                pmLoc = 0;
            }
            if (unit_added) {
                if ((unitLoc & 1) == 1 && (addressLoc & 1) == 1) {
                    workbuf = workbuf + " " + rtnData.cPMBUnit;
                } else {
                    data.put("USA.CASSAddressLine2", rtnData.cPMBUnit);
                }
            } else if ((pmLoc & 2) == 2 && (addressLoc & 1) == 1) {
                data.put("USA.CASSAddressLine2", rtnData.cPMBUnit);
            } else {
                workbuf = workbuf + " " + rtnData.cPMBUnit;
            }
        }
        data.put("USA.CASSAddressLine1", workbuf);
        if (data.get("USA.CASSAddressLine2").equals("")) {
            if ((addressLoc & 1) == 1) {
                if (!rtnData.cAddress2.equalsIgnoreCase("GENERAL DELIVERY")) {
                    data.put("USA.CASSAddressLine2", rtnData.cAddress2);
                }
            } else if ((addressLoc & 2) == 2 && rtnData.cAddress1.length() > 0 && !rtnData.cAddress1.equalsIgnoreCase("GENERAL DELIVERY")) {
                data.put("USA.CASSAddressLine1", rtnData.cAddress1);
            }
        }
    }

    private int fillDataBlocks(Map<String, String> data, int counter, String dataBlock) {
        int myCounter = counter;
        String s = data.get("AddressBlock" + counter);
        while (s != null && s.length() != 0) {
            s = data.get("AddressBlock" + ++counter);
        }
        if (dataBlock != null && dataBlock.length() > 0) {
            data.put("AddressBlock" + counter, dataBlock);
            return counter + 1;
        }
        return counter;
    }

    private String createPrecisionCode(PBFnlAddressData rtnData) {
        String PrecisionCode = "";
        PrecisionCode = rtnData.cError.equals("") || rtnData.cError.substring(0, 1).equals("5") ? (rtnData.cAddressType.equals("01") ? "B2" : "S8") : (rtnData.cAddressType.equals("01") ? "B1" : (rtnData.cError.equals("4421") ? "S4" : (rtnData.cZipValid.equals("Y") ? "S1" : "--")));
        PrecisionCode = rtnData.cAdsRange.equals("80") || rtnData.cAdsRange.equals("01") || rtnData.cAdsRange.equals("02") || rtnData.cAdsRange.equals("03") || rtnData.cAdsRange.equals("06") ? PrecisionCode + "H" : PrecisionCode + "-";
        PrecisionCode = rtnData.cAdsPreDir.equals("80") || rtnData.cAdsPreDir.equals("01") || rtnData.cAdsPreDir.equals("02") || rtnData.cAdsPreDir.equals("03") || rtnData.cAdsPreDir.equals("06") ? PrecisionCode + "P" : PrecisionCode + "-";
        PrecisionCode = rtnData.cAdsStreetName.equals("80") || rtnData.cAdsStreetName.equals("01") || rtnData.cAdsStreetName.equals("02") || rtnData.cAdsStreetName.equals("03") || rtnData.cAdsStreetName.equals("06") ? PrecisionCode + "N" : PrecisionCode + "-";
        PrecisionCode = rtnData.cAdsSuffix.equals("80") || rtnData.cAdsSuffix.equals("01") || rtnData.cAdsSuffix.equals("02") || rtnData.cAdsSuffix.equals("03") || rtnData.cAdsSuffix.equals("06") ? PrecisionCode + "T" : PrecisionCode + "-";
        PrecisionCode = rtnData.cAdsPostDir.equals("80") || rtnData.cAdsPostDir.equals("01") || rtnData.cAdsPostDir.equals("02") || rtnData.cAdsPostDir.equals("03") || rtnData.cAdsPostDir.equals("06") ? PrecisionCode + "S" : PrecisionCode + "-";
        PrecisionCode = rtnData.cAdsCity.equals("80") || rtnData.cAdsCity.equals("01") || rtnData.cAdsCity.equals("02") || rtnData.cAdsCity.equals("03") || rtnData.cAdsCity.equals("06") ? PrecisionCode + "C" : PrecisionCode + "-";
        PrecisionCode = rtnData.cAdsZip.equals("80") || rtnData.cAdsZip.equals("01") || rtnData.cAdsZip.equals("02") || rtnData.cAdsZip.equals("03") || rtnData.cAdsZip.equals("06") ? PrecisionCode + "Z" : PrecisionCode + "-";
        PrecisionCode = PrecisionCode + "A";
        PrecisionCode = PrecisionCode + "-";
        return PrecisionCode;
    }

    private Map<String, String> getFnlReturnData(PBFnlAddressData rtnData, Preferences preferences, Map<String, String> data) {
        data.put(COUNTRY, "UNITED STATES");
        data.put(PROCESSEDBY, GLOBALADDRESSVALIDATION);
        if (rtnData.cFirm.length() > 0) {
            data.put(FIRMNAME, rtnData.cFirm);
        } else {
            data.put(FIRMNAME, " ");
        }
        if (rtnData.cAddress1.length() > 0) {
            data.put(ADDRESSLINE1, rtnData.cAddress1);
        } else {
            data.put(ADDRESSLINE1, " ");
        }
        if (rtnData.cAddress2.length() > 0) {
            data.put(ADDRESSLINE2, rtnData.cAddress2);
        } else {
            data.put(ADDRESSLINE2, " ");
        }
        if (rtnData.cCity.length() > 0) {
            data.put(CITY, rtnData.cCity);
        } else {
            data.put(CITY, " ");
        }
        if (rtnData.cUrb.length() > 0) {
            data.put(CITYSUBDIVISION, rtnData.cUrb);
        } else {
            data.put(CITYSUBDIVISION, " ");
        }
        if (rtnData.cState.length() > 0) {
            data.put(STATEPROVINCE, rtnData.cState);
        } else {
            data.put(STATEPROVINCE, " ");
        }
        if (rtnData.cZip.length() > 0) {
            data.put(POSTALCODE, rtnData.cZip);
        } else {
            data.put(POSTALCODE, " ");
        }
        data.put(POSTALCODE_ADDON, rtnData.cZip4);
        data.put("AdditionalInputData", rtnData.cExtra);
        int counter = 1;
        counter = this.fillDataBlocks(data, counter, rtnData.cExtra);
        counter = this.fillDataBlocks(data, counter, rtnData.cAddressLine1);
        counter = this.fillDataBlocks(data, counter, rtnData.cAddressLine2);
        counter = this.fillDataBlocks(data, counter, rtnData.cAddressLine3);
        counter = this.fillDataBlocks(data, counter, rtnData.cAddressLine4);
        counter = this.fillDataBlocks(data, counter, rtnData.cAddressLine5);
        data.put(STREETTYPE, rtnData.cStreetType);
        data.put(CONFIDENCE, rtnData.cConfidence);
        if (rtnData.cCountyName != null && rtnData.cCountyName.length() > 0) {
            data.put(STATEPROVINCESUBDIVISION, rtnData.cCountyName);
        } else {
            data.put(STATEPROVINCESUBDIVISION, " ");
        }
        data.put(FIRMNAME_MATCHED, this.getMatched(rtnData.cAdsFirm));
        data.put(CITYSUBDIVISION_MATCHED, this.getMatched(rtnData.cAdsUrb));
        data.put(HOUSENUMBER_MATCHED, this.getMatched(rtnData.cAdsRange));
        data.put(STREETNAME_MATCHED, this.getMatched(rtnData.cAdsStreetName));
        data.put(STREETTYPE_MATCHED, this.getMatched(rtnData.cAdsSuffix));
        data.put(CITY_MATCHED, this.getMatched(rtnData.cAdsCity));
        data.put(STATEPROVINCE_MATCHED, this.getMatched(rtnData.cAdsState));
        data.put(POSTALCODE_MATCHED, this.getMatched(rtnData.cAdsZip));
        if (preferences != null && preferences.isReturnPrecisionCode()) {
            data.put(PRECISIONCODE, this.createPrecisionCode(rtnData));
        }
        if (preferences != null && preferences.isReturnCountrySpecificFields()) {
            data.put("USA.CarrierRouteCode", rtnData.cCrRte);
            data.put("USA.CarrierRouteCode.Auto", rtnData.cAutoCR);
            data.put("USA.Apartment1", rtnData.cUnit1);
            data.put("USA.Apartment2", rtnData.cUnit2);
            data.put("USA.PrivateMailbox", rtnData.cPMBUnit);
            if (preferences != null && preferences.getAssign_LOT() != null && preferences.getAssign_LOT().equals("ON")) {
                data.put("USA.LOTCode", rtnData.cLOTCode);
                data.put("USA.LOTSequence", "");
                if (rtnData.cLOTCode.length() > 4) {
                    data.put("USA.LOTSequence", rtnData.cLOTCode.substring(4, 5));
                }
            }
            if (preferences != null && preferences.isReturnParsedInputAddress()) {
                data.put("USA.Parsed.Range", rtnData.cRange);
                data.put("USA.Parsed.PreDirectional", rtnData.cPreDirectional);
                data.put("USA.Parsed.StreetName", rtnData.cStreetName);
                data.put("USA.Parsed.StreetSuffix", rtnData.cStreetSuffix);
                data.put("USA.Parsed.PostDirectional", rtnData.cPostDirectional);
                data.put("USA.Parsed.UnitDesignator", rtnData.cUnitDesignator);
                data.put("USA.Parsed.UnitNumber", rtnData.cUnitNumber);
                data.put("USA.Parsed.Unit2Designator", rtnData.cUnit2Designator);
                data.put("USA.Parsed.Unit2Number", rtnData.cUnit2Number);
                data.put("USA.Parsed.PMUnitDesignator", rtnData.cPMUnitDesignator);
                data.put("USA.Parsed.PMUnitNumber", rtnData.cPMUnitNumber);
                data.put("USA.Parsed.AltRange", rtnData.cAltRange);
                data.put("USA.Parsed.AltPreDirectional", rtnData.cAltPreDir);
                data.put("USA.Parsed.AltStreetName", rtnData.cAltStreetName);
                data.put("USA.Parsed.AltPostDirectional", rtnData.cAltPostDir);
                data.put("USA.Parsed.AltStreetSuffix", rtnData.cAltSuffix);
            }
            data.put("USA.AddressLocation", rtnData.cAddressLoc);
            if (rtnData.cAlternateStreetType != null && !rtnData.cAlternateStreetType.equals(" ")) {
                data.put("USA.AltStreetType", rtnData.cAlternateStreetType);
                data.put("USA.AltStreet", rtnData.cAlternateStreet);
            }
            data.put("USA.FullCityName", rtnData.cFullCityName);
            data.put("USA.AbbreviatedCityName", rtnData.cAbbrCityName);
            data.put("USA.NonMailingCityName", rtnData.cNonMailingCityName);
            data.put("USA.PreferredCityName", rtnData.cPreferredCityName);
            data.put("USA.PreferredState", rtnData.cPreferredState);
            if (rtnData.cCongressionalDist != null && rtnData.cCongressionalDist.length() > 0) {
                data.put("USA.CongressionalDistrict", rtnData.cCongressionalDist);
            } else {
                data.put("USA.CongressionalDistrict", " ");
            }
            if (rtnData.cCountyName != null && rtnData.cCountyName.length() > 0) {
                data.put("USA.FIPSCountyNumber", rtnData.cFIPSCode);
            } else {
                data.put("USA.FIPSCountyNumber", " ");
            }
            data.put("USA.ZIPValid", rtnData.cZipValid);
            data.put("USA.ZIP4Valid", "N");
            if (rtnData.cZip4.length() > 0) {
                data.put("USA.ZIP4Valid", "Y");
            }
            if (preferences != null && preferences.getEarly_Warning_System() != null && preferences.getEarly_Warning_System().equals("ON")) {
                data.put("USA.EWSFailure", "");
                int i = 0;
                try {
                    i = Integer.parseInt(rtnData.cFailureType, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (BigInteger.valueOf(i).testBit(3)) {
                    data.put("USA.EWSFailure", "Y");
                }
            }
            if (rtnData.cDelPoint != null && rtnData.cDelPoint.length() > 2) {
                data.put("USA.PostalBarcode", rtnData.cDelPoint.substring(0, 2));
                data.put("USA.BCCheckDigit", rtnData.cDelPoint.substring(2, 3));
            } else {
                data.put("USA.PostalBarcode", "");
                data.put("USA.BCCheckDigit", "");
            }
            data.put("USA.AdvancedBarcode", rtnData.cAdvanceBarcode);
            data.put("USA.FiveDigitBarcode", rtnData.cFiveDigitBarcode);
            data.put("USA.FiveDigitScheme", rtnData.cFiveDigitScheme);
            data.put("USA.MatchLevel", rtnData.cMatchLevel);
            data.put("USA.DefaultMatch", rtnData.cDefaultMatch);
            if (preferences != null && preferences.getDPV_Indicator() != null && preferences.getDPV_Indicator().equals("Y")) {
                if (rtnData.cDPVFlags != null) {
                    if (rtnData.cDPVFlags.length() > 0) {
                        data.put("USA.DPV", rtnData.cDPVFlags.substring(0, 1));
                    } else {
                        data.put("USA.DPV", "");
                    }
                    if (rtnData.cDPVFlags.length() > 1) {
                        data.put("USA.DPV.CMRA", rtnData.cDPVFlags.substring(1, 2));
                    } else {
                        data.put("USA.DPV.CMRA", "");
                    }
                    if (rtnData.cDPVFlags.length() > 2) {
                        data.put("USA.DPV.FalsePositive", rtnData.cDPVFlags.substring(2, 3));
                    } else {
                        data.put("USA.DPV.FalsePositive", "");
                    }
                }
                data.put("USA.DPV.Footnote", rtnData.cDPVFootnote);
                data.put("USA.DPV.PBSAFound", rtnData.cDPVPBSAFound);
                if (rtnData.cPOBoxZone != null && rtnData.cPOBoxZone.equals("Y")) {
                    data.put("USA.POBoxOnly", "Y");
                } else {
                    data.put("USA.POBoxOnly", "N");
                }
                data.put("USA.DPV.NoStat", rtnData.cDPVNoStatFound);
                data.put("USA.DPV.Vacant", rtnData.cDPVVacantFound);
                data.put("USA.DPV.SeasonalFlags", rtnData.cSeasonalFlags);
                data.put("USA.DPV.DNA", rtnData.cDPVDNAFound);
                data.put("USA.DPV.Throwback", rtnData.cDPVTHRWBKFound);
                data.put("USA.DPV.NSL", rtnData.cDPVNSLFound);
                data.put("USA.DPV.SeedHit", rtnData.DPVSeedHit);
                data.put("USA.DPV.ZIP4", rtnData.cDPVZip4);
                data.put("USA.DPV.Range", rtnData.cPrimeRange_dpv);
                data.put("USA.DPV.LeadingDirectional", rtnData.cStreetPreDir_dpv);
                data.put("USA.DPV.StreetName", rtnData.cStreetName_dpv);
                data.put("USA.DPV.Suffix", rtnData.cStreetSfx_dpv);
                data.put("USA.DPV.TrailingDirectional", rtnData.cStreetPostDir_dpv);
                data.put("USA.DPV.UnitDesignator", rtnData.cUnitDesignator_dpv);
                data.put("USA.DPV.UnitNumber", rtnData.cUnitNumber_dpv);
                data.put("USA.DPV.MatchedZIP", rtnData.cMatchedZipCode_dpv);
                data.put("USA.DPV.MatchedZIP4", rtnData.cMatchedPlus4_dpv);
            }
            if (preferences != null && preferences.getLACSLink_Indicator() != null && preferences.getLACSLink_Indicator().equals("ON")) {
                data.put("USA.LACS", rtnData.cLACS);
                if (rtnData.LACSSeedHit.equals("Y")) {
                    data.put("USA.LACS.SeedHit", "Y");
                    data.put("USA.LACS.Indicator", "F");
                } else {
                    data.put("USA.LACS.SeedHit", " ");
                    if (rtnData.cLACSRtnCode.equals("A ")) {
                        data.put("USA.LACS.Indicator", "Y");
                    } else if (rtnData.cLACSRtnCode.equals("09")) {
                        data.put("USA.LACS.Indicator", "Y");
                    } else if (rtnData.cLACSRtnCode.equals("14")) {
                        data.put("USA.LACS.Indicator", "Y");
                    } else if (rtnData.cLACSRtnCode.equals("92")) {
                        data.put("USA.LACS.Indicator", "S");
                    } else if (rtnData.cLACSRtnCode.equals("00")) {
                        data.put("USA.LACS.Indicator", "N");
                    } else {
                        data.put("USA.LACS.Indicator", " ");
                    }
                }
                data.put("USA.LACS.PreLACSAddress", rtnData.cPreLACSAddress);
                data.put("USA.LACS.PreLACSRange", rtnData.cPrimeRange_Lacs);
                data.put("USA.LACS.PreLACSLeadingDirectional", rtnData.cStreetPreDir_Lacs);
                data.put("USA.LACS.PreLACSStreetName", rtnData.cStreetName_Lacs);
                data.put("USA.LACS.PreLACSSuffix", rtnData.cStreetSfx_Lacs);
                data.put("USA.LACS.PreLACSTrailingDirectional", rtnData.cStreetPostDir_Lacs);
                data.put("USA.LACS.PreLACSUnitD", rtnData.cUnitDesignator_Lacs);
                data.put("USA.LACS.PreLACSUnitN", rtnData.cUnitNumber_Lacs);
                data.put("USA.LACS.PreLACSMatchedZIP", rtnData.cMatchedZipCode_Lacs);
                data.put("USA.LACS.PreLACSMatchedZIP4", rtnData.cMatchedPlus4_Lacs);
                data.put("USA.LACS.ReturnCode", rtnData.cLACSRtnCode);
            }
            if (preferences != null && preferences.getSuiteLink_Indicator() != null && preferences.getSuiteLink_Indicator().equals("ON")) {
                data.put("USA.SuiteLink.ReturnCode", rtnData.cSteLnkRtnCode);
                data.put("USA.SuiteLink.MatchCode", rtnData.cSteLnkMatchCode);
                data.put("USA.SuiteLink.Fidelity", rtnData.cSteLnkFidelityCode);
            }
            if (preferences != null && preferences.getResidential_Delivery_Indicator() != null && preferences.getResidential_Delivery_Indicator().equals("ON")) {
                data.put("USA.RDI", rtnData.cRDI);
            }
            data.put("USA.Status.Code", rtnData.cError);
            rtnData.setErrorMsg(data);
            if (preferences.getVM_Datablock().equals("ON")) {
                // empty if block
            }
            if (preferences != null && preferences.getCASS_FLAG() != null && preferences.getCASS_FLAG().equals("ON")) {
                if (rtnData.cAbbrCityName != null && rtnData.cCrRte != null && !rtnData.cAbbrCityName.isEmpty() && !rtnData.cCrRte.isEmpty()) {
                    data.put("USA.CASSCityName", rtnData.cAbbrCityName);
                } else {
                    data.put("USA.CASSCityName", rtnData.cCity);
                }
                if (rtnData.iProcessReturnCode == 1) {
                    this.fmtCASSAddressLine(data, rtnData);
                } else {
                    data.put("USA.CASSAddressLine1", rtnData.cAddress1);
                    data.put("USA.CASSAddressLine2", rtnData.cAddress2);
                }
            }
        }
        ValidationUtils.removeEmptyValues(data);
        return data;
    }

    private String getMatched(String v) {
        if (v.equals("80")) {
            return "true";
        }
        return "false";
    }
}

