/*
 * Decompiled with CFR 0.152.
 */
package com.pb.addressing.confidence;

import com.mapinfo.geocode.api.Address;
import com.mapinfo.geocode.api.FieldsMatching;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ConfidenceFieldStatus {
    protected static final int SUCCESS = 0;
    protected static final int CHANGED = 1;
    protected static final int FILLED = 2;
    protected static final int FAILURE = 3;
    private static final int RC_POS_HOUSE_NUMBER = 2;
    private static final int RC_POS_STREET_NAME = 4;
    private static final int RC_POS_CITY = 7;
    private static final int RC_POS_POSTAL_CODE = 8;
    private static final String RC_HOUSE_NUMBER = "H";
    private static final String RC_STREET_NAME = "N";
    private static final String RC_CITY = "C";
    private static final String RC_POSTAL_CODE = "Z";

    protected int getCityStatus(String precisionCode, FieldsMatching fieldsMatchingMap, Map<String, String> parsedInputAddressMap, Address address) {
        if (precisionCode != null && Pattern.compile("G[1-4]").matcher(precisionCode).find()) {
            return 0;
        }
        if (parsedInputAddressMap.size() != 0 && address != null) {
            String parsedInputCity = parsedInputAddressMap.get("ParsedCity.Input");
            String addressCity = address.getAreaName3();
            boolean isMatchOnCity = fieldsMatchingMap.isMatchOnAreaName3();
            if (precisionCode.length() >= 7 && StringUtils.equalsIgnoreCase((String)Character.toString(precisionCode.charAt(7)), (String)RC_CITY)) {
                return 0;
            }
            return this.getMandatoryFieldStatus(parsedInputCity, addressCity, isMatchOnCity);
        }
        return 3;
    }

    protected int getCountyStatus(FieldsMatching fieldsMatchingMap, Map<String, String> parsedInputAddressMap, Address address) {
        if (parsedInputAddressMap.size() != 0 && address != null) {
            String parsedInputCounty = parsedInputAddressMap.get("ParsedStateProvinceSubdivision.Input");
            String addressCounty = address.getAreaName2();
            boolean isMatchOnCounty = fieldsMatchingMap.isMatchOnAreaName2();
            return this.getMandatoryFieldStatus(parsedInputCounty, addressCounty, isMatchOnCounty);
        }
        return 3;
    }

    protected int getStateStatus(FieldsMatching fieldsMatchingMap, Map<String, String> parsedInputAddressMap, Address address) {
        if (parsedInputAddressMap.size() != 0 && address != null) {
            String parsedInputState = parsedInputAddressMap.get("ParsedStateProvince.Input");
            String addressState = address.getAreaName1();
            boolean isMatchOnState = fieldsMatchingMap.isMatchOnAreaName1();
            return this.getMandatoryFieldStatus(parsedInputState, addressState, isMatchOnState);
        }
        return 3;
    }

    protected int getPostalCodeStatus(String precisionCode, FieldsMatching fieldsMatchingMap, Map<String, String> parsedInputAddressMap, Address address) {
        if (precisionCode != null && Pattern.compile("Z[1-3]").matcher(precisionCode).find()) {
            return 0;
        }
        if (parsedInputAddressMap.size() != 0 && address != null) {
            String parsedInputPostCode = parsedInputAddressMap.get("ParsedPostCodeBase.Input");
            String addressPostCode = address.getPostCode1();
            boolean isMatchOnPostCode = fieldsMatchingMap.isMatchOnPostCode1();
            if (precisionCode.length() >= 8 && StringUtils.equalsIgnoreCase((String)Character.toString(precisionCode.charAt(8)), (String)RC_POSTAL_CODE)) {
                return 0;
            }
            return this.getMandatoryFieldStatus(parsedInputPostCode, addressPostCode, isMatchOnPostCode);
        }
        return 3;
    }

    protected int getStreetNameStatus(String precisionCode, FieldsMatching fieldsMatchingMap, Map<String, String> parsedInputAddressMap, Address address) {
        if (parsedInputAddressMap.size() != 0 && address != null) {
            String parsedInputStreetName = parsedInputAddressMap.get("FormattedInputStreet");
            String addressStreetName = address.getStreetName();
            boolean isMatchOnStreet = fieldsMatchingMap.isMatchOnStreetName();
            if (precisionCode.length() >= 4 && StringUtils.equalsIgnoreCase((String)Character.toString(precisionCode.charAt(4)), (String)RC_STREET_NAME)) {
                return 0;
            }
            return this.getMandatoryFieldStatus(parsedInputStreetName, addressStreetName, isMatchOnStreet);
        }
        return 3;
    }

    protected int getHouseNumberStatus(String precisionCode, FieldsMatching fieldsMatchingMap, Map<String, String> parsedInputAddressMap, Address address) {
        if (parsedInputAddressMap.size() != 0 && address != null) {
            String parsedInputAddressNumber = parsedInputAddressMap.get("ParsedHouseNumber.Input");
            String addressHouseNumber = address.getAddressNumber();
            boolean isMatchOnAddressNumber = fieldsMatchingMap.isMatchOnAddressNumber();
            if (isMatchOnAddressNumber || precisionCode.length() > 2 && StringUtils.equalsIgnoreCase((String)Character.toString(precisionCode.charAt(2)), (String)RC_HOUSE_NUMBER)) {
                return 0;
            }
            if (!StringUtils.isEmpty((String)addressHouseNumber) && StringUtils.isEmpty((String)parsedInputAddressNumber)) {
                return 2;
            }
            if (!StringUtils.equalsIgnoreCase((String)parsedInputAddressNumber, (String)addressHouseNumber)) {
                return 1;
            }
        }
        return 3;
    }

    private int getMandatoryFieldStatus(String parsedInputField, String address, boolean isMatchOnField) {
        if (isMatchOnField) {
            return 0;
        }
        if (!StringUtils.isEmpty((String)address) && StringUtils.isEmpty((String)parsedInputField)) {
            return 2;
        }
        if (!StringUtils.equalsIgnoreCase((String)parsedInputField, (String)address)) {
            return 1;
        }
        return 3;
    }

    public int getApartmentNumberStatus(Map<String, String> parsedInputAddressMap, Address address) {
        if (parsedInputAddressMap.size() != 0 && address != null) {
            String parsedInputAddressUnitValue = parsedInputAddressMap.get("ParsedApartmentNumber.Input");
            String addressUnitValue = address.getUnitValue();
            return this.getFieldStatus(parsedInputAddressUnitValue, addressUnitValue);
        }
        return 3;
    }

    private int getFieldStatus(String parsedInputCountry, String addressCountry) {
        if (StringUtils.equalsIgnoreCase((String)parsedInputCountry, (String)addressCountry)) {
            return 0;
        }
        if (!StringUtils.isEmpty((String)addressCountry) && StringUtils.isEmpty((String)parsedInputCountry)) {
            return 2;
        }
        if (!StringUtils.equalsIgnoreCase((String)parsedInputCountry, (String)addressCountry)) {
            return 1;
        }
        return 3;
    }
}

